/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.logging;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import org.openrdf.http.object.logging.LogMessageFormatter;
import org.openrdf.http.object.logging.LoggingPropertiesMXBean;

public class LoggingProperties
extends NotificationBroadcasterSupport
implements LoggingPropertiesMXBean {
    private final File file;
    private Formatter formatter;
    private Handler nh;

    public LoggingProperties() {
        this(LoggingProperties.getDefaultLoggingPropertiesFile());
    }

    public LoggingProperties(File loggingProperties) {
        this.file = loggingProperties;
        this.formatter = new LogMessageFormatter();
        this.nh = new NotificationHandler();
        this.nh.setFormatter(this.formatter);
        this.nh.setLevel(Level.ALL);
    }

    public File getLoggingPropertiesFile() {
        return this.file;
    }

    @Override
    public void startNotifications(String loggerName) {
        Logger logger = LogManager.getLogManager().getLogger(loggerName);
        if (logger == null) {
            throw new IllegalArgumentException("No such logger: " + loggerName);
        }
        logger.removeHandler(this.nh);
        logger.addHandler(this.nh);
    }

    @Override
    public void stopNotifications() {
        Enumeration<String> names = LogManager.getLogManager().getLoggerNames();
        while (names.hasMoreElements()) {
            String name = names.nextElement();
            Logger.getLogger(name).removeHandler(this.nh);
        }
    }

    @Override
    public void logAll(String pkg) throws IOException {
        this.appendLoggingProperties(pkg + ".level=ALL");
    }

    @Override
    public void logInfo(String pkg) throws IOException {
        this.appendLoggingProperties(pkg + ".level=INFO");
    }

    @Override
    public void logWarn(String pkg) throws IOException {
        this.appendLoggingProperties(pkg + ".level=WARN");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized String getLoggingProperties() throws IOException {
        if (!this.file.isFile()) {
            return null;
        }
        StringWriter writer = new StringWriter();
        FileReader reader = new FileReader(this.file);
        try {
            int read;
            char[] cbuf = new char[1024];
            while ((read = reader.read(cbuf)) >= 0) {
                writer.write(cbuf, 0, read);
            }
            String string = writer.toString();
            return string;
        }
        finally {
            reader.close();
        }
    }

    @Override
    public synchronized void setLoggingProperties(String properties) throws IOException {
        LogManager.getLogManager().readConfiguration(new ByteArrayInputStream(properties.getBytes()));
        this.file.getParentFile().mkdirs();
        FileWriter writer = new FileWriter(this.file);
        try {
            writer.write(properties);
        }
        finally {
            writer.close();
        }
    }

    private static File getDefaultLoggingPropertiesFile() {
        String file = System.getProperty("java.util.logging.config.file");
        if (file == null) {
            return new File("etc/logging.properties");
        }
        return new File(file);
    }

    private synchronized void appendLoggingProperties(String properties) throws IOException {
        this.file.getParentFile().mkdirs();
        FileWriter writer = new FileWriter(this.file, true);
        try {
            writer.write("\n");
            writer.write(properties);
        }
        finally {
            writer.close();
        }
        LogManager.getLogManager().readConfiguration(new FileInputStream(this.file));
    }

    public final class NotificationHandler
    extends Handler {
        @Override
        public void publish(LogRecord record) {
            String type = record.getLevel().toString();
            String source = record.getLoggerName();
            long sequenceNumber = record.getSequenceNumber();
            long timeStamp = record.getMillis();
            if (source.startsWith("javax.management") || source.startsWith("sun.rmi")) {
                return;
            }
            String message = this.getFormatter().formatMessage(record);
            Notification note = new Notification(type, source, sequenceNumber, timeStamp, message);
            if (record.getThrown() != null) {
                try {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    record.getThrown().printStackTrace(pw);
                    pw.close();
                    note.setUserData(sw.toString());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            LoggingProperties.this.sendNotification(note);
        }

        @Override
        public void close() throws SecurityException {
        }

        @Override
        public void flush() {
        }
    }
}

