/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.management;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import org.openrdf.OpenRDFException;
import org.openrdf.http.object.management.JarResolver;
import org.openrdf.model.Model;
import org.openrdf.model.Resource;
import org.openrdf.model.Value;
import org.openrdf.model.impl.TreeModel;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.object.ObjectFactory;
import org.openrdf.repository.object.ObjectService;
import org.openrdf.repository.object.ObjectServiceImpl;
import org.openrdf.repository.object.compiler.OWLCompiler;
import org.openrdf.repository.object.managers.helpers.DirUtil;
import org.openrdf.repository.object.vocabulary.MSG;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.helpers.ContextStatementCollector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompiledObjectSchema
implements ObjectService {
    final Logger logger = LoggerFactory.getLogger(CompiledObjectSchema.class);
    private final AtomicInteger recompile = new AtomicInteger();
    private final Repository repository;
    private final ClassLoader cl;
    private final File libDir;
    private JarResolver resolver;
    private ObjectService service;
    private ObjectService fallback;
    private volatile boolean compiling;

    public CompiledObjectSchema(Repository repository) throws OpenRDFException, IOException {
        this(repository, CompiledObjectSchema.class.getClassLoader());
    }

    public CompiledObjectSchema(Repository repository, ClassLoader cl) throws OpenRDFException, IOException {
        this(repository, DirUtil.createTempDir((String)"object-schema"), cl);
        DirUtil.deleteOnExit((File)this.libDir);
    }

    public CompiledObjectSchema(Repository repository, File libDir, ClassLoader cl) throws OpenRDFException, IOException {
        assert (repository != null && libDir != null && cl != null);
        this.repository = repository;
        this.libDir = libDir;
        this.cl = cl;
        this.fallback = new ObjectServiceImpl(cl);
    }

    public ObjectFactory createObjectFactory() {
        return this.getObjectService().createObjectFactory();
    }

    public JarResolver getJarResolver() {
        return this.resolver;
    }

    public void setJarResolver(JarResolver resolver) {
        this.resolver = resolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recompileSchema() throws IOException, OpenRDFException {
        int num = this.recompile.incrementAndGet();
        File file = this.libDir;
        synchronized (file) {
            if (num == this.recompile.get()) {
                try {
                    this.compiling = true;
                    this.setObjectService(this.compileSchema(this.repository, this.libDir, this.cl));
                }
                finally {
                    this.compiling = false;
                }
            }
        }
    }

    public synchronized boolean isCompiled() {
        return this.service != null;
    }

    public boolean isCompiling() {
        return this.compiling;
    }

    public void setCompiling(boolean compiling) {
        this.compiling = compiling;
    }

    private synchronized ObjectService getObjectService() {
        if (this.service == null) {
            try {
                this.recompileSchema();
            }
            catch (IOException e) {
                this.logger.error(e.toString(), (Throwable)e);
                this.setObjectService(this.fallback);
            }
            catch (OpenRDFException e) {
                this.logger.error(e.toString(), (Throwable)e);
                this.setObjectService(this.fallback);
            }
        }
        return this.service;
    }

    private synchronized void setObjectService(ObjectService service) {
        assert (service != null);
        this.service = service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ObjectService compileSchema(Repository repo, File libDir, ClassLoader cl) throws IOException, OpenRDFException {
        libDir.mkdirs();
        File jar = File.createTempFile("model", ".jar", libDir);
        jar.deleteOnExit();
        TreeModel schema = new TreeModel();
        RepositoryConnection con = repo.getConnection();
        ContextStatementCollector collector = new ContextStatementCollector((Collection)schema, con.getValueFactory(), new Resource[0]);
        try {
            con.export((RDFHandler)collector, new Resource[0]);
        }
        finally {
            con.close();
        }
        OWLCompiler converter = new OWLCompiler(this.resolveJarsInClassPath((Model)schema, cl));
        converter.setNamespaces(collector.getNamespaces());
        converter.setModel((Model)schema);
        ClassLoader child = converter.createJar(jar);
        this.logger.info("Compiled {} into {}", (Object)repo.getDataDir(), (Object)jar);
        return new ObjectServiceImpl(child);
    }

    private synchronized ClassLoader resolveJarsInClassPath(Model schema, ClassLoader cl) {
        if (this.resolver == null) {
            return cl;
        }
        ArrayList<URL> classpath = new ArrayList<URL>();
        for (Value path : schema.filter(null, MSG.CLASSPATH, null, new Resource[0]).objects()) {
            File jar = this.resolver.resolve(path.stringValue());
            if (jar == null) {
                this.logger.warn("Could not resolve JAR {}", (Object)jar);
                continue;
            }
            try {
                classpath.add(jar.toURI().toURL());
            }
            catch (MalformedURLException e) {
                this.logger.warn("Could not resolve JAR {} {}", (Object)jar, (Object)e.getMessage());
            }
        }
        return new URLClassLoader(classpath.toArray(new URL[classpath.size()]), cl);
    }
}

