/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.management;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import org.openrdf.http.object.Version;
import org.openrdf.http.object.management.JVMUsageMBean;

public class JVMUsage
implements JVMUsageMBean {
    @Override
    public String[] getJVMUsage() throws Exception {
        int i = 0;
        String[] result = new String[5];
        result[i++] = this.getOSUsage();
        result[i++] = this.getMemoryUsage();
        result[i++] = this.getRuntimeUsage();
        result[i++] = this.getClassUsage();
        result[i++] = this.getFileSystemUsage();
        return result;
    }

    private String getRuntimeUsage() throws DatatypeConfigurationException {
        StringWriter sw = new StringWriter();
        PrintWriter w = new PrintWriter((Writer)sw, true);
        RuntimeMXBean mx = ManagementFactory.getRuntimeMXBean();
        Date starttime = new Date(mx.getStartTime());
        GregorianCalendar gcal = new GregorianCalendar();
        gcal.setTime(starttime);
        DatatypeFactory df = DatatypeFactory.newInstance();
        String date = df.newXMLGregorianCalendar(gcal).toXMLFormat();
        w.print("VM:\t");
        w.print(System.getProperty("java.vendor"));
        w.print(" ");
        w.print(System.getProperty("java.vm.name"));
        w.print(" ");
        w.println(System.getProperty("java.version"));
        w.print("Server:\t");
        w.println(Version.getInstance().getVersion());
        w.print("User:\t");
        w.println(System.getProperty("user.name"));
        w.println("VM start time:\t" + date);
        w.println("VM up time:\t" + mx.getUptime() + " ms");
        w.print("Available processors (cores):\t");
        w.println(Runtime.getRuntime().availableProcessors());
        w.println("JVM arguments:\t" + mx.getInputArguments());
        return sw.toString();
    }

    private String getClassUsage() {
        StringWriter sw = new StringWriter();
        PrintWriter w = new PrintWriter((Writer)sw, true);
        ClassLoadingMXBean mx = ManagementFactory.getClassLoadingMXBean();
        w.println("Classes loaded:\t" + mx.getLoadedClassCount());
        w.println("Total loaded:\t" + mx.getTotalLoadedClassCount());
        RuntimeMXBean rmx = ManagementFactory.getRuntimeMXBean();
        w.println("Boot class path:\t" + rmx.getBootClassPath());
        w.println("Class path:\t" + rmx.getClassPath());
        return sw.toString();
    }

    private String getOSUsage() throws Exception {
        StringWriter sw = new StringWriter();
        PrintWriter w = new PrintWriter((Writer)sw, true);
        OperatingSystemMXBean mx = ManagementFactory.getOperatingSystemMXBean();
        w.print("OS:\t");
        w.print(System.getProperty("os.name"));
        w.print(" ");
        w.print(System.getProperty("os.version"));
        w.print(" (");
        w.print(System.getProperty("os.arch"));
        w.println(")");
        w.print("Name:\t");
        w.println(mx.getName());
        w.print("Arch:\t");
        w.println(mx.getArch());
        w.print("Version:\t");
        w.println(mx.getVersion());
        w.print("Load average:\t");
        w.println(mx.getSystemLoadAverage());
        return sw.toString();
    }

    private String getMemoryUsage() {
        StringWriter sw = new StringWriter();
        PrintWriter w = new PrintWriter((Writer)sw, true);
        MemoryMXBean mx = ManagementFactory.getMemoryMXBean();
        w.print("Memory used:\t");
        Runtime runtime = Runtime.getRuntime();
        long usedMemory = runtime.totalMemory() - runtime.freeMemory();
        long maxMemory = runtime.maxMemory();
        w.print(usedMemory * 100L / maxMemory);
        w.println("%");
        w.print("Used:\t");
        w.print((int)(usedMemory / 1024L / 1024L));
        w.println("m");
        w.print("Allocated:\t");
        w.print((int)(maxMemory / 1024L / 1024L));
        w.println("m");
        w.print("Pending finalization:\t");
        w.println(mx.getObjectPendingFinalizationCount());
        return sw.toString();
    }

    private String getFileSystemUsage() {
        File[] roots;
        StringWriter sw = new StringWriter();
        PrintWriter w = new PrintWriter((Writer)sw, true);
        for (File root : roots = File.listRoots()) {
            w.print("File system root:\t");
            w.println(root.getAbsolutePath());
            w.print("Size:\t");
            w.print((int)(root.getTotalSpace() / 1024L / 1024L));
            w.println("m");
            w.print("Free:\t");
            w.print((int)(root.getFreeSpace() / 1024L / 1024L));
            w.println("m");
            w.print("Usable:\t");
            w.print((int)(root.getUsableSpace() / 1024L / 1024L));
            w.println("m");
        }
        w.print("Current working directory:\t");
        w.println(new File("").getAbsolutePath());
        return sw.toString();
    }
}

