/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.management;

import java.io.File;
import org.openrdf.http.object.management.ObjectRepositoryManager;
import org.openrdf.repository.object.ObjectRepository;
import org.openrdf.store.blob.BlobObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JarResolver {
    private final Logger logger = LoggerFactory.getLogger(JarResolver.class);
    private final ObjectRepositoryManager manager;

    public JarResolver(ObjectRepositoryManager manager) {
        this.manager = manager;
    }

    public File resolve(String uri) {
        try {
            for (String id : this.manager.getRepositoryIDs()) {
                for (String prefix : this.manager.getRepositoryPrefixes(id)) {
                    ObjectRepository repo;
                    BlobObject blob;
                    File file;
                    if (!uri.startsWith(prefix) || (file = (blob = (repo = this.manager.getObjectRepository(id)).getBlobStore().open(uri)).toFile()) == null) continue;
                    return file;
                }
            }
        }
        catch (Exception e) {
            this.logger.error(e.toString(), (Throwable)e);
        }
        return null;
    }
}

