/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.management;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import org.apache.commons.codec.binary.Base64;
import org.openrdf.http.object.management.KeyStoreMXBean;

public class KeyStoreImpl
implements KeyStoreMXBean {
    private static final int CERT_EXPIRE_DAYS = 31;

    @Override
    public long getCertificateExperation() throws GeneralSecurityException, IOException {
        String alias = this.getKeyAlias();
        char[] password = this.getKeyStorePassword();
        return this.getCertificateExperation(31, alias, this.getKeyStoreFile(), password);
    }

    @Override
    public synchronized String exportCertificate() throws IOException, GeneralSecurityException {
        String alias;
        KeyStore ks = this.loadKeyStore();
        if (!ks.isKeyEntry(alias = this.getKeyAlias())) {
            return null;
        }
        Certificate cer = ks.getCertificate(alias);
        StringBuilder sb = new StringBuilder();
        sb.append("-----BEGIN CERTIFICATE-----\n");
        sb.append(new String(Base64.encodeBase64((byte[])cer.getEncoded())));
        sb.append("\n-----END CERTIFICATE-----\n");
        return sb.toString();
    }

    @Override
    public boolean isCertificateSigned() throws IOException, GeneralSecurityException {
        KeyStore ks = this.loadKeyStore();
        Certificate[] chain = ks.getCertificateChain(this.getKeyAlias());
        return chain != null && chain.length > 1;
    }

    private String getKeyAlias() throws IOException, GeneralSecurityException {
        KeyStore ks = this.loadKeyStore();
        Enumeration<String> aliases = ks.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            if (!ks.isKeyEntry(alias)) continue;
            return alias;
        }
        return null;
    }

    private long getCertificateExperation(int days, String alias, File keystore, char[] password) throws GeneralSecurityException, IOException {
        Certificate cert;
        KeyStore ks = this.loadKeyStore();
        if (ks.isKeyEntry(alias) && (cert = ks.getCertificate(alias)) instanceof X509Certificate) {
            return ((X509Certificate)cert).getNotAfter().getTime();
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyStore loadKeyStore() throws IOException, KeyStoreException, FileNotFoundException, NoSuchAlgorithmException, CertificateException {
        char[] password = this.getKeyStorePassword();
        KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
        File file = this.getKeyStoreFile();
        if (file.exists()) {
            FileInputStream in = new FileInputStream(file);
            try {
                ks.load(in, password);
            }
            finally {
                in.close();
            }
        } else {
            ks.load(null, password);
        }
        return ks;
    }

    private char[] getKeyStorePassword() throws IOException {
        String password = this.getProperty("javax.net.ssl.keyStorePassword");
        if (password == null) {
            return "changeit".toCharArray();
        }
        return password.toCharArray();
    }

    private File getKeyStoreFile() throws IOException {
        String keyStore = this.getProperty("javax.net.ssl.keyStore");
        if (keyStore == null) {
            return new File(System.getProperty("user.home"), ".keystore");
        }
        return new File(keyStore);
    }

    private String getProperty(String key) {
        try {
            return System.getProperty(key);
        }
        catch (SecurityException e) {
            e.printStackTrace(System.err);
            return null;
        }
    }
}

