/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.management;

import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.client.HttpClient;
import org.openrdf.OpenRDFException;
import org.openrdf.http.object.client.HttpClientFactory;
import org.openrdf.http.object.concurrent.ManagedExecutors;
import org.openrdf.http.object.management.CompiledObjectSchema;
import org.openrdf.http.object.management.JarResolver;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.Update;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.config.RepositoryConfig;
import org.openrdf.repository.config.RepositoryConfigException;
import org.openrdf.repository.event.RepositoryConnectionListener;
import org.openrdf.repository.event.base.RepositoryConnectionListenerAdapter;
import org.openrdf.repository.manager.LocalRepositoryManager;
import org.openrdf.repository.manager.RepositoryInfo;
import org.openrdf.repository.manager.RepositoryProvider;
import org.openrdf.repository.manager.SystemRepository;
import org.openrdf.repository.object.ObjectRepository;
import org.openrdf.repository.object.ObjectService;
import org.openrdf.repository.sail.config.RepositoryResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectRepositoryManager
implements RepositoryResolver {
    private static final Pattern HTTP_DOTALL = Pattern.compile("\\s*\\bhttp.*", 32);
    private static final Pattern URL_PATTERN = Pattern.compile("https?://[a-zA-Z0-9\\-\\._~%!\\$\\&'\\(\\)\\*\\+,;=:/\\[\\]@]+/(?![a-zA-Z0-9\\-\\._~%!\\$\\&'\\(\\)\\*\\+,;=:/\\?\\#\\[\\]@])");
    private final HttpClientFactory httpFactory = HttpClientFactory.getInstance();
    private final Map<String, ObjectRepository> repositories = new HashMap<String, ObjectRepository>();
    private final LocalRepositoryManager manager;
    private final CompiledObjectSchema service;
    private final SchemaListener listener;

    public ObjectRepositoryManager(File dataDir) throws OpenRDFException, IOException {
        LocalRepositoryManager manager;
        this.manager = manager = RepositoryProvider.getRepositoryManager((File)dataDir.getCanonicalFile());
        if (manager.getHttpClient() == null) {
            manager.setHttpClient((HttpClient)this.httpFactory.createHttpClient());
        }
        SystemRepository sys = manager.getSystemRepository();
        this.service = new CompiledObjectSchema((Repository)sys);
        this.service.setJarResolver(new JarResolver(this));
        this.listener = new SchemaListener(sys, this.service);
    }

    public ObjectRepositoryManager(File dataDir, ClassLoader cl) throws OpenRDFException, IOException {
        LocalRepositoryManager manager;
        this.manager = manager = RepositoryProvider.getRepositoryManager((File)dataDir.getCanonicalFile());
        if (manager.getHttpClient() == null) {
            manager.setHttpClient((HttpClient)this.httpFactory.createHttpClient());
        }
        SystemRepository sys = manager.getSystemRepository();
        this.service = new CompiledObjectSchema((Repository)sys, cl);
        this.service.setJarResolver(new JarResolver(this));
        this.listener = new SchemaListener(sys, this.service);
    }

    public ObjectRepositoryManager(File dataDir, File libDir, ClassLoader cl) throws OpenRDFException, IOException {
        LocalRepositoryManager manager;
        this.manager = manager = RepositoryProvider.getRepositoryManager((File)dataDir.getCanonicalFile());
        if (manager.getHttpClient() == null) {
            manager.setHttpClient((HttpClient)this.httpFactory.createHttpClient());
        }
        SystemRepository sys = manager.getSystemRepository();
        this.service = new CompiledObjectSchema((Repository)sys, libDir, cl);
        this.service.setJarResolver(new JarResolver(this));
        this.listener = new SchemaListener(sys, this.service);
    }

    public URL getLocation() throws MalformedURLException {
        return this.manager.getLocation();
    }

    public CompiledObjectSchema getObjectSchema() {
        return this.service;
    }

    public synchronized boolean isInitialized() {
        return this.manager.isInitialized();
    }

    public synchronized void refresh() throws RepositoryException {
        for (ObjectRepository repo : this.repositories.values()) {
            repo.shutDown();
        }
        this.repositories.clear();
        this.manager.refresh();
    }

    public synchronized void shutDown() throws RepositoryException {
        this.listener.release();
        for (ObjectRepository repo : this.repositories.values()) {
            repo.shutDown();
        }
        this.repositories.clear();
        this.manager.shutDown();
    }

    public boolean isCompiled() {
        return this.service.isCompiled();
    }

    public boolean isCompiling() {
        return this.service.isCompiling();
    }

    public void recompileSchema() throws IOException, OpenRDFException {
        this.service.recompileSchema();
    }

    public RepositoryConnection openSchemaConnection() throws RepositoryException {
        return this.manager.getSystemRepository().getConnection();
    }

    public synchronized Set<String> getRepositoryIDs() throws RepositoryException {
        return this.manager.getRepositoryIDs();
    }

    public synchronized boolean isRepositoryPresent(String repositoryID) throws RepositoryConfigException, RepositoryException {
        return this.manager.hasRepositoryConfig(repositoryID);
    }

    public synchronized Repository getRepository(String id) throws RepositoryConfigException, RepositoryException {
        return this.manager.getRepository(id);
    }

    public synchronized ObjectRepository getObjectRepository(String id) throws RepositoryConfigException, RepositoryException {
        if (!this.isRepositoryPresent(id)) {
            throw new IllegalArgumentException("Unknown repository ID: " + id);
        }
        if (this.repositories.containsKey(id)) {
            return this.repositories.get(id);
        }
        File dataDir = this.manager.getRepositoryDir(id);
        Repository repo = this.manager.getRepository(id);
        ObjectRepository obj = new ObjectRepository((ObjectService)this.service);
        obj.setDelegate(repo);
        obj.setBlobStoreUrl(new File(dataDir, "blob").toURI().toASCIIString());
        this.repositories.put(id, obj);
        return obj;
    }

    public synchronized void addRepository(RepositoryConfig config) throws OpenRDFException {
        this.manager.addRepositoryConfig(config);
    }

    public synchronized boolean removeRepository(String id) throws OpenRDFException {
        return this.manager.removeRepository(id);
    }

    public synchronized URL getRepositoryLocation(String id) throws OpenRDFException {
        if (!this.isRepositoryPresent(id)) {
            throw new IllegalArgumentException("Unknown repository ID: " + id);
        }
        return this.manager.getRepositoryInfo(id).getLocation();
    }

    public synchronized String[] getRepositoryPrefixes(String id) throws OpenRDFException {
        if (!this.isRepositoryPresent(id)) {
            throw new IllegalArgumentException("Unknown repository ID: " + id);
        }
        RepositoryInfo info = this.manager.getRepositoryInfo(id);
        return this.splitURLs(info.getDescription());
    }

    public synchronized void addRepositoryPrefix(String id, String prefix) throws OpenRDFException {
        if (!prefix.endsWith("/")) {
            throw new IllegalArgumentException("Prefix must end with a slash, this does not: " + prefix);
        }
        RepositoryInfo info = this.manager.getRepositoryInfo(id);
        if (info == null) {
            throw new IllegalArgumentException("Unknown repository ID: " + id);
        }
        if (Arrays.asList(this.splitURLs(info.getDescription())).contains(prefix)) {
            return;
        }
        RepositoryConfig config = this.manager.getRepositoryConfig(id);
        config.setTitle(config.getTitle() + "\n" + prefix);
        this.manager.addRepositoryConfig(config);
    }

    public synchronized void setRepositoryPrefixes(String id, String[] prefixes) throws OpenRDFException {
        RepositoryConfig config;
        if (!this.isRepositoryPresent(id)) {
            throw new IllegalArgumentException("Unknown repository ID: " + id);
        }
        StringBuilder desc = new StringBuilder();
        if (prefixes != null) {
            for (String prefix : prefixes) {
                if (!prefix.endsWith("/")) {
                    throw new IllegalArgumentException("Prefix must end with a slash, this does not: " + prefix);
                }
                desc.append("\n").append(prefix);
            }
        }
        String title = (config = this.manager.getRepositoryConfig(id)).getTitle() == null ? "" : config.getTitle();
        Matcher m = HTTP_DOTALL.matcher(title);
        config.setTitle(m.replaceAll("") + desc);
        this.manager.addRepositoryConfig(config);
    }

    private String[] splitURLs(String desc) {
        Matcher m;
        ArrayList<String> list = new ArrayList<String>();
        Matcher matcher = m = desc != null ? URL_PATTERN.matcher(desc) : null;
        if (m != null && m.find()) {
            do {
                list.add(m.group());
            } while (m.find());
        }
        return list.toArray(new String[list.size()]);
    }

    private static final class SchemaListener
    extends RepositoryConnectionListenerAdapter
    implements Runnable {
        private final Logger logger = LoggerFactory.getLogger(ObjectRepositoryManager.class);
        private final ExecutorService executor = ManagedExecutors.getInstance().newFixedThreadPool(1, "ObjectRepositorySchemaCompiler");
        private final Map<RepositoryConnection, Boolean> changed = new WeakHashMap<RepositoryConnection, Boolean>();
        private final Map<RepositoryConnection, Boolean> modified = new WeakHashMap<RepositoryConnection, Boolean>();
        private final SystemRepository sys;
        private final WeakReference<CompiledObjectSchema> ref;
        private Future<?> recompile;
        private boolean released;

        public SchemaListener(SystemRepository sys, CompiledObjectSchema service) {
            this.sys = sys;
            this.ref = new WeakReference<CompiledObjectSchema>(service);
            sys.addRepositoryConnectionListener((RepositoryConnectionListener)this);
        }

        public synchronized void clear(RepositoryConnection conn, Resource ... contexts) {
            this.modified.put(conn, true);
        }

        public synchronized void remove(RepositoryConnection conn, Resource subject, URI predicate, Value object, Resource ... contexts) {
            this.modified.put(conn, true);
        }

        public synchronized void add(RepositoryConnection conn, Resource subject, URI predicate, Value object, Resource ... contexts) {
            this.modified.put(conn, true);
        }

        public synchronized void execute(RepositoryConnection conn, QueryLanguage ql, String update, String baseURI, Update operation) {
            this.modified.put(conn, true);
        }

        public synchronized void begin(RepositoryConnection conn) {
            if (!this.changed.containsKey(conn) && this.modified.containsKey(conn)) {
                this.changed.put(conn, true);
            }
        }

        public synchronized void rollback(RepositoryConnection conn) {
            this.modified.remove(conn);
        }

        public synchronized void commit(RepositoryConnection conn) {
            if (!this.changed.containsKey(conn) && this.modified.containsKey(conn)) {
                this.changed.put(conn, true);
            }
        }

        public void close(RepositoryConnection conn) {
            this.awaitRecompile(this.submitRecompile(conn));
        }

        public synchronized void release() {
            this.released = true;
            this.sys.removeRepositoryConnectionListener((RepositoryConnectionListener)this);
            this.executor.shutdown();
        }

        @Override
        public void run() {
            try {
                CompiledObjectSchema service = (CompiledObjectSchema)this.ref.get();
                if (service == null) {
                    this.release();
                } else if (service.isCompiled()) {
                    service.recompileSchema();
                }
            }
            catch (IOException e) {
                this.logger.error(e.toString(), (Throwable)e);
            }
            catch (OpenRDFException e) {
                this.logger.error(e.toString(), (Throwable)e);
            }
            catch (RuntimeException e) {
                this.logger.error(e.toString(), (Throwable)e);
            }
            catch (Error e) {
                this.logger.error(e.toString(), (Throwable)e);
                throw e;
            }
        }

        private synchronized Future<?> getRecompile() {
            return this.recompile;
        }

        private synchronized Future<?> setRecompile(Future<?> recompile) {
            Future<?> previous = this.recompile;
            this.recompile = recompile;
            return previous;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized Future<?> submitRecompile(RepositoryConnection conn) {
            if (this.changed.containsKey(conn) || this.modified.containsKey(conn)) {
                try {
                    CompiledObjectSchema service = (CompiledObjectSchema)this.ref.get();
                    if (service == null) {
                        this.release();
                    } else if (!this.released && service.isCompiled()) {
                        Future<?> next = this.executor.submit(this);
                        Future<?> previous = this.setRecompile(next);
                        service.setCompiling(true);
                        if (previous != null && !previous.isDone()) {
                            previous.cancel(false);
                        }
                        Future<?> future = next;
                        return future;
                    }
                }
                finally {
                    this.changed.remove(conn);
                    this.modified.remove(conn);
                }
            }
            return null;
        }

        private void awaitRecompile(Future<?> recompile) {
            try {
                if (recompile != null) {
                    if (recompile.isCancelled()) {
                        this.awaitRecompile(this.getRecompile());
                    } else {
                        recompile.get();
                    }
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e) {
                this.logger.error(e.toString(), (Throwable)e);
            }
            catch (CancellationException e) {
                this.awaitRecompile(this.getRecompile());
            }
        }
    }
}

