/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.management;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.TreeSet;
import org.apache.http.HttpInetConnection;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.nio.NHttpConnection;
import org.openrdf.OpenRDFException;
import org.openrdf.http.object.Version;
import org.openrdf.http.object.client.HttpClientFactory;
import org.openrdf.http.object.helpers.Exchange;
import org.openrdf.http.object.helpers.ObjectContext;
import org.openrdf.http.object.management.ConnectionBean;
import org.openrdf.http.object.management.ObjectRepositoryManager;
import org.openrdf.http.object.management.ObjectServerMBean;
import org.openrdf.http.object.management.RepositoryMXBean;
import org.openrdf.http.object.management.RepositoryMXBeanImpl;
import org.openrdf.http.object.management.WebServer;
import org.openrdf.http.object.util.PrefixMap;
import org.openrdf.model.Graph;
import org.openrdf.model.Model;
import org.openrdf.model.Resource;
import org.openrdf.model.Value;
import org.openrdf.model.impl.LinkedHashModel;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.config.RepositoryConfig;
import org.openrdf.repository.config.RepositoryConfigSchema;
import org.openrdf.repository.manager.RepositoryProvider;
import org.openrdf.repository.object.ObjectRepository;
import org.openrdf.repository.object.managers.helpers.DirUtil;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParser;
import org.openrdf.rio.Rio;
import org.openrdf.rio.helpers.StatementCollector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectServer
implements ObjectServerMBean {
    private final Logger logger = LoggerFactory.getLogger(ObjectServer.class);
    private final PrefixMap<ObjectRepositoryManager> managers = new PrefixMap();
    private File serverCacheDir;
    private String serverName = ObjectServer.class.getSimpleName();
    private int[] ports = new int[0];
    private int[] sslPorts = new int[0];
    private int timeout;
    private boolean noDelay;
    private volatile boolean starting;
    private volatile boolean stopping;
    WebServer server;

    public ObjectServer(File ... dataDir) throws OpenRDFException, IOException {
        this(ObjectServer.class.getClassLoader(), dataDir);
    }

    public ObjectServer(ClassLoader cl, File ... dataDir) throws OpenRDFException, IOException {
        for (int i = 0; i < dataDir.length; ++i) {
            dataDir[i].mkdirs();
            ObjectRepositoryManager manager = new ObjectRepositoryManager(dataDir[i], cl);
            this.managers.put(manager.getLocation().toExternalForm(), manager);
        }
        this.serverCacheDir = DirUtil.createTempDir((String)"object-server-cache");
        DirUtil.deleteOnExit((File)this.serverCacheDir);
        File clientCacheDir = DirUtil.createTempDir((String)"http-client-cache");
        DirUtil.deleteOnExit((File)clientCacheDir);
        HttpClientFactory.setCacheDirectory(clientCacheDir);
    }

    public ObjectServer(File cacheDir, ClassLoader cl, File ... dataDir) throws OpenRDFException, IOException {
        File libDir = new File(cacheDir, "lib");
        for (int i = 0; i < dataDir.length; ++i) {
            dataDir[i].mkdirs();
            ObjectRepositoryManager manager = new ObjectRepositoryManager(dataDir[i], libDir, cl);
            this.managers.put(manager.getLocation().toExternalForm(), manager);
        }
        this.serverCacheDir = new File(cacheDir, "server");
        HttpClientFactory.setCacheDirectory(new File(cacheDir, "client"));
    }

    public String toString() {
        try {
            StringBuilder sb = new StringBuilder();
            for (ObjectRepositoryManager manager : this.managers.values()) {
                sb.append(manager.getLocation().toString()).append(' ');
            }
            return sb.toString();
        }
        catch (MalformedURLException e) {
            this.logger.warn(e.toString(), (Throwable)e);
            return this.managers.values().toString();
        }
    }

    @Override
    public String getServerName() throws IOException {
        String name = this.serverName;
        if (name == null || name.length() == 0) {
            return Version.getInstance().getVersion();
        }
        return name;
    }

    @Override
    public synchronized void setServerName(String name) throws IOException {
        this.serverName = name == null || name.length() == 0 || name.equals(Version.getInstance().getVersion()) ? null : name;
        if (this.server != null) {
            this.server.setName(this.getServerName());
        }
    }

    @Override
    public String getPorts() throws IOException {
        int[] ports = this.ports;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < ports.length; ++i) {
            sb.append(ports[i]);
            if (i >= ports.length - 1) continue;
            sb.append(' ');
        }
        return sb.toString();
    }

    @Override
    public synchronized void setPorts(String portStr) throws IOException {
        this.ports = this.parsePorts(portStr);
        if (this.server != null) {
            this.server.listen(this.ports, this.sslPorts);
        }
    }

    @Override
    public String getSSLPorts() throws IOException {
        int[] ports = this.sslPorts;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < ports.length; ++i) {
            sb.append(ports[i]);
            if (i >= ports.length - 1) continue;
            sb.append(' ');
        }
        return sb.toString();
    }

    @Override
    public synchronized void setSSLPorts(String portStr) throws IOException {
        this.sslPorts = this.parsePorts(portStr);
        if (this.server != null) {
            this.server.listen(this.ports, this.sslPorts);
        }
    }

    @Override
    public int getTimeout() {
        return this.timeout;
    }

    @Override
    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public boolean isTcpNoDelay() {
        return this.noDelay;
    }

    public void setTcpNoDelay(boolean noDelay) {
        this.noDelay = noDelay;
    }

    public boolean isCaching() {
        return this.serverCacheDir != null;
    }

    public void setCaching(boolean caching) throws IOException {
        if (caching && this.serverCacheDir == null) {
            this.serverCacheDir = DirUtil.createTempDir((String)"object-server-cache");
            DirUtil.deleteOnExit((File)this.serverCacheDir);
            File clientCacheDir = DirUtil.createTempDir((String)"http-client-cache");
            DirUtil.deleteOnExit((File)clientCacheDir);
            HttpClientFactory.setCacheDirectory(clientCacheDir);
            this.logger.info("Enabling server side caching");
        } else if (!caching && this.serverCacheDir != null) {
            this.serverCacheDir = null;
            HttpClientFactory.setCacheDirectory(null);
            this.logger.info("Disabling server side caching");
        }
    }

    @Override
    public boolean isStartingInProgress() {
        return this.starting;
    }

    @Override
    public boolean isStoppingInProgress() {
        return this.stopping;
    }

    @Override
    public boolean isCompilingInProgress() {
        for (ObjectRepositoryManager manager : this.managers.values()) {
            if (!manager.isCompiling()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isRunning() {
        return this.server != null && this.server.isRunning() && !this.stopping;
    }

    @Override
    public boolean isShutDown() {
        for (ObjectRepositoryManager manager : this.managers.values()) {
            if (!manager.isInitialized()) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getStatus() {
        return this.server.getStatus();
    }

    @Override
    public void poke() {
        if (this.server != null) {
            this.server.poke();
        }
    }

    @Override
    public void resetCache() {
        this.server.resetCache();
    }

    @Override
    public synchronized void recompileSchema() throws IOException, OpenRDFException {
        try {
            for (ObjectRepositoryManager manager : this.managers.values()) {
                manager.recompileSchema();
            }
        }
        finally {
            this.notifyAll();
        }
    }

    @Override
    public synchronized void resetConnections() throws IOException {
        this.server.resetConnections();
    }

    @Override
    public synchronized ConnectionBean[] getConnections() {
        NHttpConnection[] connections = this.server.getOpenConnections();
        ConnectionBean[] beans = new ConnectionBean[connections.length];
        for (int i = 0; i < connections.length; ++i) {
            ObjectContext ctx;
            Exchange[] array;
            HttpResponse resp;
            HttpRequest req;
            ConnectionBean bean = new ConnectionBean();
            NHttpConnection conn = connections[i];
            beans[i] = bean;
            switch (conn.getStatus()) {
                case 0: {
                    if (conn.isOpen()) {
                        bean.setStatus("OPEN");
                        break;
                    }
                    if (conn.isStale()) {
                        bean.setStatus("STALE");
                        break;
                    }
                    bean.setStatus("ACTIVE");
                    break;
                }
                case 1: {
                    bean.setStatus("CLOSING");
                    break;
                }
                case 2: {
                    bean.setStatus("CLOSED");
                }
            }
            if (conn instanceof HttpInetConnection) {
                HttpInetConnection inet = (HttpInetConnection)conn;
                InetAddress ra = inet.getRemoteAddress();
                int rp = inet.getRemotePort();
                InetAddress la = inet.getLocalAddress();
                int lp = inet.getLocalPort();
                if (ra != null && la != null) {
                    InetSocketAddress remote = new InetSocketAddress(ra, rp);
                    InetSocketAddress local = new InetSocketAddress(la, lp);
                    bean.setStatus(bean.getStatus() + " " + remote + "->" + local);
                }
            }
            if ((req = conn.getHttpRequest()) != null) {
                bean.setRequest(req.getRequestLine().toString());
            }
            if ((resp = conn.getHttpResponse()) != null) {
                bean.setResponse(resp.getStatusLine().toString() + " " + resp.getEntity());
            }
            if ((array = (ctx = ObjectContext.adapt(conn.getContext())).getPendingExchange()) != null) {
                String[] pending = new String[array.length];
                for (int j = 0; j < pending.length; ++j) {
                    pending[j] = array[j].toString();
                    if (!array[j].isReadingRequest()) continue;
                    bean.setConsuming(array[j].toString());
                }
                bean.setPending(pending);
                continue;
            }
            bean.setPending(new String[0]);
        }
        return beans;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connectionDumpToFile(String outputFile) throws IOException {
        PrintWriter writer = new PrintWriter(new FileWriter(outputFile, true));
        try {
            writer.println("status,request,consuming,response,pending");
            for (ConnectionBean connection : this.getConnections()) {
                writer.print(this.toString(connection.getStatus()));
                writer.print(",");
                writer.print(this.toString(connection.getRequest()));
                writer.print(",");
                writer.print(this.toString(connection.getConsuming()));
                writer.print(",");
                writer.print(this.toString(connection.getResponse()));
                writer.print(",");
                String[] pending = connection.getPending();
                if (pending != null) {
                    for (String p : pending) {
                        writer.print(this.toString(p));
                        writer.print(",");
                    }
                }
                writer.println();
            }
            writer.println();
            writer.println();
        }
        finally {
            writer.close();
        }
        this.logger.info("Connection dump: {}", (Object)outputFile);
    }

    public RepositoryConnection openSchemaConnection(String location) throws OpenRDFException {
        ObjectRepositoryManager manager = this.managers.getClosest(location);
        if (manager == null) {
            throw new IllegalArgumentException("Unknown repository location: " + location);
        }
        return manager.openSchemaConnection();
    }

    @Override
    public synchronized String[] getRepositoryLocations() throws OpenRDFException {
        TreeSet<String> result = new TreeSet<String>();
        for (ObjectRepositoryManager manager : this.managers.values()) {
            for (String id : manager.getRepositoryIDs()) {
                result.add(manager.getRepositoryLocation(id).toExternalForm());
            }
        }
        return result.toArray(new String[result.size()]);
    }

    public RepositoryMXBean getRepositoryMXBean(String location) throws OpenRDFException {
        String id = RepositoryProvider.getRepositoryIdOfRepository((String)location);
        return new RepositoryMXBeanImpl(this.getManagerFor(location), id);
    }

    public ObjectRepository getRepository(String location) throws OpenRDFException {
        String id = RepositoryProvider.getRepositoryIdOfRepository((String)location);
        return this.getManagerFor(location).getObjectRepository(id);
    }

    @Override
    public String[] getRepositoryPrefixes(String location) throws OpenRDFException {
        String id = RepositoryProvider.getRepositoryIdOfRepository((String)location);
        return this.getManagerFor(location).getRepositoryPrefixes(id);
    }

    @Override
    public synchronized void addRepositoryPrefix(String location, String prefix) throws OpenRDFException {
        String id = RepositoryProvider.getRepositoryIdOfRepository((String)location);
        ObjectRepositoryManager manager = this.getManagerFor(location);
        manager.addRepositoryPrefix(id, prefix);
        if (this.server != null) {
            this.startRepository(manager, id);
        }
        this.notifyAll();
    }

    @Override
    public synchronized void setRepositoryPrefixes(String location, String[] prefixes) throws OpenRDFException {
        String id = RepositoryProvider.getRepositoryIdOfRepository((String)location);
        ObjectRepositoryManager manager = this.getManagerFor(location);
        if (this.server != null) {
            String[] existing = manager.getRepositoryPrefixes(id);
            ArrayList<String> removed = new ArrayList<String>(Arrays.asList(existing));
            removed.removeAll(Arrays.asList(prefixes));
            for (String rem : removed) {
                this.server.removeRepository(rem);
            }
        }
        manager.setRepositoryPrefixes(id, prefixes);
        if (this.server != null) {
            this.startRepository(manager, id);
        }
        this.notifyAll();
    }

    @Override
    public synchronized String addRepository(String location, String base, String configString) throws OpenRDFException, IOException {
        Resource node;
        ObjectRepositoryManager manager = this.managers.getClosest(location);
        if (manager == null) {
            throw new IllegalArgumentException("Unknown repository location: " + location);
        }
        Model graph = this.parseTurtleGraph(manager, configString, base);
        RepositoryConfig config = RepositoryConfig.create((Graph)graph, (Resource)(node = graph.filter(null, RDF.TYPE, (Value)RepositoryConfigSchema.REPOSITORY, new Resource[0]).subjectResource()));
        String id = config.getID();
        if (manager.isRepositoryPresent(id) && this.server != null) {
            String[] existing = manager.getRepositoryPrefixes(id);
            ArrayList<String> removed = new ArrayList<String>(Arrays.asList(existing));
            manager.addRepository(config);
            removed.removeAll(Arrays.asList(manager.getRepositoryPrefixes(id)));
            for (String rem : removed) {
                this.server.removeRepository(rem);
            }
        } else {
            manager.addRepository(config);
        }
        if (this.server != null) {
            this.startRepository(manager, id);
        }
        this.notifyAll();
        return manager.getRepositoryLocation(id).toExternalForm();
    }

    @Override
    public synchronized boolean removeRepository(String location) throws OpenRDFException {
        String id = RepositoryProvider.getRepositoryIdOfRepository((String)location);
        ObjectRepositoryManager manager = this.managers.getClosest(location);
        if (manager == null || !manager.isRepositoryPresent(id)) {
            return false;
        }
        this.stopRepository(manager, id);
        this.notifyAll();
        return manager.removeRepository(id);
    }

    @Override
    public synchronized void init() throws OpenRDFException, IOException {
        try {
            this.logger.debug("Initializing {}", (Object)this);
            for (ObjectRepositoryManager manager : this.managers.values()) {
                if (manager.isCompiled()) continue;
                this.recompileSchema();
            }
            if (this.server != null) {
                this.server.destroy();
            }
            this.server = this.createServer(this.serverCacheDir, this.timeout, this.noDelay, this.ports, this.sslPorts);
            for (ObjectRepositoryManager manager : this.managers.values()) {
                for (String id : manager.getRepositoryIDs()) {
                    this.startRepository(manager, id);
                }
            }
        }
        catch (IOException e) {
            this.logger.error(e.toString(), (Throwable)e);
            throw e;
        }
        catch (OpenRDFException e) {
            this.logger.error(e.toString(), (Throwable)e);
            throw e;
        }
        finally {
            this.notifyAll();
        }
    }

    @Override
    public synchronized void start() throws IOException, OpenRDFException {
        if (this.server == null) {
            return;
        }
        try {
            this.logger.debug("Starting {}", (Object)this);
            this.stopping = false;
            this.starting = true;
            if (this.getPorts().length() == 0 && this.getSSLPorts().length() == 0) {
                this.logger.info("{} is not bound to any port", (Object)this.getServerName());
            } else {
                this.logger.info("{} is binding to port {}", (Object)this.getServerName(), (Object)(this.getPorts() + ' ' + this.getSSLPorts()));
            }
            this.server.start();
            System.gc();
            System.runFinalization();
            Thread.yield();
            for (int i = 100; i < 10000 && !this.isRunning(); i *= 2) {
                Thread.sleep(i);
            }
            long uptime = ManagementFactory.getRuntimeMXBean().getUptime();
            this.logger.info("{} started after {} seconds", (Object)this.getServerName(), (Object)((double)uptime / 1000.0));
        }
        catch (IOException e) {
            this.logger.error(e.toString(), (Throwable)e);
            throw e;
        }
        catch (InterruptedException cause) {
            this.logger.error(cause.toString(), (Throwable)cause);
            InterruptedIOException e = new InterruptedIOException(cause.getMessage());
            e.initCause(cause);
            throw e;
        }
        finally {
            this.starting = false;
            this.notifyAll();
        }
    }

    @Override
    public synchronized void stop() throws IOException, OpenRDFException {
        this.logger.debug("Stopping {}", (Object)this);
        this.stopping = true;
        try {
            if (this.server != null) {
                this.server.stop();
            }
        }
        finally {
            this.notifyAll();
        }
    }

    @Override
    public synchronized void destroy() throws IOException, OpenRDFException {
        try {
            this.stop();
            if (this.server != null) {
                this.server.destroy();
                this.server = null;
            }
        }
        finally {
            for (ObjectRepositoryManager manager : this.managers.values()) {
                manager.shutDown();
            }
            this.stopping = false;
            this.logger.debug("Destroyed {}", (Object)this);
            this.notifyAll();
        }
    }

    @Override
    public synchronized void restart() throws IOException, OpenRDFException {
        if (this.server != null) {
            this.server.stop();
        }
        this.resetConnections();
        if (this.server != null) {
            this.server.destroy();
            this.server = null;
        }
        for (ObjectRepositoryManager manager : this.managers.values()) {
            manager.refresh();
        }
        this.recompileSchema();
        this.server = this.createServer(this.serverCacheDir, this.timeout, this.noDelay, this.ports, this.sslPorts);
        this.start();
    }

    private ObjectRepositoryManager getManagerFor(String location) throws OpenRDFException {
        ObjectRepositoryManager manager = this.managers.getClosest(location);
        if (manager == null) {
            throw new IllegalArgumentException("Unknown repository location: " + location);
        }
        String id = RepositoryProvider.getRepositoryIdOfRepository((String)location);
        if (!manager.isRepositoryPresent(id)) {
            throw new IllegalArgumentException("Unknown repository location: " + location);
        }
        return manager;
    }

    private WebServer createServer(File serverCacheDir, int timeout, boolean noDelay, int[] ports, int[] sslPorts) throws OpenRDFException, IOException {
        if (serverCacheDir == null) {
            WebServer server = new WebServer(timeout, noDelay);
            server.setName(this.getServerName());
            server.listen(ports, sslPorts);
            return server;
        }
        serverCacheDir.mkdirs();
        WebServer server = new WebServer(serverCacheDir, timeout, noDelay);
        server.setName(this.getServerName());
        server.listen(ports, sslPorts);
        return server;
    }

    private synchronized void startRepository(ObjectRepositoryManager manager, String id) throws OpenRDFException {
        String[] prefixes = manager.getRepositoryPrefixes(id);
        if (prefixes != null && prefixes.length > 0) {
            URL url = manager.getRepositoryLocation(id);
            ObjectRepository obj = manager.getObjectRepository(id);
            for (String prefix : prefixes) {
                this.logger.info("Serving {} from {}", (Object)prefix, (Object)url);
                this.server.addRepository(prefix, obj);
            }
        }
    }

    private synchronized void stopRepository(ObjectRepositoryManager manager, String id) throws OpenRDFException {
        if (manager.isRepositoryPresent(id)) {
            for (String prefix : this.getRepositoryPrefixes(id)) {
                URL url = manager.getRepositoryLocation(id);
                this.logger.info("Stop serving {}", (Object)prefix, (Object)url);
                this.server.removeRepository(prefix);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Model parseTurtleGraph(ObjectRepositoryManager manager, String configString, String base) throws IOException, OpenRDFException {
        LinkedHashModel graph = new LinkedHashModel();
        RDFParser rdfParser = Rio.createParser((RDFFormat)RDFFormat.TURTLE);
        final RepositoryConnection con = manager.openSchemaConnection();
        try {
            rdfParser.setRDFHandler((RDFHandler)new StatementCollector((Collection)graph){

                public void handleNamespace(String prefix, String uri) throws RDFHandlerException {
                    try {
                        con.setNamespace(prefix, uri);
                    }
                    catch (RepositoryException e) {
                        throw new RDFHandlerException((Throwable)e);
                    }
                }
            });
            rdfParser.parse((Reader)new StringReader(configString), base);
        }
        finally {
            con.close();
        }
        return graph;
    }

    private int[] parsePorts(String portStr) {
        int[] ports = new int[]{};
        if (portStr != null && portStr.length() > 0) {
            ArrayList<String> values = new ArrayList<String>(Arrays.asList(portStr.split("\\D+")));
            values.removeAll(Collections.singleton(""));
            ports = new int[values.size()];
            for (int i = 0; i < ports.length; ++i) {
                ports[i] = Integer.parseInt((String)values.get(i));
            }
        }
        return ports;
    }

    private String toString(String string) {
        if (string == null) {
            return "";
        }
        return string;
    }
}

