/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.management;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import org.openrdf.OpenRDFException;
import org.openrdf.http.object.io.ArrangedWriter;
import org.openrdf.http.object.management.ObjectRepositoryManager;
import org.openrdf.http.object.management.RepositoryMXBean;
import org.openrdf.query.BooleanQuery;
import org.openrdf.query.GraphQuery;
import org.openrdf.query.Query;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResultHandler;
import org.openrdf.query.resultio.text.tsv.SPARQLResultsTSVWriter;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.object.ObjectConnection;
import org.openrdf.repository.object.ObjectRepository;
import org.openrdf.repository.object.exceptions.ObjectStoreConfigException;
import org.openrdf.rio.ParserConfig;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFWriter;
import org.openrdf.rio.helpers.BasicParserSettings;
import org.openrdf.rio.turtle.TurtleWriter;
import org.openrdf.store.blob.BlobObject;
import org.openrdf.store.blob.BlobStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryMXBeanImpl
implements RepositoryMXBean {
    private final Logger logger = LoggerFactory.getLogger(RepositoryMXBeanImpl.class);
    private final ParserConfig parserConfig = new ParserConfig();
    private final ObjectRepositoryManager manager;
    private final String id;

    public RepositoryMXBeanImpl(ObjectRepositoryManager manager, String id) {
        this.manager = manager;
        this.id = id;
        this.parserConfig.set(BasicParserSettings.PRESERVE_BNODE_IDS, (Object)true);
    }

    @Override
    public int getMaxQueryTime() throws OpenRDFException {
        return this.getObjectRepository().getMaxQueryTime();
    }

    @Override
    public void setMaxQueryTime(int maxQueryTime) throws OpenRDFException {
        this.getObjectRepository().setMaxQueryTime(maxQueryTime);
    }

    @Override
    public boolean isIncludeInferred() throws OpenRDFException {
        return this.getObjectRepository().isIncludeInferred();
    }

    @Override
    public void setIncludeInferred(boolean includeInferred) throws OpenRDFException {
        this.getObjectRepository().setIncludeInferred(includeInferred);
    }

    public BlobStore getBlobStore() throws OpenRDFException, ObjectStoreConfigException {
        return this.getObjectRepository().getBlobStore();
    }

    public void setBlobStore(BlobStore store) throws OpenRDFException {
        this.getObjectRepository().setBlobStore(store);
    }

    @Override
    public String[] sparqlQuery(String query) throws OpenRDFException, IOException {
        RepositoryConnection conn = this.getConnection();
        try {
            Query qry = conn.prepareQuery(QueryLanguage.SPARQL, query);
            if (qry instanceof TupleQuery) {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                SPARQLResultsTSVWriter writer = new SPARQLResultsTSVWriter((OutputStream)out);
                ((TupleQuery)qry).evaluate((TupleQueryResultHandler)writer);
                String[] stringArray = new String(out.toByteArray(), "UTF-8").split("\r?\n");
                return stringArray;
            }
            if (qry instanceof BooleanQuery) {
                String[] out = new String[]{String.valueOf(((BooleanQuery)qry).evaluate())};
                return out;
            }
            if (qry instanceof GraphQuery) {
                StringWriter string = new StringWriter(65536);
                TurtleWriter writer = new TurtleWriter((Writer)string);
                ((GraphQuery)qry).evaluate((RDFHandler)new ArrangedWriter((RDFWriter)writer));
                String[] stringArray = string.toString().split("(?<=\\.)\r?\n");
                return stringArray;
            }
            throw new RepositoryException("Unknown query type: " + qry.getClass().getSimpleName());
        }
        finally {
            conn.close();
        }
    }

    @Override
    public void sparqlUpdate(String update) throws OpenRDFException, IOException {
        RepositoryConnection conn = this.getConnection();
        try {
            this.logger.info(update);
            conn.prepareUpdate(QueryLanguage.SPARQL, update).execute();
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String readCharacterBlob(String uri) throws OpenRDFException, IOException {
        ObjectConnection conn = this.getObjectConnection();
        try {
            String string = conn.getBlobObject(uri).getCharContent(true).toString();
            return string;
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] readBinaryBlob(String uri) throws OpenRDFException, IOException {
        ObjectConnection conn = this.getObjectConnection();
        try {
            byte[] byArray;
            BlobObject blob = conn.getBlobObject(uri);
            InputStream in = blob.openInputStream();
            try {
                int read;
                ByteArrayOutputStream baos = new ByteArrayOutputStream((int)blob.getLength());
                byte[] buf = new byte[1024];
                while ((read = in.read(buf)) >= 0) {
                    baos.write(buf, 0, read);
                }
                byArray = baos.toByteArray();
            }
            catch (Throwable throwable) {
                in.close();
                throw throwable;
            }
            in.close();
            return byArray;
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeCharacterBlob(String uri, String content) throws OpenRDFException, IOException {
        ObjectConnection conn = this.getObjectConnection();
        try {
            this.logger.warn("Replacing {}", (Object)uri);
            Writer writer = conn.getBlobObject(uri).openWriter();
            try {
                writer.write(content);
            }
            finally {
                writer.close();
            }
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeBinaryBlob(String uri, byte[] content) throws OpenRDFException, IOException {
        ObjectConnection conn = this.getObjectConnection();
        try {
            this.logger.warn("Replacing {}", (Object)uri);
            OutputStream out = conn.getBlobObject(uri).openOutputStream();
            try {
                out.write(content);
            }
            finally {
                out.close();
            }
        }
        finally {
            conn.close();
        }
    }

    private RepositoryConnection getConnection() throws OpenRDFException {
        RepositoryConnection con = this.getRepository().getConnection();
        con.setParserConfig(this.parserConfig);
        return con;
    }

    private ObjectConnection getObjectConnection() throws OpenRDFException {
        ObjectConnection con = this.getObjectRepository().getConnection();
        con.setParserConfig(this.parserConfig);
        return con;
    }

    private ObjectRepository getObjectRepository() throws OpenRDFException {
        return this.manager.getObjectRepository(this.id);
    }

    private Repository getRepository() throws OpenRDFException {
        return this.manager.getRepository(this.id);
    }
}

