/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.management;

import java.io.File;
import java.io.IOException;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestFactory;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.client.cache.ResourceFactory;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpExecutionAware;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.client.cache.FileResourceFactory;
import org.apache.http.impl.execchain.ClientExecChain;
import org.apache.http.impl.nio.DefaultHttpServerIODispatch;
import org.apache.http.impl.nio.DefaultNHttpServerConnectionFactory;
import org.apache.http.impl.nio.SSLNHttpServerConnectionFactory;
import org.apache.http.impl.nio.codecs.DefaultHttpRequestParserFactory;
import org.apache.http.impl.nio.reactor.DefaultListeningIOReactor;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.nio.NHttpConnection;
import org.apache.http.nio.NHttpConnectionFactory;
import org.apache.http.nio.NHttpMessageParserFactory;
import org.apache.http.nio.NHttpServerConnection;
import org.apache.http.nio.NHttpServerEventHandler;
import org.apache.http.nio.protocol.HttpAsyncService;
import org.apache.http.nio.reactor.IOEventDispatch;
import org.apache.http.nio.reactor.IOReactorExceptionHandler;
import org.apache.http.nio.reactor.IOReactorStatus;
import org.apache.http.nio.reactor.IOSession;
import org.apache.http.nio.reactor.ssl.SSLSetupHandler;
import org.apache.http.nio.util.ByteBufferAllocator;
import org.apache.http.nio.util.HeapByteBufferAllocator;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.ImmutableHttpProcessor;
import org.apache.http.protocol.ResponseConnControl;
import org.apache.http.protocol.ResponseContent;
import org.apache.http.protocol.ResponseDate;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.util.TextUtils;
import org.openrdf.http.object.Version;
import org.openrdf.http.object.chain.HeadRequestFilter;
import org.openrdf.http.object.chain.RequestExecChain;
import org.openrdf.http.object.chain.ServerNameFilter;
import org.openrdf.http.object.client.HttpClientFactory;
import org.openrdf.http.object.client.HttpClientSparqlQueryResolver;
import org.openrdf.http.object.client.UnavailableRequestDirector;
import org.openrdf.http.object.concurrent.NamedThreadFactory;
import org.openrdf.http.object.helpers.AsyncRequestHandler;
import org.openrdf.http.object.helpers.ObjectContextInterceptor;
import org.openrdf.http.object.util.AnyHttpMethodRequestFactory;
import org.openrdf.repository.object.ObjectRepository;
import org.openrdf.repository.object.advisers.SparqlQueryResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebServer
implements IOReactorExceptionHandler,
ClientExecChain {
    protected static final String DEFAULT_NAME = Version.getInstance().getVersion();
    private static NamedThreadFactory executor = new NamedThreadFactory("WebServer", false);
    final Logger logger = LoggerFactory.getLogger(WebServer.class);
    private final UnavailableRequestDirector unavailable = new UnavailableRequestDirector();
    final Map<NHttpConnection, Boolean> connections = new WeakHashMap<NHttpConnection, Boolean>();
    final DefaultListeningIOReactor server;
    final IOEventDispatch dispatch;
    DefaultListeningIOReactor sslserver;
    IOEventDispatch ssldispatch;
    private int[] ports = new int[0];
    private int[] sslports = new int[0];
    private final ServerNameFilter name;
    private final RequestExecChain chain;
    volatile boolean listening;
    volatile boolean ssllistening;
    private final HttpResponseInterceptor[] interceptors;

    public WebServer() throws IOException {
        this(new RequestExecChain(), SSLContexts.createSystemDefault(), 0, false);
    }

    public WebServer(File cacheDir) throws IOException {
        this(new RequestExecChain((ResourceFactory)new FileResourceFactory(cacheDir)), SSLContexts.createSystemDefault(), 0, false);
    }

    public WebServer(int timeout, boolean noDelay) throws IOException {
        this(new RequestExecChain(), SSLContexts.createSystemDefault(), timeout, noDelay);
    }

    public WebServer(File cacheDir, int timeout, boolean noDelay) throws IOException {
        this(new RequestExecChain((ResourceFactory)(cacheDir == null ? null : new FileResourceFactory(cacheDir))), SSLContexts.createSystemDefault(), timeout, noDelay);
    }

    public WebServer(SSLContext sslcontext) throws IOException {
        this(new RequestExecChain(), sslcontext, 0, false);
    }

    public WebServer(File cacheDir, SSLContext sslcontext) throws IOException {
        this(new RequestExecChain((ResourceFactory)new FileResourceFactory(cacheDir)), sslcontext, 0, false);
    }

    public WebServer(SSLContext sslcontext, int timeout, boolean noDelay) throws IOException {
        this(new RequestExecChain(), sslcontext, timeout, noDelay);
    }

    public WebServer(File cacheDir, SSLContext sslcontext, int timeout, boolean noDelay) throws IOException {
        this(new RequestExecChain((ResourceFactory)(cacheDir == null ? null : new FileResourceFactory(cacheDir))), sslcontext, timeout, noDelay);
    }

    private WebServer(RequestExecChain chain, SSLContext sslcontext, int timeout, boolean noDelay) throws IOException {
        this.chain = chain;
        HttpResponseInterceptor[] httpResponseInterceptorArray = new HttpResponseInterceptor[5];
        httpResponseInterceptorArray[0] = new ResponseDate();
        httpResponseInterceptorArray[1] = new ResponseContent(true);
        httpResponseInterceptorArray[2] = new ResponseConnControl();
        this.name = new ServerNameFilter(DEFAULT_NAME);
        httpResponseInterceptorArray[3] = this.name;
        httpResponseInterceptorArray[4] = new HeadRequestFilter();
        this.interceptors = httpResponseInterceptorArray;
        AnyHttpMethodRequestFactory rfactory = new AnyHttpMethodRequestFactory();
        HeapByteBufferAllocator allocator = new HeapByteBufferAllocator();
        IOReactorConfig config = this.createIOReactorConfig(timeout, noDelay);
        this.dispatch = this.createIODispatch(rfactory, (ByteBufferAllocator)allocator);
        this.server = new DefaultListeningIOReactor(config);
        this.server.setExceptionHandler((IOReactorExceptionHandler)this);
        if (sslcontext != null) {
            this.ssldispatch = this.createSSLDispatch(sslcontext, rfactory, (ByteBufferAllocator)allocator);
            this.sslserver = new DefaultListeningIOReactor(config);
            this.sslserver.setExceptionHandler((IOReactorExceptionHandler)this);
        }
    }

    public synchronized void addRepository(String prefix, ObjectRepository repository) {
        this.chain.addRepository(prefix, repository);
        HttpHost host = URIUtils.extractHost((URI)URI.create(prefix));
        if (this.isRunning()) {
            HttpClientFactory.getInstance().putProxy(host, this);
        } else {
            HttpClientFactory.getInstance().putProxyIfAbsent(host, this.unavailable);
        }
    }

    public synchronized void removeRepository(String prefix) {
        this.chain.removeRepository(prefix);
        for (String p : this.chain.getRepositoryPrefixes()) {
            if (!prefix.startsWith(p)) continue;
            return;
        }
        HttpHost host = URIUtils.extractHost((URI)URI.create(prefix));
        HttpClientFactory.getInstance().removeProxy(host, this);
    }

    public String getName() {
        return this.name.getServerName();
    }

    public void setName(String serverName) {
        this.name.setServerName(serverName);
    }

    public void resetCache() {
        this.chain.resetCache();
    }

    public void resetConnections() throws IOException {
        NHttpConnection[] connections = this.getOpenConnections();
        for (int i = 0; i < connections.length; ++i) {
            connections[i].shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void listen(int[] ports, int[] sslports) throws IOException {
        int port;
        if (ports == null) {
            ports = new int[]{};
        }
        if (sslports == null) {
            sslports = new int[]{};
        }
        if (sslports.length > 0 && this.sslserver == null) {
            throw new IllegalStateException("No configured keystore for SSL ports");
        }
        Object object = this.diff(this.ports, ports).iterator();
        while (object.hasNext()) {
            port = object.next();
            this.server.listen((SocketAddress)new InetSocketAddress(port));
        }
        object = this.diff(this.sslports, sslports).iterator();
        while (object.hasNext()) {
            port = object.next();
            this.sslserver.listen((SocketAddress)new InetSocketAddress(port));
        }
        if (!this.isRunning()) {
            if (ports.length > 0) {
                this.server.pause();
            }
            if (this.sslserver != null && sslports.length > 0) {
                this.sslserver.pause();
            }
        }
        this.ports = ports;
        this.sslports = sslports;
        if (ports.length > 0) {
            this.name.setPort(ports[0]);
        } else if (sslports.length > 0) {
            this.name.setPort(sslports[0]);
        }
        if (!this.listening && ports.length > 0) {
            executor.newThread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        WebServer webServer = WebServer.this;
                        synchronized (webServer) {
                            WebServer.this.listening = true;
                            WebServer.this.notifyAll();
                        }
                        WebServer.this.server.execute(WebServer.this.dispatch);
                    }
                    catch (IOException e) {
                        WebServer.this.logger.error(e.toString(), (Throwable)e);
                    }
                    finally {
                        WebServer webServer = WebServer.this;
                        synchronized (webServer) {
                            WebServer.this.listening = false;
                            WebServer.this.notifyAll();
                        }
                    }
                }
            }).start();
        }
        if (!this.ssllistening && this.sslserver != null && sslports.length > 0) {
            executor.newThread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        WebServer webServer = WebServer.this;
                        synchronized (webServer) {
                            WebServer.this.ssllistening = true;
                            WebServer.this.notifyAll();
                        }
                        WebServer.this.sslserver.execute(WebServer.this.ssldispatch);
                    }
                    catch (IOException e) {
                        WebServer.this.logger.error(e.toString(), (Throwable)e);
                    }
                    finally {
                        WebServer webServer = WebServer.this;
                        synchronized (webServer) {
                            WebServer.this.ssllistening = false;
                            WebServer.this.notifyAll();
                        }
                    }
                }
            }).start();
        }
        try {
            object = this;
            synchronized (object) {
                while (!this.listening && ports.length > 0 || !this.ssllistening && this.sslserver != null && sslports.length > 0) {
                    this.wait();
                }
            }
            Thread.sleep(100L);
            if (ports.length > 0 && this.server != null && this.server.getStatus() != IOReactorStatus.ACTIVE || sslports.length > 0 && this.sslserver != null && this.sslserver.getStatus() != IOReactorStatus.ACTIVE) {
                String str = Arrays.toString(ports) + Arrays.toString(sslports);
                str = str.replace('[', ' ').replace(']', ' ');
                throw new BindException("Could not bind to port" + str + "server is " + this.getStatus());
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public synchronized void start() throws IOException {
        if (this.ports.length > 0) {
            this.server.resume();
        }
        if (this.sslserver != null && this.sslports.length > 0) {
            this.sslserver.resume();
        }
        for (HttpHost host : this.getOrigins()) {
            HttpClientFactory.getInstance().putProxy(host, this);
        }
    }

    public boolean isRunning() {
        if (this.ports == null || this.sslports == null || this.chain.isShutdown()) {
            return false;
        }
        if (this.ports.length > 0 && this.server.getStatus() == IOReactorStatus.ACTIVE) {
            return !this.server.getEndpoints().isEmpty();
        }
        if (this.sslports.length > 0 && this.sslserver != null && this.sslserver.getStatus() == IOReactorStatus.ACTIVE) {
            return !this.sslserver.getEndpoints().isEmpty();
        }
        return false;
    }

    public synchronized void stop() throws IOException {
        for (HttpHost host : this.getOrigins()) {
            HttpClientFactory.getInstance().putProxy(host, this.unavailable);
        }
        if (this.ports.length > 0) {
            this.server.pause();
        }
        if (this.sslserver != null && this.sslports.length > 0) {
            this.sslserver.pause();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void destroy() throws IOException {
        this.stop();
        this.chain.shutdown();
        this.server.shutdown();
        if (this.sslserver != null) {
            this.sslserver.shutdown();
        }
        this.chain.removeAllRepositories();
        this.resetConnections();
        try {
            WebServer webServer = this;
            synchronized (webServer) {
                while (this.listening || this.ssllistening) {
                    this.wait();
                }
            }
            Thread.sleep(100L);
            while (this.server.getStatus() != IOReactorStatus.SHUT_DOWN && this.server.getStatus() != IOReactorStatus.INACTIVE) {
                Thread.sleep(1000L);
                if (!this.isRunning()) continue;
                throw new IOException("Could not shutdown Web server");
            }
            if (this.sslserver != null) {
                while (this.sslserver.getStatus() != IOReactorStatus.SHUT_DOWN && this.sslserver.getStatus() != IOReactorStatus.INACTIVE) {
                    Thread.sleep(1000L);
                    if (!this.isRunning()) continue;
                    throw new IOException("Could not shutdown secure Web server");
                }
            }
            this.chain.awaitTermination(1000L, TimeUnit.MILLISECONDS);
            if (!this.chain.isTerminated()) {
                throw new IOException("Could not shutdown triage queue server");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            for (HttpHost host : this.getOrigins()) {
                HttpClientFactory.getInstance().removeProxy(host, this.unavailable);
            }
        }
        for (HttpHost host : this.getOrigins()) {
            HttpClientFactory.getInstance().removeProxy(host, this.unavailable);
        }
    }

    public boolean handle(IOException ex) {
        this.logger.warn(ex.toString());
        return true;
    }

    public boolean handle(RuntimeException ex) {
        this.logger.error(ex.toString(), (Throwable)ex);
        return true;
    }

    public void poke() {
        System.gc();
        System.runFinalization();
        for (NHttpConnection conn : this.getOpenConnections()) {
            conn.requestInput();
            conn.requestOutput();
        }
    }

    public String getStatus() {
        StringBuilder sb = new StringBuilder();
        if (this.ports.length > 0) {
            sb.append(this.server.getStatus().toString());
        }
        if (this.ports.length > 0 && this.sslports.length > 0) {
            sb.append(", ssl: ");
        }
        if (this.sslserver != null && this.sslports.length > 0) {
            sb.append(this.sslserver.getStatus().toString());
        }
        if (sb.length() == 0) {
            return "INACTIVE";
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NHttpConnection[] getOpenConnections() {
        Map<NHttpConnection, Boolean> map = this.connections;
        synchronized (map) {
            return this.connections.keySet().toArray(new NHttpConnection[this.connections.size()]);
        }
    }

    public CloseableHttpResponse execute(HttpRoute route, HttpRequestWrapper request, HttpClientContext context, HttpExecutionAware execAware) throws IOException, HttpException {
        ImmutableHttpProcessor httpproc = this.getHttpProcessor(route.getTargetHost().getSchemeName());
        httpproc.process((HttpRequest)request, (HttpContext)context);
        CloseableHttpResponse resp = this.chain.execute(route, request, context, execAware);
        httpproc.process((HttpResponse)resp, (HttpContext)context);
        return resp;
    }

    private Collection<HttpHost> getOrigins() {
        LinkedHashSet<HttpHost> result = new LinkedHashSet<HttpHost>();
        for (String prefix : this.chain.getRepositoryPrefixes()) {
            HttpHost host = URIUtils.extractHost((URI)URI.create(prefix));
            result.add(host);
        }
        return result;
    }

    private DefaultHttpServerIODispatch createIODispatch(HttpRequestFactory requestFactory, ByteBufferAllocator allocator) {
        ConnectionConfig params = this.getDefaultConnectionConfig();
        HttpAsyncService handler = this.createProtocolHandler((HttpProcessor)this.getHttpProcessor("http"), new AsyncRequestHandler(this.chain));
        DefaultHttpRequestParserFactory rparser = new DefaultHttpRequestParserFactory(null, requestFactory);
        DefaultNHttpServerConnectionFactory factory = new DefaultNHttpServerConnectionFactory(allocator, (NHttpMessageParserFactory)rparser, null, params);
        return new DefaultHttpServerIODispatch((NHttpServerEventHandler)handler, (NHttpConnectionFactory)factory);
    }

    private DefaultHttpServerIODispatch createSSLDispatch(SSLContext sslcontext, HttpRequestFactory requestFactory, ByteBufferAllocator allocator) {
        ConnectionConfig params = this.getDefaultConnectionConfig();
        HttpAsyncService handler = this.createProtocolHandler((HttpProcessor)this.getHttpProcessor("https"), new AsyncRequestHandler(this.chain));
        DefaultHttpRequestParserFactory rparser = new DefaultHttpRequestParserFactory(null, requestFactory);
        SSLNHttpServerConnectionFactory factory = new SSLNHttpServerConnectionFactory(sslcontext, this.getSSLSetupHandler(), (NHttpMessageParserFactory)rparser, null, allocator, params);
        return new DefaultHttpServerIODispatch((NHttpServerEventHandler)handler, (NHttpConnectionFactory)factory);
    }

    private SSLSetupHandler getSSLSetupHandler() {
        return new SSLSetupHandler(){
            private final String[] supportedProtocols = this.split(System.getProperty("https.protocols"));
            private final String[] supportedCipherSuites = this.split(System.getProperty("https.cipherSuites"));

            public void verify(IOSession iosession, SSLSession sslsession) throws SSLException {
            }

            public void initalize(SSLEngine sslengine) throws SSLException {
                if (this.supportedProtocols != null) {
                    sslengine.setEnabledProtocols(this.supportedProtocols);
                }
                if (this.supportedCipherSuites != null) {
                    sslengine.setEnabledCipherSuites(this.supportedCipherSuites);
                }
            }

            private String[] split(String s) {
                if (TextUtils.isBlank((CharSequence)s)) {
                    return null;
                }
                return s.split(" *, *");
            }
        };
    }

    private ImmutableHttpProcessor getHttpProcessor(String protocol) {
        return new ImmutableHttpProcessor(new HttpRequestInterceptor[]{new ObjectContextInterceptor(protocol)}, this.interceptors);
    }

    private ConnectionConfig getDefaultConnectionConfig() {
        return ConnectionConfig.DEFAULT;
    }

    private IOReactorConfig createIOReactorConfig(int timeout, boolean noDelay) {
        return IOReactorConfig.custom().setConnectTimeout(timeout).setIoThreadCount(Runtime.getRuntime().availableProcessors()).setSndBufSize(8192).setSoKeepAlive(true).setSoReuseAddress(true).setSoTimeout(timeout).setTcpNoDelay(noDelay).build();
    }

    private HttpAsyncService createProtocolHandler(HttpProcessor httpproc, AsyncRequestHandler service) {
        HttpAsyncService protocolHandler = new HttpAsyncService(httpproc, service){
            private final Logger logger;
            {
                this.logger = LoggerFactory.getLogger(WebServer.class);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void connected(NHttpServerConnection conn) {
                super.connected(conn);
                Map<NHttpConnection, Boolean> map = WebServer.this.connections;
                synchronized (map) {
                    WebServer.this.connections.put((NHttpConnection)conn, true);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void closed(NHttpServerConnection conn) {
                Map<NHttpConnection, Boolean> map = WebServer.this.connections;
                synchronized (map) {
                    WebServer.this.connections.remove(conn);
                }
                super.closed(conn);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void exception(NHttpServerConnection conn, Exception cause) {
                try {
                    if (cause.getClass().equals(IOException.class)) {
                        this.logger.warn(cause.toString());
                    } else if (cause.getClass().equals(HttpException.class)) {
                        this.logger.warn(cause.toString());
                    } else {
                        this.logger.warn(cause.toString(), (Throwable)cause);
                    }
                    super.exception(conn, cause);
                }
                finally {
                    try {
                        conn.shutdown();
                    }
                    catch (IOException e) {
                        this.log(e);
                    }
                }
            }

            protected void log(Exception ex) {
                this.logger.warn(ex.toString(), (Throwable)ex);
            }
        };
        return protocolHandler;
    }

    private Set<Integer> diff(int[] existingPorts, int[] ports) {
        LinkedHashSet<Integer> newPorts = new LinkedHashSet<Integer>(ports.length);
        for (int p : ports) {
            newPorts.add(p);
        }
        for (int p : existingPorts) {
            newPorts.remove(p);
        }
        return newPorts;
    }

    static {
        SparqlQueryResolver delegate = SparqlQueryResolver.getInstance();
        SparqlQueryResolver.setInstance((SparqlQueryResolver)new HttpClientSparqlQueryResolver(delegate));
    }
}

