/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.util;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.UndeclaredThrowableException;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import org.openrdf.http.object.util.QueueCursor;
import org.openrdf.model.Statement;
import org.openrdf.query.GraphQueryResult;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.RDFParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackgroundGraphResult
implements GraphQueryResult,
Runnable,
RDFHandler,
Closeable {
    private volatile boolean closed;
    private volatile Thread parserThread;
    private Logger logger = LoggerFactory.getLogger(BackgroundGraphResult.class);
    private RDFParser parser;
    private Charset charset;
    private InputStream in;
    private String baseURI;
    private CountDownLatch namespacesReady = new CountDownLatch(1);
    private Map<String, String> namespaces = new ConcurrentHashMap<String, String>();
    private QueueCursor<Statement> queue;

    public BackgroundGraphResult(RDFParser parser, InputStream in, Charset charset, String baseURI) {
        this(new QueueCursor<Statement>(10), parser, in, charset, baseURI);
    }

    public BackgroundGraphResult(QueueCursor<Statement> queue, RDFParser parser, InputStream in, Charset charset, String baseURI) {
        if (baseURI == null) {
            baseURI = "";
        }
        this.queue = queue;
        this.parser = parser;
        this.in = in;
        this.charset = charset;
        this.baseURI = baseURI;
    }

    public String toString() {
        return this.parser.toString() + " in background thread";
    }

    public boolean hasNext() throws QueryEvaluationException {
        return this.queue.hasNext();
    }

    public Statement next() throws QueryEvaluationException {
        return (Statement)this.queue.next();
    }

    public void remove() throws QueryEvaluationException {
        this.queue.remove();
    }

    @Override
    public void close() {
        this.closed = true;
        if (this.parserThread != null) {
            this.parserThread.interrupt();
        }
        try {
            this.queue.close();
            this.in.close();
        }
        catch (IOException e) {
            this.logger.warn(e.getMessage(), (Throwable)e);
        }
        catch (QueryEvaluationException e) {
            this.logger.warn(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void run() {
        this.parserThread = Thread.currentThread();
        try {
            this.parser.setRDFHandler((RDFHandler)this);
            if (this.charset == null) {
                this.parser.parse(this.in, this.baseURI);
            } else {
                this.parser.parse((Reader)new InputStreamReader(this.in, this.charset), this.baseURI);
            }
        }
        catch (RDFHandlerException rDFHandlerException) {
        }
        catch (RDFParseException e) {
            this.queue.toss((Exception)((Object)e));
        }
        catch (IOException e) {
            this.queue.toss(e);
        }
        finally {
            this.parserThread = null;
            this.queue.done();
            this.namespacesReady.countDown();
        }
    }

    public void startRDF() throws RDFHandlerException {
    }

    public Map<String, String> getNamespaces() {
        try {
            this.namespacesReady.await();
            return this.namespaces;
        }
        catch (InterruptedException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    public void handleComment(String comment) throws RDFHandlerException {
    }

    public void handleNamespace(String prefix, String uri) throws RDFHandlerException {
        this.namespaces.put(prefix, uri);
    }

    public void handleStatement(Statement st) throws RDFHandlerException {
        this.namespacesReady.countDown();
        if (this.closed) {
            throw new RDFHandlerException("Result closed");
        }
        try {
            this.queue.put(st);
        }
        catch (InterruptedException e) {
            throw new RDFHandlerException((Throwable)e);
        }
    }

    public void endRDF() throws RDFHandlerException {
        this.namespacesReady.countDown();
    }
}

