/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.util;

import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.http.Header;

public class HTTPDateFormat
extends DateFormat {
    private static final long serialVersionUID = -2636174153773598968L;
    private static final String HTTP_RESPONSE_DATE_HEADER = "EEE, dd MMM yyyy HH:mm:ss zzz";
    private static ThreadLocal<SimpleDateFormat> simple = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            SimpleDateFormat format = new SimpleDateFormat(HTTPDateFormat.HTTP_RESPONSE_DATE_HEADER, Locale.US);
            format.setTimeZone(TimeZone.getTimeZone("GMT"));
            return format;
        }
    };
    private long format = 0L;
    private String parse = "Thu, 01 Jan 1970 00:00:00 GMT";

    public synchronized String format(long date) {
        if (this.format == date) {
            return this.parse;
        }
        this.format = date;
        this.parse = simple.get().format(this.format);
        return this.parse;
    }

    public long parseHeader(Header hd) {
        if (hd == null) {
            return System.currentTimeMillis() / 1000L * 1000L;
        }
        return this.parseDate(hd.getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long parseDate(String source) {
        if (source == null) {
            return System.currentTimeMillis() / 1000L * 1000L;
        }
        HTTPDateFormat hTTPDateFormat = this;
        synchronized (hTTPDateFormat) {
            if (source.equals(this.parse)) {
                return this.format;
            }
        }
        try {
            return simple.get().parse(source).getTime();
        }
        catch (ParseException e) {
            return System.currentTimeMillis() / 1000L * 1000L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date parse(String source) {
        if (source == null) {
            return new Date(System.currentTimeMillis() / 1000L * 1000L);
        }
        HTTPDateFormat hTTPDateFormat = this;
        synchronized (hTTPDateFormat) {
            if (source.equals(this.parse)) {
                return new Date(this.format);
            }
        }
        try {
            return simple.get().parse(source);
        }
        catch (ParseException e) {
            return new Date(System.currentTimeMillis() / 1000L * 1000L);
        }
    }

    @Override
    public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition fieldPosition) {
        return simple.get().format(date, toAppendTo, fieldPosition);
    }

    @Override
    public Date parse(String source, ParsePosition pos) {
        return simple.get().parse(source, pos);
    }
}

