/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.util;

import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class InlineExecutorService
extends AbstractExecutorService {
    private final ThreadLocal<Boolean> foreground;
    private final ExecutorService delegate;

    public InlineExecutorService(ThreadLocal<Boolean> foreground, ExecutorService delegate) {
        this.foreground = foreground;
        this.delegate = delegate;
    }

    @Override
    public void execute(Runnable command) {
        this.delegate.execute(command);
    }

    @Override
    public void shutdown() {
        this.delegate.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.delegate.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.delegate.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.delegate.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.awaitTermination(timeout, unit);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        if (this.isForeground()) {
            try {
                return new CompletedFuture<T>(task.call());
            }
            catch (Exception e) {
                return new CompletedFuture(e);
            }
        }
        return this.delegate.submit(task);
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        if (this.isForeground()) {
            try {
                task.run();
                return new CompletedFuture<T>(result);
            }
            catch (Exception e) {
                return new CompletedFuture(e);
            }
        }
        return this.delegate.submit(task, result);
    }

    @Override
    public Future<?> submit(Runnable task) {
        if (this.isForeground()) {
            try {
                task.run();
                return new CompletedFuture();
            }
            catch (Exception e) {
                return new CompletedFuture(e);
            }
        }
        return this.delegate.submit(task);
    }

    private boolean isForeground() {
        Boolean bool = this.foreground.get();
        return bool != null && bool != false;
    }

    private static class CompletedFuture<T>
    implements Future<T> {
        private final T result;
        private final Throwable throwable;

        public CompletedFuture() {
            this.result = null;
            this.throwable = null;
        }

        public CompletedFuture(T result) {
            this.result = result;
            this.throwable = null;
        }

        public CompletedFuture(Throwable throwable) {
            this.result = null;
            this.throwable = throwable;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return true;
        }

        @Override
        public T get() throws ExecutionException {
            if (this.throwable != null) {
                throw new ExecutionException(this.throwable);
            }
            return this.result;
        }

        @Override
        public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.get();
        }
    }
}

