/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class PathMatcher {
    private static Map<String, Pattern> patterns = Collections.synchronizedMap(new WeakHashMap());
    private static final Pattern NAMED_GROUP_PATTERN = Pattern.compile("\\(\\?<(\\w+)>");
    private CharSequence url;
    private int start;

    public static Pattern compile(String regex) {
        Pattern result = patterns.get(regex);
        if (result != null) {
            return result;
        }
        try {
            result = Pattern.compile(regex);
            patterns.put(regex, result);
        }
        catch (PatternSyntaxException e) {
            result = Pattern.compile(regex, 16);
            patterns.put(regex, result);
        }
        return result;
    }

    public PathMatcher(CharSequence url, int start) {
        this.url = url;
        this.start = start;
    }

    public boolean matches(String regex) {
        return this.matches(PathMatcher.compile(regex));
    }

    public boolean matches(Pattern pattern) {
        return this.startingAt(pattern.matcher(this.url));
    }

    public Map<String, String> match(String regex) {
        return this.match(PathMatcher.compile(regex));
    }

    public Map<String, String> match(Pattern pattern) {
        return this.groups(pattern.matcher(this.url));
    }

    private boolean startingAt(Matcher m) {
        return m.find(this.start) && m.start() == this.start;
    }

    private Map<String, String> groups(Matcher m) {
        if (!this.startingAt(m)) {
            return null;
        }
        int n = m.groupCount();
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(n * 2);
        for (int i = 0; i <= n; ++i) {
            map.put(Integer.toString(i), m.group(i));
        }
        for (String name : this.extractGroupNames(m)) {
            map.put(name, m.group(name));
        }
        return map;
    }

    private List<String> extractGroupNames(Matcher m) {
        ArrayList<String> groupNames = new ArrayList<String>();
        Pattern pattern = m.pattern();
        if ((pattern.flags() & 0x10) == 0) {
            Matcher matcher = NAMED_GROUP_PATTERN.matcher(pattern.pattern());
            while (matcher.find()) {
                groupNames.add(matcher.group(1));
            }
        }
        return groupNames;
    }
}

