/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.util;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class PrefixMap<V>
extends AbstractMap<String, V>
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -3196352714861883183L;
    private final TreeMap<String, V> map;

    public PrefixMap() {
        this.map = new TreeMap();
    }

    public PrefixMap(Map<String, V> map) {
        this.map = new TreeMap<String, V>(map);
    }

    public V getClosest(String string) {
        Map.Entry<String, V> entry = this.getClosestEntry(string);
        if (entry == null) {
            return null;
        }
        return entry.getValue();
    }

    public Map.Entry<String, V> getClosestEntry(String string) {
        int idx;
        Map.Entry<String, V> entry = this.map.floorEntry(string);
        if (entry == null) {
            return null;
        }
        String key = entry.getKey();
        if (string == key || string.startsWith(key)) {
            return entry;
        }
        if (string == null || string.length() == 0) {
            return null;
        }
        for (idx = 0; idx < string.length() && idx < key.length() && string.charAt(idx) == key.charAt(idx); ++idx) {
        }
        return this.getClosestEntry(string.substring(0, idx));
    }

    @Override
    public V get(Object key) {
        return this.map.get(key);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public void putAll(Map<? extends String, ? extends V> m) {
        this.map.putAll(m);
    }

    @Override
    public V put(String key, V value) {
        return this.map.put(key, value);
    }

    @Override
    public V remove(Object key) {
        return this.map.remove(key);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public PrefixMap<V> clone() {
        return new PrefixMap<V>(this.map);
    }

    @Override
    public Set<String> keySet() {
        return this.map.keySet();
    }

    @Override
    public Set<Map.Entry<String, V>> entrySet() {
        return this.map.entrySet();
    }
}

