/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementPermission;
import java.lang.reflect.ReflectPermission;
import java.net.MalformedURLException;
import java.net.NetPermission;
import java.net.SocketPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.SecurityPermission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.PropertyPermission;
import java.util.Set;
import java.util.logging.LoggingPermission;
import javax.management.MBeanPermission;
import javax.management.MBeanServerPermission;
import javax.management.MBeanTrustPermission;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerPolicy
extends Policy {
    private static Logger logger = LoggerFactory.getLogger(ServerPolicy.class);
    private static CodeSource source = ServerPolicy.class.getProtectionDomain().getCodeSource();
    private final PermissionCollection plugins = new Permissions();
    private final PermissionCollection management;
    private final PermissionCollection jars;
    private final List<String> writableLocations;

    public static boolean apply(String[] readable, File ... writable) {
        try {
            Policy.setPolicy(new ServerPolicy(readable, writable));
            System.setSecurityManager(new SecurityManager());
            logger.info("Restricted file system access in effect");
            return true;
        }
        catch (SecurityException e) {
            logger.debug(e.toString(), (Throwable)e);
            return false;
        }
    }

    @Override
    public PermissionCollection getPermissions(CodeSource codesource) {
        if (source == codesource || source != null && source.equals(codesource)) {
            return this.copy(this.jars);
        }
        if (codesource == null || codesource.getLocation() == null) {
            return this.copy(this.management);
        }
        String location = codesource.getLocation().toExternalForm();
        if (!location.startsWith("file:")) {
            return this.copy(this.plugins);
        }
        for (String url : this.writableLocations) {
            if (!location.startsWith(url)) continue;
            return this.copy(this.plugins);
        }
        return this.copy(this.jars);
    }

    private ServerPolicy(String[] readable, File ... directories) {
        this.plugins.add(new PropertyPermission("*", "read"));
        this.plugins.add(new PropertyPermission("apple.awt.graphics.*", "write"));
        this.plugins.add(new RuntimePermission("getenv.*"));
        this.plugins.add(new SocketPermission("*", "connect,resolve"));
        this.plugins.add(new SocketPermission("*", "accept"));
        this.plugins.add(new NetPermission("getProxySelector"));
        this.plugins.add(new NetPermission("requestPasswordAuthentication"));
        this.plugins.add(new ReflectPermission("suppressAccessChecks"));
        this.plugins.add(new SecurityPermission("putProviderProperty.*"));
        this.plugins.add(new RuntimePermission("accessDeclaredMembers"));
        this.plugins.add(new RuntimePermission("getClassLoader"));
        this.plugins.add(new RuntimePermission("createClassLoader"));
        this.plugins.add(new RuntimePermission("accessDeclaredMembers"));
        this.plugins.add(new RuntimePermission("getProtectionDomain"));
        this.plugins.add(new RuntimePermission("setContextClassLoader"));
        this.plugins.add(new RuntimePermission("accessClassInPackage.*"));
        File home = new File(System.getProperty("user.home"));
        HashSet<String> visited = new HashSet<String>();
        this.addReadableDirectory(new File(home, ".mime-types.properties"), visited);
        this.addReadableDirectory(new File(home, ".mime.types"), visited);
        this.addReadableDirectory(new File(home, ".magic.mime"), visited);
        for (Object value : this.getSystemPropertyValues()) {
            File file;
            if (!(value instanceof String) || !(file = new File((String)value)).exists()) continue;
            this.addReadableDirectory(file, visited);
        }
        this.plugins.add(new FilePermission(home.getAbsolutePath() + "/.local/-", "read"));
        this.plugins.add(new FilePermission("/etc/magic.mime", "read"));
        this.plugins.add(new FilePermission("/usr/-", "read"));
        this.plugins.add(new FilePermission("/opt/-", "read"));
        this.plugins.add(new FilePermission("/System/-", "read"));
        this.plugins.add(new FilePermission("/Applications/-", "read"));
        this.plugins.add(new FilePermission("C:\\WINDOWS\\-", "read"));
        this.plugins.add(new FilePermission("C:\\Program Files\\-", "read"));
        this.addClassPath(System.getProperty("java.ext.dirs"));
        this.addClassPath(System.getProperty("java.endorsed.dirs"));
        this.addClassPath(System.getProperty("java.class.path"));
        this.addClassPath(System.getProperty("sun.boot.class.path"));
        this.addClassPath(System.getProperty("jdk.home"));
        this.addClassPath(System.getProperty("java.home"));
        this.addClassPath(new File("").getAbsolutePath());
        this.addClassPath(readable);
        this.writableLocations = new ArrayList<String>(directories.length + 1);
        this.addWritableDirectories(directories);
        try {
            this.addWritableDirectories(this.getLoggingDirectories());
        }
        catch (IOException e) {
            logger.warn(e.toString(), (Throwable)e);
        }
        this.management = this.copy(this.plugins);
        this.management.add(new RuntimePermission("*"));
        this.management.add(new PropertyPermission("*", "read,write"));
        this.management.add(new SocketPermission("*", "listen"));
        this.management.add(new MBeanPermission("*", "*"));
        this.management.add(new ManagementPermission("monitor"));
        this.management.add(new ManagementPermission("control"));
        this.management.add(new MBeanServerPermission("*"));
        this.management.add(new MBeanTrustPermission("register"));
        this.management.add(new LoggingPermission("control", ""));
        this.jars = this.copy(this.management);
        this.addJavaPath(System.getProperty("jdk.home"));
        this.addJavaPath(System.getProperty("java.home"));
        this.addJavaPath(System.getenv("JAVA_HOME"));
        this.addPath(System.getProperty("java.library.path"));
        this.addPath(System.getenv("PATH"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<?> getSystemPropertyValues() {
        Properties properties;
        Properties properties2 = properties = System.getProperties();
        synchronized (properties2) {
            return new ArrayList<Object>(properties.values());
        }
    }

    private Permissions copy(PermissionCollection perm) {
        Permissions ret = new Permissions();
        Enumeration<Permission> elements = perm.elements();
        while (elements.hasMoreElements()) {
            ret.add(elements.nextElement());
        }
        return ret;
    }

    private void addClassPath(String ... paths) {
        HashSet<String> visited = new HashSet<String>();
        for (String path : paths) {
            if (path == null) continue;
            for (String dir : path.split(File.pathSeparator)) {
                this.addReadableDirectory(new File(dir), visited);
            }
        }
    }

    private void addReadableDirectory(File file, Set<String> visited) {
        String abs = file.getAbsolutePath();
        this.plugins.add(new FilePermission(abs, "read"));
        logger.debug("FilePermission {} read", (Object)abs);
        if (file.isDirectory()) {
            abs = abs + File.separatorChar + "-";
            this.plugins.add(new FilePermission(abs, "read"));
            logger.debug("FilePermission {} read", (Object)abs);
        }
    }

    private void addWritableDirectories(File ... directories) {
        for (File dir : directories) {
            this.addWriteableDirectory(dir);
            try {
                this.writableLocations.add(this.url(dir));
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        try {
            File tmp = new File(System.getProperty("java.io.tmpdir"));
            this.addWriteableDirectory(tmp);
            this.writableLocations.add(this.url(tmp));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private String url(File dir) throws MalformedURLException {
        return dir.toURI().toURL().toExternalForm();
    }

    private void addWriteableDirectory(File dir) {
        String path = dir.getAbsolutePath();
        this.plugins.add(new FilePermission(path, "read"));
        this.plugins.add(new FilePermission(path, "write"));
        logger.debug("FilePermission {} read write", (Object)path);
        path = path + File.separatorChar + "-";
        this.plugins.add(new FilePermission(path, "read"));
        this.plugins.add(new FilePermission(path, "write"));
        this.plugins.add(new FilePermission(path, "delete"));
        logger.debug("FilePermission {} read write delete", (Object)path);
    }

    private void addJavaPath(String path) {
        File parent;
        if (path != null && path.trim().length() >= 1 && (parent = new File(path).getParentFile()) != null) {
            this.addPath(parent.getAbsolutePath());
        }
    }

    private void addPath(String ... paths) {
        for (String path : paths) {
            if (path == null) continue;
            for (String dir : path.split(File.pathSeparator)) {
                String file = new File(dir).getAbsolutePath();
                this.jars.add(new FilePermission(file, "read"));
                logger.debug("FilePermission {} read from jars", (Object)file);
                file = file + File.separatorChar + "-";
                this.jars.add(new FilePermission(file, "read"));
                this.jars.add(new FilePermission(file, "execute"));
                logger.debug("FilePermission {} read execute from jars", (Object)file);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File[] getLoggingDirectories() throws IOException {
        ArrayList<File> directories = new ArrayList<File>();
        String fname = System.getProperty("java.util.logging.config.file");
        if (fname == null) {
            fname = System.getProperty("java.home");
            if (fname == null) {
                throw new AssertionError((Object)"Can't find java.home ??");
            }
            File f = new File(fname, "lib");
            f = new File(f, "logging.properties");
            fname = f.getCanonicalPath();
        }
        FileInputStream in = new FileInputStream(fname);
        try {
            Properties properties = new Properties();
            properties.load(in);
            String handlers = properties.getProperty("handlers");
            for (String logger : handlers.split("[\\s,]+")) {
                String pattern = properties.getProperty(logger + ".pattern");
                if (pattern == null) continue;
                File dir = this.getLogPatternDirectory(pattern);
                dir.mkdirs();
                directories.add(dir);
            }
            Object[] objectArray = directories.toArray(new File[directories.size()]);
            return objectArray;
        }
        finally {
            ((InputStream)in).close();
        }
    }

    private File getLogPatternDirectory(String pattern) {
        String tempPath = System.getProperty("java.io.tmpdir");
        boolean tempPathHasSepEnd = tempPath == null ? false : tempPath.endsWith(File.separator);
        String homePath = System.getProperty("user.home");
        boolean homePathHasSepEnd = homePath == null ? false : homePath.endsWith(File.separator);
        StringBuilder sb = new StringBuilder();
        pattern = pattern.replace('/', File.separatorChar);
        int cur = 0;
        int next = 0;
        char[] value = pattern.toCharArray();
        while ((next = pattern.indexOf(37, cur)) >= 0) {
            if (++next >= pattern.length()) continue;
            switch (value[next]) {
                case 't': {
                    sb.append(value, cur, next - cur - 1).append(tempPath);
                    if (tempPathHasSepEnd) break;
                    sb.append(File.separator);
                    break;
                }
                case 'h': {
                    sb.append(value, cur, next - cur - 1).append(homePath);
                    if (homePathHasSepEnd) break;
                    sb.append(File.separator);
                    break;
                }
                case '%': {
                    sb.append(value, cur, next - cur - 1).append('%');
                    break;
                }
                default: {
                    sb.append(value, cur, next - cur - 1);
                    return new File(sb.substring(0, sb.lastIndexOf(File.separator)));
                }
            }
            cur = ++next;
        }
        sb.append(value, cur, value.length - cur);
        return new File(sb.substring(0, sb.lastIndexOf(File.separator)));
    }
}

