/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.util;

import info.aduna.net.ParsedURI;
import java.net.URI;
import java.net.URISyntaxException;

public class URLUtil {
    public static String canonicalize(String iri) throws IllegalArgumentException {
        try {
            URI net = new URI(iri).normalize();
            String scheme = net.getScheme();
            if (scheme != null) {
                scheme = scheme.toLowerCase();
            }
            String frag = net.getRawFragment();
            if (net.isOpaque()) {
                String part = net.getSchemeSpecificPart();
                net = new URI(scheme, part, net.getFragment());
                return net.toASCIIString();
            }
            String auth = net.getAuthority();
            if (auth != null) {
                if ((auth = auth.toLowerCase()).endsWith(":")) {
                    auth = auth.substring(0, auth.length() - 1);
                } else if ("http".equals(scheme) && auth.endsWith(":80")) {
                    auth = auth.substring(0, auth.length() - 3);
                } else if ("https".equals(scheme) && auth.endsWith(":443")) {
                    auth = auth.substring(0, auth.length() - 4);
                }
            }
            String qs = net.getRawQuery();
            String path = net.getPath();
            if (path == null || "".equals(path)) {
                path = "/";
            } else {
                while (path.startsWith("/../")) {
                    path = path.substring(3);
                }
            }
            net = new URI(scheme, auth, path, null, null);
            StringBuilder sb = new StringBuilder(net.toASCIIString());
            if (qs != null) {
                sb.append('?').append(qs);
            }
            if (frag != null) {
                sb.append('#').append(frag);
            }
            return sb.toString();
        }
        catch (URISyntaxException x) {
            throw new IllegalArgumentException(x);
        }
    }

    public static String resolve(String relative, String base) throws IllegalArgumentException {
        return URLUtil.canonicalize(URLUtil.resolve(new ParsedURI(base), new ParsedURI(relative)).toString());
    }

    private static ParsedURI resolve(ParsedURI baseURI, ParsedURI relURI) {
        String path;
        String authority;
        if (relURI.isAbsolute() || baseURI.isOpaque()) {
            return relURI;
        }
        if (relURI.getAuthority() == null && relURI.getQuery() == null && relURI.getPath().length() == 0) {
            String fragment = relURI.getFragment();
            return new ParsedURI(baseURI.getScheme(), baseURI.getAuthority(), baseURI.getPath(), baseURI.getQuery(), fragment);
        }
        if (relURI.getAuthority() == null && relURI.getPath().length() == 0) {
            String query = relURI.getQuery();
            String fragment = relURI.getFragment();
            return new ParsedURI(baseURI.getScheme(), baseURI.getAuthority(), baseURI.getPath(), query, fragment);
        }
        boolean normalizeURI = false;
        String scheme = baseURI.getScheme();
        String query = relURI.getQuery();
        String fragment = relURI.getFragment();
        if (relURI.getAuthority() != null) {
            authority = relURI.getAuthority();
            path = relURI.getPath();
        } else {
            authority = baseURI.getAuthority();
            if (relURI.getPath().startsWith("/")) {
                path = relURI.getPath();
            } else {
                path = baseURI.getPath();
                if (path == null) {
                    path = "/";
                } else {
                    if (!path.endsWith("/")) {
                        int lastSlashIdx = path.lastIndexOf(47);
                        path = path.substring(0, lastSlashIdx + 1);
                    }
                    if (path.length() == 0) {
                        path = "/";
                    }
                }
                path = path + relURI.getPath();
                normalizeURI = true;
            }
        }
        ParsedURI result = new ParsedURI(scheme, authority, path, query, fragment);
        if (normalizeURI) {
            result.normalize();
        }
        return result;
    }
}

