/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.object;

import info.aduna.iteration.LookAheadIteration;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.contextaware.ContextAwareConnection;
import org.openrdf.repository.object.ObjectFactory;
import org.openrdf.repository.object.ObjectQuery;
import org.openrdf.repository.object.ObjectRepository;
import org.openrdf.repository.object.RDFObject;
import org.openrdf.repository.object.TypeManager;
import org.openrdf.repository.object.exceptions.BlobConflictException;
import org.openrdf.repository.object.exceptions.BlobStoreException;
import org.openrdf.repository.object.exceptions.ObjectPersistException;
import org.openrdf.repository.object.managers.helpers.WeakValueMap;
import org.openrdf.repository.object.result.ObjectIterator;
import org.openrdf.repository.object.traits.Mergeable;
import org.openrdf.repository.object.traits.RDFObjectBehaviour;
import org.openrdf.repository.object.traits.Refreshable;
import org.openrdf.result.Result;
import org.openrdf.result.impl.ResultImpl;
import org.openrdf.store.blob.BlobObject;
import org.openrdf.store.blob.BlobStore;
import org.openrdf.store.blob.BlobVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectConnection
extends ContextAwareConnection {
    final Logger logger = LoggerFactory.getLogger(ObjectConnection.class);
    private final ObjectRepository repository;
    private String language;
    private final TypeManager types;
    private final ObjectFactory of;
    private final Map<Object, Resource> assigned = new IdentityHashMap<Object, Resource>();
    private final Set<Resource> merged = new HashSet<Resource>();
    private final Map<Class<?>, Map<Integer, ObjectQuery>> queries = new HashMap();
    private final BlobStore blobs;
    private URI versionBundle;
    private BlobVersion blobVersion;
    private final Map<Resource, RDFObject> cachedObjects = new WeakValueMap(512);

    public static void close(Iterator<?> iter) {
        ObjectIterator.close(iter);
    }

    protected ObjectConnection(ObjectRepository repository, RepositoryConnection connection, ObjectFactory factory, TypeManager types, BlobStore blobs) throws RepositoryException {
        super((Repository)repository, connection);
        this.repository = repository;
        this.of = factory;
        this.types = types;
        this.blobs = blobs;
        types.setConnection(this);
        factory.setObjectConnection(this);
    }

    public ObjectRepository getRepository() {
        return this.repository;
    }

    public URI getVersionBundle() {
        return this.versionBundle;
    }

    public void setVersionBundle(URI bundle) {
        this.versionBundle = bundle;
        if (null == this.getInsertContext()) {
            this.setInsertContext(bundle);
        }
    }

    public String toString() {
        URI uri = this.getVersionBundle();
        if (uri == null) {
            return this.getDelegate().toString();
        }
        return uri.stringValue();
    }

    public void close() throws RepositoryException {
        try {
            super.close();
        }
        finally {
            this.cachedObjects.clear();
        }
    }

    public synchronized void rollback() throws RepositoryException {
        if (this.blobVersion != null) {
            try {
                this.blobVersion.rollback();
            }
            catch (IOException e) {
                throw new RepositoryException(e.toString(), (Throwable)e);
            }
        }
        super.rollback();
        this.cachedObjects.clear();
    }

    public synchronized void commit() throws RepositoryException {
        try {
            try {
                if (this.blobVersion != null) {
                    try {
                        this.blobVersion.prepare();
                    }
                    catch (IOException exc) {
                        throw new BlobConflictException(exc);
                    }
                }
                super.commit();
                if (this.blobVersion != null) {
                    this.blobVersion.commit();
                    this.blobVersion = null;
                }
            }
            finally {
                if (this.blobVersion != null) {
                    this.blobVersion.rollback();
                }
            }
        }
        catch (IOException e) {
            throw new BlobStoreException(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void setAutoCommit(boolean auto) throws RepositoryException {
        if (!auto && this.isAutoCommit()) {
            try {
                try {
                    if (this.blobVersion != null) {
                        try {
                            this.blobVersion.prepare();
                        }
                        catch (IOException exc) {
                            throw new BlobConflictException(exc);
                        }
                    }
                    super.setAutoCommit(auto);
                    if (this.blobVersion == null) return;
                    this.blobVersion.commit();
                    this.blobVersion = null;
                    return;
                }
                finally {
                    if (this.blobVersion != null) {
                        this.blobVersion.rollback();
                        this.blobVersion = null;
                    }
                }
            }
            catch (IOException e) {
                throw new BlobStoreException(e);
            }
        }
        super.setAutoCommit(auto);
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String lang) {
        this.language = lang;
    }

    public ObjectFactory getObjectFactory() {
        return this.of;
    }

    public Value addObject(Object instance) throws RepositoryException {
        Class<?> type;
        RDFObjectBehaviour support;
        Object entity;
        if (instance instanceof RDFObjectBehaviour && (entity = (support = (RDFObjectBehaviour)instance).getBehaviourDelegate()) != instance) {
            return this.addObject(entity);
        }
        if (instance instanceof RDFObject) {
            if (((RDFObject)instance).getObjectConnection() == this) {
                return ((RDFObject)instance).getResource();
            }
        } else if (this.of.isDatatype(instance.getClass())) {
            return this.of.createLiteral(instance);
        }
        if (RDFObject.class.isAssignableFrom(type = instance.getClass()) || this.isEntity(type)) {
            Resource resource = this.assignResource(instance);
            if (!this.isAlreadyMerged(resource)) {
                this.addObject(resource, instance);
            }
            return resource;
        }
        return this.of.createLiteral(instance);
    }

    public void addObject(String uri, Object entity) throws RepositoryException {
        this.addObject((Resource)this.getValueFactory().createURI(uri), entity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addObject(Resource resource, Object entity) throws RepositoryException {
        Object support;
        Object delegate;
        if (entity instanceof RDFObjectBehaviour && (delegate = (support = (RDFObjectBehaviour)entity).getBehaviourDelegate()) != entity) {
            this.addObject(resource, delegate);
            return;
        }
        support = this.merged;
        synchronized (support) {
            this.merged.add(resource);
        }
        boolean autoCommit = this.isAutoCommit();
        if (autoCommit) {
            this.setAutoCommit(false);
        }
        try {
            Class<?> proxy = entity.getClass();
            Set list = this.getTypes(proxy, new HashSet(4));
            for (URI type : list) {
                this.types.addTypeStatement(resource, type);
            }
            RDFObject result = this.of.createObject(resource, (Set<URI>)list);
            if (result instanceof Mergeable) {
                ((Mergeable)((Object)result)).merge(entity);
            }
            if (autoCommit) {
                this.setAutoCommit(true);
            }
            this.cachedObjects.remove(resource);
        }
        finally {
            if (autoCommit && !this.isAutoCommit()) {
                this.rollback();
                this.setAutoCommit(true);
            }
        }
    }

    public <T> T addDesignation(Object entity, Class<T> concept) throws RepositoryException {
        RDFObjectBehaviour support;
        Object delegate;
        if (entity instanceof RDFObjectBehaviour && (delegate = (support = (RDFObjectBehaviour)entity).getBehaviourDelegate()) != entity) {
            return this.addDesignation(delegate, concept);
        }
        Resource resource = this.findResource(entity);
        HashSet<URI> types = new HashSet<URI>(4);
        this.getTypes(entity.getClass(), types);
        this.addConcept(resource, concept, types);
        RDFObject bean = this.of.createObject(resource, types);
        assert (this.assertConceptRecorded(bean, concept));
        return (T)this.cache(bean);
    }

    public Object addDesignation(Object entity, String uri) throws RepositoryException {
        return this.addDesignations(entity, this.getValueFactory().createURI(uri));
    }

    public Object addDesignation(Object entity, URI type) throws RepositoryException {
        return this.addDesignations(entity, type);
    }

    public Object addDesignations(Object entity, String ... uris) throws RepositoryException {
        URI[] types = new URI[uris.length];
        for (int i = 0; i < uris.length; ++i) {
            types[i] = this.getValueFactory().createURI(uris[i]);
        }
        return this.addDesignations(entity, types);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object addDesignations(Object entity, URI ... types) throws RepositoryException {
        RDFObjectBehaviour support;
        Object delegate;
        if (entity instanceof RDFObjectBehaviour && (delegate = (support = (RDFObjectBehaviour)entity).getBehaviourDelegate()) != entity) {
            return this.addDesignations(delegate, types);
        }
        assert (types != null && types.length > 0);
        Resource resource = this.findResource(entity);
        HashSet<URI> list = new HashSet<URI>(4);
        this.getTypes(entity.getClass(), list);
        boolean autoCommit = this.isAutoCommit();
        if (autoCommit) {
            this.setAutoCommit(false);
        }
        try {
            for (URI type : types) {
                this.types.addTypeStatement(resource, type);
                list.add(type);
            }
            if (autoCommit) {
                this.setAutoCommit(true);
            }
        }
        finally {
            if (autoCommit && !this.isAutoCommit()) {
                this.rollback();
                this.setAutoCommit(true);
            }
        }
        return this.cache(this.of.createObject(resource, list));
    }

    public void removeDesignation(Object entity, Class<?> concept) throws RepositoryException {
        Resource resource = this.findResource(entity);
        URI type = this.of.getNameOf(concept);
        if (type == null) {
            throw new ObjectPersistException("Concept is anonymous or is not registered: " + concept.getSimpleName());
        }
        this.types.removeTypeStatement(resource, type);
        this.cachedObjects.remove(resource);
    }

    public void removeDesignation(Object entity, String uri) throws RepositoryException {
        this.removeDesignations(entity, this.getValueFactory().createURI(uri));
    }

    public void removeDesignation(Object entity, URI type) throws RepositoryException {
        this.removeDesignations(entity, type);
    }

    public void removeDesignations(Object entity, String ... uris) throws RepositoryException {
        URI[] types = new URI[uris.length];
        for (int i = 0; i < uris.length; ++i) {
            types[i] = this.getValueFactory().createURI(uris[i]);
        }
        this.removeDesignations(entity, types);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDesignations(Object entity, URI ... types) throws RepositoryException {
        assert (types != null && types.length > 0);
        boolean autoCommit = this.isAutoCommit();
        if (autoCommit) {
            this.setAutoCommit(false);
        }
        try {
            Resource resource = this.findResource(entity);
            for (URI type : types) {
                this.types.removeTypeStatement(resource, type);
            }
            if (autoCommit) {
                this.setAutoCommit(true);
            }
            this.cachedObjects.remove(resource);
        }
        finally {
            if (autoCommit && !this.isAutoCommit()) {
                this.rollback();
                this.setAutoCommit(true);
            }
        }
    }

    public Object getObject(String uri) throws RepositoryException {
        assert (uri != null);
        return this.getObject((Value)this.getValueFactory().createURI(uri));
    }

    public Object getObject(Value value) throws RepositoryException {
        assert (value != null);
        if (value instanceof Literal) {
            return this.of.createObject((Literal)value);
        }
        Resource resource = (Resource)value;
        RDFObject cached = this.cached(resource);
        if (cached != null) {
            return cached;
        }
        return this.cache(this.of.createObject(resource, this.types.getTypes(resource)));
    }

    public <T> T getObject(Class<T> concept, String uri) throws RepositoryException, QueryEvaluationException {
        assert (uri != null);
        return this.getObject(concept, (Resource)this.getValueFactory().createURI(uri));
    }

    public <T> T getObject(Class<T> concept, Resource resource) throws RepositoryException, QueryEvaluationException {
        RDFObject cached = this.cached(resource);
        if (concept.isInstance(cached)) {
            return concept.cast(cached);
        }
        return this.getObjects(concept, resource).singleResult();
    }

    public Object getObject(Set<URI> types, Resource resource) {
        Class<?> proxy = this.of.getObjectClass(resource, types);
        RDFObject cached = this.cached(resource);
        if (cached != null && cached.getClass().equals(proxy)) {
            return cached;
        }
        return this.cache(this.of.createBean(resource, proxy));
    }

    public synchronized <T> Result<T> getObjects(Class<T> concept) throws RepositoryException, QueryEvaluationException {
        try {
            return this.getObjectQuery(concept, 0).evaluate(concept);
        }
        catch (MalformedQueryException e) {
            throw new AssertionError((Object)e);
        }
    }

    public <T> Result<T> getObjects(Class<T> concept, String ... uris) throws RepositoryException, QueryEvaluationException {
        ValueFactory vf = this.getValueFactory();
        Resource[] resources = new Resource[uris.length];
        for (int i = 0; i < uris.length; ++i) {
            resources[i] = vf.createURI(uris[i]);
        }
        return this.getObjects(concept, resources);
    }

    public synchronized <T> Result<T> getObjects(Class<T> concept, Resource ... resources) throws RepositoryException, QueryEvaluationException {
        try {
            int size = resources.length;
            ObjectQuery query = this.getObjectQuery(concept, size);
            if (size == 1) {
                query.setBinding("subj", (Value)resources[0]);
            } else if (size > 1) {
                for (int i = 0; i < size; ++i) {
                    query.setBinding("subj" + i, (Value)resources[i]);
                }
            }
            final ArrayList<Resource> list = new ArrayList<Resource>(size);
            list.addAll(Arrays.asList(resources));
            final Result<T> result = query.evaluate(concept);
            LookAheadIteration iter = new LookAheadIteration<T, QueryEvaluationException>(){

                protected T getNextElement() throws QueryEvaluationException {
                    Object next = result.next();
                    if (next != null) {
                        list.remove(((RDFObject)next).getResource());
                        return next;
                    }
                    if (!list.isEmpty()) {
                        return ObjectConnection.this.cache(ObjectConnection.this.of.createObject((Resource)list.remove(0)));
                    }
                    return null;
                }
            };
            return new ResultImpl(iter);
        }
        catch (MalformedQueryException e) {
            throw new AssertionError((Object)e);
        }
    }

    public <T> T refresh(T object) throws RepositoryException {
        Resource resource = this.findResource(object);
        if (object instanceof Refreshable) {
            ((Refreshable)object).refresh();
        }
        Set<URI> types = this.types.getTypes(resource);
        Class<?> proxy = this.of.getObjectClass(resource, types);
        RDFObject cached = this.cached(resource);
        if (cached != null && cached != object && cached instanceof Refreshable) {
            ((Refreshable)((Object)cached)).refresh();
        }
        if (cached != null && cached.getClass().equals(proxy)) {
            return (T)cached;
        }
        return (T)this.cache(this.of.createBean(resource, proxy));
    }

    public synchronized BlobObject getBlobObject(String uri) throws RepositoryException {
        if (this.blobs == null) {
            throw new RepositoryException("No configured blob store");
        }
        try {
            if (this.blobVersion == null && this.isAutoCommit()) {
                return this.blobs.open(uri);
            }
            if (this.blobVersion == null) {
                URI version = this.getVersionBundle();
                this.blobVersion = version == null ? this.blobs.newVersion() : this.blobs.newVersion(version.stringValue());
                return this.blobVersion.open(uri);
            }
            return this.blobVersion.open(uri);
        }
        catch (IOException exc) {
            throw new RepositoryException((Throwable)exc);
        }
    }

    public BlobObject getBlobObject(URI uri) throws RepositoryException {
        return this.getBlobObject(uri.stringValue());
    }

    public ObjectQuery prepareObjectQuery(QueryLanguage ql, String query, String baseURI) throws MalformedQueryException, RepositoryException {
        return this.createObjectQuery(this.prepareTupleQuery(ql, query, baseURI));
    }

    public ObjectQuery prepareObjectQuery(QueryLanguage ql, String query) throws MalformedQueryException, RepositoryException {
        return this.createObjectQuery(this.prepareTupleQuery(ql, query));
    }

    public ObjectQuery prepareObjectQuery(String query) throws MalformedQueryException, RepositoryException {
        return this.createObjectQuery(this.prepareTupleQuery(query));
    }

    RDFObject cache(RDFObject object) {
        this.cachedObjects.put(object.getResource(), object);
        return object;
    }

    RDFObject cached(Resource resource) {
        return this.cachedObjects.get(resource);
    }

    private <T> ObjectQuery getObjectQuery(Class<T> concept, int length) throws MalformedQueryException, RepositoryException {
        if (this.queries.containsKey(concept) && this.queries.get(concept).containsKey(length)) {
            return this.queries.get(concept).get(length);
        }
        String sparql = this.of.createObjectQuery(concept, length);
        ObjectQuery query = this.prepareObjectQuery(QueryLanguage.SPARQL, sparql);
        Map<Integer, ObjectQuery> map = this.queries.get(concept);
        if (map == null) {
            map = new HashMap<Integer, ObjectQuery>();
            this.queries.put(concept, map);
        }
        map.put(length, query);
        return query;
    }

    private ObjectQuery createObjectQuery(TupleQuery query) {
        return new ObjectQuery(this, query);
    }

    private Resource findResource(Object object) {
        if (object instanceof RDFObject) {
            return ((RDFObject)object).getResource();
        }
        throw new ObjectPersistException("Object not created by this ObjectFactory: " + object.getClass().getSimpleName());
    }

    private boolean isEntity(Class<?> type) {
        if (type == null) {
            return false;
        }
        for (Class<?> face : type.getInterfaces()) {
            if (!this.of.isNamedConcept(face)) continue;
            return true;
        }
        if (this.of.isNamedConcept(type)) {
            return true;
        }
        return this.isEntity(type.getSuperclass());
    }

    private boolean assertConceptRecorded(Object bean, Class<?> concept) {
        assert (!concept.isInterface() || concept.isAssignableFrom(bean.getClass())) : "Concept is Anonymous or has not bean recorded: " + concept.getSimpleName();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Resource assignResource(Object bean) {
        Map<Object, Resource> map = this.assigned;
        synchronized (map) {
            if (this.assigned.containsKey(bean)) {
                return this.assigned.get(bean);
            }
            Resource resource = null;
            if (bean instanceof RDFObject) {
                resource = ((RDFObject)bean).getResource();
            }
            if (resource == null) {
                resource = this.getValueFactory().createBNode();
            }
            this.assigned.put(bean, resource);
            return resource;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isAlreadyMerged(Resource resource) {
        Set<Resource> set = this.merged;
        synchronized (set) {
            return this.merged.contains(resource);
        }
    }

    private <C extends Collection<URI>> C getTypes(Class<?> role, C set) throws RepositoryException {
        URI type = this.of.getNameOf(role);
        if (type == null) {
            Class<?> superclass = role.getSuperclass();
            if (superclass != null) {
                this.getTypes(superclass, set);
            }
            Class<?>[] interfaces = role.getInterfaces();
            int n = interfaces.length;
            for (int i = 0; i < n; ++i) {
                this.getTypes(interfaces[i], set);
            }
        } else {
            set.add((URI)type);
        }
        return set;
    }

    private <C extends Collection<URI>> C addConcept(Resource resource, Class<?> role, C set) throws RepositoryException {
        URI type = this.of.getNameOf(role);
        if (type == null) {
            throw new ObjectPersistException("Concept is anonymous or is not registered: " + role.getSimpleName());
        }
        this.types.addTypeStatement(resource, type);
        set.add((URI)type);
        return set;
    }
}

