/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.object;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.repository.object.ObjectConnection;
import org.openrdf.repository.object.RDFObject;
import org.openrdf.repository.object.advisers.helpers.ObjectQueryFactory;
import org.openrdf.repository.object.composition.ClassResolver;
import org.openrdf.repository.object.exceptions.ObjectCompositionException;
import org.openrdf.repository.object.managers.LiteralManager;
import org.openrdf.repository.object.traits.ManagedRDFObject;
import org.openrdf.repository.object.traits.RDFObjectBehaviour;

public class ObjectFactory {
    static final String VAR_PREFIX = "subj";
    private LiteralManager lm;
    private ClassResolver resolver;
    private ObjectConnection connection;
    private Map<Class<?>, ObjectQueryFactory> factories;

    protected ObjectFactory(ClassResolver resolver, LiteralManager lm) {
        assert (lm != null);
        assert (resolver != null);
        this.lm = lm;
        this.resolver = resolver;
    }

    public ClassLoader getClassLoader() {
        return this.resolver.getClassLoader();
    }

    public Object createObject(Literal literal) {
        return this.lm.createObject(literal);
    }

    public Literal createLiteral(Object object) {
        return this.lm.createLiteral(object);
    }

    public Value createValue(Object instance) {
        URI type;
        RDFObjectBehaviour support;
        Object entity;
        if (instance instanceof RDFObjectBehaviour && (entity = (support = (RDFObjectBehaviour)instance).getBehaviourDelegate()) != instance) {
            return this.createValue(entity);
        }
        if (instance instanceof RDFObject) {
            return ((RDFObject)instance).getResource();
        }
        if (instance instanceof Class && (type = this.getNameOf((Class)instance)) != null) {
            return type;
        }
        return this.lm.createLiteral(instance);
    }

    public RDFObject createObject() {
        if (this.connection == null) {
            throw new IllegalStateException("No ObjectConnection");
        }
        BNode node = this.connection.getValueFactory().createBNode();
        return this.createBean((Resource)node, this.resolver.resolveBlankEntity());
    }

    public RDFObject createObject(String uri) {
        if (this.connection == null) {
            throw new IllegalStateException("No ObjectConnection");
        }
        ValueFactory vf = this.connection.getValueFactory();
        return this.createObject((Resource)vf.createURI(uri));
    }

    public RDFObject createObject(Resource resource) {
        assert (resource != null);
        if (resource instanceof URI) {
            return this.createBean(resource, this.resolver.resolveEntity((URI)resource));
        }
        return this.createBean(resource, this.resolver.resolveBlankEntity());
    }

    public <T> T createObject(String uri, Class<T> type) {
        if (this.connection == null) {
            throw new IllegalStateException("No ObjectConnection");
        }
        ValueFactory vf = this.connection.getValueFactory();
        return this.createObject((Resource)vf.createURI(uri), type);
    }

    public <T> T createObject(Resource resource, Class<T> type) {
        RDFObject obj;
        URI rdftype = this.getNameOf(type);
        if (rdftype == null) {
            obj = this.createObject(resource);
        } else {
            Set<URI> types = Collections.singleton(rdftype);
            obj = this.createObject(resource, types);
        }
        try {
            return type.cast(obj);
        }
        catch (ClassCastException e) {
            String msg = "Cannot cast resource " + obj + " to a " + type.getName();
            ClassCastException cce = new ClassCastException(msg);
            cce.initCause(e);
            throw cce;
        }
    }

    public RDFObject createObject(String uri, URI ... types) {
        if (this.connection == null) {
            throw new IllegalStateException("No ObjectConnection");
        }
        ValueFactory vf = this.connection.getValueFactory();
        return this.createObject((Resource)vf.createURI(uri), types);
    }

    public RDFObject createObject(Resource resource, URI ... types) {
        assert (types != null && types.length > 0);
        HashSet<URI> list = new HashSet<URI>(Arrays.asList(types));
        return this.createObject(resource, list);
    }

    public RDFObject createObject(String uri, Set<URI> types) {
        if (this.connection == null) {
            throw new IllegalStateException("No ObjectConnection");
        }
        ValueFactory vf = this.connection.getValueFactory();
        return this.createObject((Resource)vf.createURI(uri), types);
    }

    public RDFObject createObject(Resource resource, Set<URI> types) {
        assert (resource != null);
        return this.createBean(resource, this.getObjectClass(resource, types));
    }

    public boolean isNamedConcept(Class<?> type) {
        return this.resolver.getRoleMapper().findType(type) != null;
    }

    public boolean isDatatype(Class<?> type) {
        return this.lm.isDatatype(type);
    }

    public URI getNameOf(Class<?> concept) {
        return this.resolver.getRoleMapper().findType(concept);
    }

    protected void setObjectConnection(ObjectConnection connection) {
        this.connection = connection;
        this.factories = new HashMap();
    }

    protected String createObjectQuery(Class<?> concept, int bindings) {
        StringBuilder w;
        Map<String, String> map;
        Object w2;
        String name_class;
        String pred;
        String name;
        boolean typed;
        Collection subjectProperties = this.resolver.getPropertyMapper().findFunctionalProperties(concept);
        Collection subjectFields = this.resolver.getPropertyMapper().findFunctionalFields(concept);
        StringBuilder select = new StringBuilder();
        StringBuilder where = new StringBuilder();
        select.append("SELECT REDUCED ?subj");
        boolean namedTypePresent = this.resolver.getRoleMapper().isNamedTypePresent();
        if (namedTypePresent) {
            select.append(" ?subj_class");
        }
        where.append("\nWHERE { ");
        URI uri = this.getNameOf(concept);
        boolean bl = typed = uri != null && bindings == 0;
        if (typed) {
            HashSet types = new HashSet();
            this.resolver.getRoleMapper().findSubTypes(concept, types);
            Iterator iter = types.iterator();
            assert (iter.hasNext());
            while (iter.hasNext()) {
                where.append("\n{ ?subj a <");
                where.append(((URI)iter.next()).stringValue()).append(">}");
                if (!iter.hasNext()) continue;
                where.append(" UNION ");
            }
            if (namedTypePresent) {
                where.append("\nOPTIONAL {").append(" ?subj <");
                where.append(RDF.TYPE);
                where.append("> ?subj_class } ");
            }
        } else {
            where.append("\n?subj a ?subj_class .");
        }
        String type = RDF.TYPE.stringValue();
        for (PropertyDescriptor pd : subjectProperties) {
            name = pd.getName();
            pred = this.resolver.getPropertyMapper().findPredicate(pd);
            this.optional(select, name, where.append("\n"), null, pred);
            if (pd.getPropertyType().equals(Object.class)) {
                if (namedTypePresent) {
                    name_class = name + "_class";
                    w2 = where.append("\n\t");
                    this.optional(select, name_class, (StringBuilder)w2, name, type).append("}\n");
                }
            } else if (this.isNamedConcept(pd.getPropertyType())) {
                map = this.findEagerProperties(pd.getPropertyType());
                for (String n : map.keySet()) {
                    w = where.append("\n\t");
                    this.optional(select, name + "_" + n, w, name, map.get(n)).append("}");
                }
                where.append("\n");
            }
            where.append("}");
        }
        for (Field f : subjectFields) {
            name = f.getName();
            pred = this.resolver.getPropertyMapper().findPredicate(f);
            this.optional(select, name, where.append("\n"), null, pred);
            if (f.getType().equals(Object.class)) {
                if (namedTypePresent) {
                    name_class = name + "_class";
                    w2 = where.append("\n\t");
                    this.optional(select, name_class, (StringBuilder)w2, name, type).append("}\n");
                }
            } else if (this.isNamedConcept(f.getType())) {
                map = this.findEagerProperties(f.getType());
                for (String n : map.keySet()) {
                    w = where.append("\n\t");
                    this.optional(select, name + "_" + n, w, name, map.get(n)).append("}");
                }
                where.append("\n");
            }
            where.append("}");
        }
        if (bindings > 1) {
            where.append("\nFILTER (");
            for (int i = 0; i < bindings; ++i) {
                where.append(" ?subj = $subj").append(i).append(" ||");
            }
            where.delete(where.length() - 2, where.length());
            where.append(")");
        }
        where.append(" } ");
        if (bindings > 1) {
            where.append("\nORDER BY ?subj");
        }
        return select.append((CharSequence)where).toString();
    }

    Class<?> getObjectClass(Resource resource, Set<URI> types) {
        Class proxy = resource instanceof URI ? (types.isEmpty() ? this.resolver.resolveEntity((URI)resource) : this.resolver.resolveEntity((URI)resource, types)) : (types.isEmpty() ? this.resolver.resolveBlankEntity() : this.resolver.resolveBlankEntity(types));
        return proxy;
    }

    RDFObject createBean(Resource resource, Class<?> proxy) {
        if (this.connection == null) {
            throw new IllegalStateException("No ObjectConnection");
        }
        try {
            ObjectQueryFactory factory = this.createObjectQueryFactory(proxy);
            Object obj = this.newInstance(proxy);
            ManagedRDFObject bean = (ManagedRDFObject)obj;
            bean.initRDFObject(resource, factory, this.connection);
            return (RDFObject)obj;
        }
        catch (InstantiationException e) {
            throw new ObjectCompositionException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ObjectCompositionException((Throwable)e);
        }
    }

    private Map<String, String> findEagerProperties(Class<?> type) {
        Map result = this.resolver.getPropertyMapper().findEagerProperties(type);
        if (result == null && this.resolver.getRoleMapper().isNamedTypePresent()) {
            return Collections.singletonMap("class", RDF.TYPE.stringValue());
        }
        if (result == null) {
            return Collections.emptyMap();
        }
        return result;
    }

    private StringBuilder optional(StringBuilder select, String name, StringBuilder where, String subj, String pred) {
        select.append(" ?subj_").append(name);
        where.append("OPTIONAL {");
        if (subj == null) {
            where.append(" ?subj");
        } else {
            where.append(" ?subj_").append(subj);
        }
        where.append(" <");
        return where.append(pred).append("> ?subj_").append(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ObjectQueryFactory createObjectQueryFactory(Class<?> proxy) {
        if (this.factories == null) {
            return null;
        }
        Map<Class<?>, ObjectQueryFactory> map = this.factories;
        synchronized (map) {
            ObjectQueryFactory factory = this.factories.get(proxy);
            if (factory == null) {
                factory = new ObjectQueryFactory(this.connection, this.resolver.getPropertyMapper());
                this.factories.put(proxy, factory);
            }
            return factory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object newInstance(Class<?> proxy) throws InstantiationException, IllegalAccessException {
        ClassLoader pcl = proxy.getClassLoader();
        if (pcl == null) {
            return proxy.newInstance();
        }
        ClassLoader classLoader = pcl;
        synchronized (classLoader) {
            return proxy.newInstance();
        }
    }
}

