/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.object;

import info.aduna.iteration.CloseableIteration;
import java.util.List;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.query.BindingSet;
import org.openrdf.query.Dataset;
import org.openrdf.query.Query;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.repository.object.ObjectConnection;
import org.openrdf.repository.object.result.ObjectArrayCursor;
import org.openrdf.repository.object.result.ObjectCursor;
import org.openrdf.result.Result;
import org.openrdf.result.impl.ResultImpl;

public class ObjectQuery
implements Query {
    protected ObjectConnection manager;
    protected TupleQuery query;

    public ObjectQuery(ObjectConnection manager, TupleQuery query) {
        assert (manager != null);
        assert (query != null);
        this.manager = manager;
        this.query = query;
    }

    public BindingSet getBindings() {
        return this.query.getBindings();
    }

    public void removeBinding(String name) {
        this.query.removeBinding(name);
    }

    public void setBinding(String name, Value value) {
        this.query.setBinding(name, value);
    }

    public Dataset getDataset() {
        return this.query.getDataset();
    }

    public void setDataset(Dataset arg0) {
        this.query.setDataset(arg0);
    }

    public int getMaxQueryTime() {
        return this.query.getMaxQueryTime();
    }

    public void setMaxQueryTime(int sec) {
        this.query.setMaxQueryTime(sec);
    }

    public void setMaxExecutionTime(int maxExecTime) {
        this.query.setMaxExecutionTime(maxExecTime);
    }

    public int getMaxExecutionTime() {
        return this.query.getMaxExecutionTime();
    }

    public boolean getIncludeInferred() {
        return this.query.getIncludeInferred();
    }

    public void setIncludeInferred(boolean include) {
        this.query.setIncludeInferred(include);
    }

    public void clearBindings() {
        this.query.clearBindings();
    }

    public void setObject(String name, Object value) {
        if (value == null) {
            this.setBinding(name, null);
        } else {
            this.setBinding(name, this.manager.getObjectFactory().createValue(value));
        }
    }

    public void setType(String name, Class<?> concept) {
        URI type = this.manager.getObjectFactory().getNameOf(concept);
        if (concept != null && type == null) {
            throw new IllegalArgumentException("Not a registered concept: " + concept);
        }
        this.setBinding(name, (Value)type);
    }

    public Result<?> evaluate() throws QueryEvaluationException {
        TupleQueryResult result = this.query.evaluate();
        List bindings = result.getBindingNames();
        return new ResultImpl(this.createCursor(result, bindings));
    }

    public <T> Result<T> evaluate(Class<T> concept) throws QueryEvaluationException {
        TupleQueryResult tuple = this.query.evaluate();
        List bindings = tuple.getBindingNames();
        if (concept.isArray() && !this.manager.getObjectFactory().isDatatype(concept)) {
            ObjectArrayCursor cursor = new ObjectArrayCursor(this.manager, tuple, bindings, concept.getComponentType());
            ResultImpl<T> result = new ResultImpl<T>(cursor, concept);
            return result;
        }
        String binding = (String)bindings.get(0);
        ObjectCursor cursor = new ObjectCursor(this.manager, (CloseableIteration<BindingSet, QueryEvaluationException>)tuple, binding);
        ResultImpl<T> result = new ResultImpl<T>(cursor, concept);
        return result;
    }

    public Result<Object[]> evaluate(Class<?> ... concepts) throws QueryEvaluationException {
        TupleQueryResult tuple = this.query.evaluate();
        List<String> bindings = tuple.getBindingNames();
        bindings = bindings.subList(0, concepts.length);
        return new ResultImpl<Object[]>((CloseableIteration<Object[], QueryEvaluationException>)new ObjectArrayCursor(this.manager, tuple, bindings));
    }

    public String toString() {
        return this.query.toString();
    }

    private CloseableIteration<?, QueryEvaluationException> createCursor(TupleQueryResult result, List<String> bindings) throws QueryEvaluationException {
        if (bindings.size() > 1) {
            return new ObjectArrayCursor(this.manager, result, bindings);
        }
        return new ObjectCursor(this.manager, (CloseableIteration<BindingSet, QueryEvaluationException>)result, bindings.get(0));
    }
}

