/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.object;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import org.openrdf.model.ValueFactory;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.contextaware.ContextAwareRepository;
import org.openrdf.repository.object.ObjectConnection;
import org.openrdf.repository.object.ObjectFactory;
import org.openrdf.repository.object.ObjectService;
import org.openrdf.repository.object.ObjectServiceImpl;
import org.openrdf.repository.object.TypeManager;
import org.openrdf.repository.object.exceptions.ObjectStoreConfigException;
import org.openrdf.store.blob.BlobStore;
import org.openrdf.store.blob.BlobStoreFactory;

public class ObjectRepository
extends ContextAwareRepository {
    private ObjectService service;
    private File dataDir;
    private String blobStoreUrl;
    private Map<String, String> blobStoreParameters;
    private BlobStore blobs;

    public ObjectRepository() throws ObjectStoreConfigException {
        this.service = new ObjectServiceImpl();
    }

    public ObjectRepository(ObjectService objectService) {
        this.service = objectService;
    }

    public ObjectService getObjectService() {
        return this.service;
    }

    public void setObjectService(ObjectService service) {
        this.service = service;
    }

    public synchronized String getBlobStoreUrl() {
        return this.blobStoreUrl;
    }

    public synchronized void setBlobStoreUrl(String blobStoreUrl) {
        this.blobStoreUrl = blobStoreUrl;
        this.blobs = null;
    }

    public synchronized Map<String, String> getBlobStoreParameters() {
        return this.blobStoreParameters;
    }

    public synchronized void setBlobStoreParameters(Map<String, String> blobStoreParameters) {
        this.blobStoreParameters = blobStoreParameters;
        this.blobs = null;
    }

    public File getDataDir() {
        File dataDir = super.getDataDir();
        if (dataDir == null) {
            return this.dataDir;
        }
        return dataDir;
    }

    public void setDataDir(File dataDir) {
        this.dataDir = dataDir;
        super.setDataDir(dataDir);
    }

    public synchronized void initialize() throws RepositoryException {
        super.initialize();
        try {
            this.getBlobStore();
        }
        catch (ObjectStoreConfigException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public ValueFactory getURIFactory() {
        return super.getValueFactory();
    }

    public ValueFactory getLiteralFactory() {
        return super.getValueFactory();
    }

    public synchronized BlobStore getBlobStore() throws ObjectStoreConfigException {
        if (this.blobStoreUrl != null && this.blobs == null) {
            try {
                File dataDir = this.getDataDir();
                if (dataDir == null) {
                    dataDir = new File(".");
                }
                URI base = dataDir.toURI();
                String url = base.resolve(this.blobStoreUrl).toString();
                BlobStoreFactory bsf = BlobStoreFactory.newInstance();
                this.blobs = bsf.openBlobStore(url, this.blobStoreParameters);
            }
            catch (IOException e) {
                throw new ObjectStoreConfigException((Throwable)e);
            }
            catch (IllegalArgumentException e) {
                throw new ObjectStoreConfigException((Throwable)e);
            }
        }
        return this.blobs;
    }

    public synchronized void setBlobStore(BlobStore store) {
        this.blobs = store;
    }

    public ObjectConnection getConnection() throws RepositoryException {
        BlobStore blobs;
        try {
            blobs = this.getBlobStore();
        }
        catch (ObjectStoreConfigException e) {
            throw new RepositoryException((Throwable)e);
        }
        ObjectFactory factory = this.service.createObjectFactory();
        RepositoryConnection conn = this.getDelegate().getConnection();
        ObjectConnection con = new ObjectConnection(this, conn, factory, this.createTypeManager(), blobs);
        con.setIncludeInferred(this.isIncludeInferred());
        con.setMaxQueryTime(this.getMaxQueryTime());
        con.setQueryLanguage(this.getQueryLanguage());
        con.setReadContexts(this.getReadContexts());
        con.setAddContexts(this.getAddContexts());
        con.setRemoveContexts(this.getRemoveContexts());
        con.setArchiveContexts(this.getArchiveContexts());
        return con;
    }

    protected TypeManager createTypeManager() {
        return new TypeManager(true);
    }
}

