/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.object;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.RepositoryResult;
import org.openrdf.repository.object.ObjectConnection;

public class TypeManager {
    private boolean readTypes;
    private ObjectConnection conn;

    public TypeManager(boolean readTypes) {
        this.readTypes = readTypes;
    }

    public void setConnection(ObjectConnection conn) {
        this.conn = conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<URI> getTypes(Resource res) throws RepositoryException {
        if (!this.readTypes) {
            return Collections.emptySet();
        }
        RepositoryResult match = this.conn.getStatements(res, RDF.TYPE, null, new Resource[0]);
        try {
            if (!match.hasNext()) {
                Set<URI> set = Collections.emptySet();
                return set;
            }
            Value obj = ((Statement)match.next()).getObject();
            if (obj instanceof URI && !match.hasNext()) {
                Set<URI> set = Collections.singleton((URI)obj);
                return set;
            }
            HashSet<URI> types = new HashSet<URI>(4);
            if (obj instanceof URI) {
                types.add((URI)obj);
            }
            while (match.hasNext()) {
                obj = ((Statement)match.next()).getObject();
                if (!(obj instanceof URI)) continue;
                types.add((URI)obj);
            }
            HashSet<URI> hashSet = types;
            return hashSet;
        }
        finally {
            match.close();
        }
    }

    public void addTypeStatement(Resource resource, URI type) throws RepositoryException {
        if (!RDFS.RESOURCE.equals((Object)type)) {
            this.conn.add(resource, RDF.TYPE, (Value)type, new Resource[0]);
        }
    }

    public void removeTypeStatement(Resource resource, URI type) throws RepositoryException {
        this.conn.remove(resource, RDF.TYPE, (Value)type, new Resource[0]);
    }
}

