/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.object.advisers;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Set;
import org.openrdf.query.BindingSet;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.object.advice.Advice;
import org.openrdf.repository.object.advisers.helpers.PropertySet;
import org.openrdf.repository.object.traits.Mergeable;
import org.openrdf.repository.object.traits.ObjectMessage;
import org.openrdf.repository.object.traits.PropertyConsumer;
import org.openrdf.repository.object.traits.Refreshable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FieldBehaviour
implements Advice,
Mergeable,
Refreshable,
PropertyConsumer {
    private final Logger logger = LoggerFactory.getLogger(FieldBehaviour.class);
    private final Class<?> concept;
    private final Class<?> type;
    private final Field field;
    private final PropertySet property;
    private final Object proxy;
    private volatile boolean populated;

    public FieldBehaviour(PropertySet property, Field field, Object proxy) {
        assert (field != null);
        assert (property != null);
        assert (proxy != null);
        this.concept = field.getDeclaringClass();
        this.type = field.getType();
        this.field = field;
        this.property = property;
        this.proxy = proxy;
        try {
            field.setAccessible(true);
        }
        catch (SecurityException e) {
            this.logger.warn(e.toString(), (Throwable)e);
        }
    }

    public String toString() {
        return this.field.toString();
    }

    @Override
    public void usePropertyBindings(String binding, List<BindingSet> results) {
        if (this.property instanceof PropertyConsumer) {
            String var = binding + "_" + this.field.getName();
            if (results.get(0).getBindingNames().contains(var)) {
                PropertyConsumer pc = (PropertyConsumer)((Object)this.property);
                pc.usePropertyBindings(var, results);
            }
        }
    }

    @Override
    public void refresh() {
        this.property.refresh();
    }

    @Override
    public void merge(Object source) throws RepositoryException {
        if (this.concept.isAssignableFrom(source.getClass())) {
            try {
                Object value = this.field.get(source);
                if (value != null) {
                    if (Set.class.equals(this.type)) {
                        this.property.addAll((Set)value);
                    } else {
                        this.property.add(value);
                    }
                }
            }
            catch (IllegalArgumentException e) {
                throw new AssertionError((Object)e);
            }
            catch (IllegalAccessException e) {
                IllegalAccessError error = new IllegalAccessError(e.getMessage());
                error.initCause(e);
                throw error;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object intercept(ObjectMessage message) throws Exception {
        if (this.populated) {
            return message.proceed();
        }
        Object fieldValue = this.getFieldValue();
        try {
            this.populateFields(fieldValue);
        }
        catch (IllegalAccessException e) {
            throw this.error(e);
        }
        try {
            this.populated = true;
            Object object = message.proceed();
            return object;
        }
        finally {
            this.populated = false;
            try {
                this.storeFields(fieldValue);
            }
            catch (IllegalAccessException e) {
                throw this.error(e);
            }
        }
    }

    private IllegalAccessError error(IllegalAccessException e) {
        IllegalAccessError error = new IllegalAccessError(e.getMessage());
        error.initCause(e);
        return error;
    }

    private void populateFields(Object fieldValue) throws IllegalAccessException {
        if (this.concept.isAssignableFrom(this.proxy.getClass())) {
            if (fieldValue != null && String.class.equals(this.type)) {
                this.field.set(this.proxy, fieldValue.toString());
            } else {
                this.field.set(this.proxy, fieldValue);
            }
        }
        for (Field f : this.proxy.getClass().getDeclaredFields()) {
            Object behaviour;
            if (!this.concept.isAssignableFrom(f.getType()) || (behaviour = f.get(this.proxy)) == null) continue;
            if (fieldValue != null && String.class.equals(this.type)) {
                this.field.set(behaviour, fieldValue.toString());
                continue;
            }
            this.field.set(behaviour, fieldValue);
        }
    }

    private void storeFields(Object populated) throws IllegalAccessException {
        Object get;
        if (this.concept.isAssignableFrom(this.proxy.getClass()) && (get = this.field.get(this.proxy)) != populated) {
            this.setFieldValue(get);
        }
        for (Field f : this.proxy.getClass().getDeclaredFields()) {
            Object get2;
            Object behaviour;
            if (!this.concept.isAssignableFrom(f.getType()) || (behaviour = f.get(this.proxy)) == null || (get2 = this.field.get(behaviour)) == populated) continue;
            this.setFieldValue(get2);
        }
    }

    private Object getFieldValue() {
        if (Set.class.equals(this.type)) {
            return this.property.getAll();
        }
        Object single = this.property.getSingle();
        if (single == null) {
            return this.nil(this.type);
        }
        return single;
    }

    private void setFieldValue(Object get) {
        if (Set.class.equals(this.type)) {
            this.property.setAll((Set)get);
        }
        this.property.setSingle(get);
    }

    private Object nil(Class<?> type) {
        if (!type.isPrimitive()) {
            return null;
        }
        if (Void.TYPE.equals(type)) {
            return null;
        }
        if (Boolean.TYPE.equals(type)) {
            return Boolean.FALSE;
        }
        if (Character.TYPE.equals(type)) {
            return Character.valueOf('\u0000');
        }
        if (Byte.TYPE.equals(type)) {
            return (byte)0;
        }
        if (Short.TYPE.equals(type)) {
            return (short)0;
        }
        if (Integer.TYPE.equals(type)) {
            return 0;
        }
        if (Long.TYPE.equals(type)) {
            return 0L;
        }
        if (Float.TYPE.equals(type)) {
            return Float.valueOf(0.0f);
        }
        if (Double.TYPE.equals(type)) {
            return 0.0;
        }
        throw new AssertionError();
    }
}

