/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.object.advisers;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.List;
import java.util.Set;
import org.openrdf.query.BindingSet;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.object.advice.Advice;
import org.openrdf.repository.object.advisers.helpers.PropertySet;
import org.openrdf.repository.object.traits.Mergeable;
import org.openrdf.repository.object.traits.ObjectMessage;
import org.openrdf.repository.object.traits.PropertyConsumer;
import org.openrdf.repository.object.traits.Refreshable;

public final class PropertyBehaviour
implements Advice,
Mergeable,
Refreshable,
PropertyConsumer {
    private final Class<?> concept;
    private final Class<?> type;
    private final PropertyDescriptor pd;
    private final PropertySet property;

    public PropertyBehaviour(PropertySet property, PropertyDescriptor pd) {
        assert (pd != null);
        assert (property != null);
        this.concept = pd.getReadMethod().getDeclaringClass();
        this.type = pd.getReadMethod().getReturnType();
        this.pd = pd;
        this.property = property;
    }

    public String toString() {
        return this.pd.toString();
    }

    @Override
    public void usePropertyBindings(String binding, List<BindingSet> results) {
        if (this.property instanceof PropertyConsumer) {
            String var = binding + "_" + this.pd.getName();
            if (results.get(0).getBindingNames().contains(var)) {
                PropertyConsumer pc = (PropertyConsumer)((Object)this.property);
                pc.usePropertyBindings(var, results);
            }
        }
    }

    @Override
    public void refresh() {
        this.property.refresh();
    }

    @Override
    public void merge(Object source) throws RepositoryException {
        if (this.concept.isAssignableFrom(source.getClass())) {
            try {
                Object value = this.pd.getReadMethod().invoke(source, new Object[0]);
                if (value != null) {
                    if (Set.class.equals(this.type)) {
                        this.property.addAll((Set)value);
                    } else {
                        this.property.add(value);
                    }
                }
            }
            catch (IllegalArgumentException e) {
                throw new AssertionError((Object)e);
            }
            catch (IllegalAccessException e) {
                IllegalAccessError error = new IllegalAccessError(e.getMessage());
                error.initCause(e);
                throw error;
            }
            catch (InvocationTargetException e) {
                try {
                    throw e.getCause();
                }
                catch (Error error) {
                    throw error;
                }
                catch (RuntimeException runtime) {
                    throw runtime;
                }
                catch (RepositoryException repository) {
                    throw repository;
                }
                catch (Throwable throwable) {
                    throw new UndeclaredThrowableException(throwable);
                }
            }
        }
    }

    public Object intercept(ObjectMessage message) throws Exception {
        Class<?> type = message.getMethod().getReturnType();
        if (Void.TYPE.equals(type)) {
            if (Set.class.equals(message.getMethod().getParameterTypes()[0])) {
                this.property.setAll((Set)message.getParameters()[0]);
            } else {
                this.property.setSingle(message.getParameters()[0]);
            }
            return message.proceed();
        }
        if (Set.class.equals(type)) {
            return this.property.getAll();
        }
        if (type.isPrimitive()) {
            Object result = this.property.getSingle();
            if (result == null) {
                return message.proceed();
            }
            return result;
        }
        if (String.class.equals(type)) {
            Object result = this.property.getSingle();
            if (result == null) {
                return message.proceed();
            }
            return result.toString();
        }
        try {
            Object result = type.cast(this.property.getSingle());
            if (result == null) {
                return message.proceed();
            }
            return result;
        }
        catch (ClassCastException e) {
            throw new ClassCastException(this.property.getSingle() + " cannot be cast to " + type.getName());
        }
    }
}

