/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.object.advisers;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javassist.NotFoundException;
import org.openrdf.repository.object.advice.Advice;
import org.openrdf.repository.object.advisers.FieldBehaviour;
import org.openrdf.repository.object.advisers.PropertyBehaviour;
import org.openrdf.repository.object.advisers.base.AbstractBehaviourFactory;
import org.openrdf.repository.object.advisers.helpers.PropertySetFactory;
import org.openrdf.repository.object.composition.BehaviourFactory;
import org.openrdf.repository.object.composition.BehaviourProvider;
import org.openrdf.repository.object.composition.ClassFactory;
import org.openrdf.repository.object.composition.ClassTemplate;
import org.openrdf.repository.object.exceptions.ObjectCompositionException;
import org.openrdf.repository.object.managers.PropertyMapper;
import org.openrdf.repository.object.traits.ObjectMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyMapperProvider
implements BehaviourProvider {
    private static final Method intercept;
    private final Logger logger = LoggerFactory.getLogger(PropertyMapperProvider.class);
    private ClassFactory cp;
    private PropertyMapper properties;

    public void setClassDefiner(ClassFactory definer) {
        this.cp = definer;
    }

    public void setBaseClasses(Set<Class<?>> bases) {
    }

    public void setPropertyMapper(PropertyMapper mapper) {
        this.properties = mapper;
    }

    public Collection<? extends BehaviourFactory> getBehaviourFactories(Collection<Class<?>> classes) throws ObjectCompositionException {
        Set<Class<?>> faces = new HashSet();
        for (Class<?> i : classes) {
            faces.add(i);
            faces = this.getSuperClasses(i, faces);
        }
        ArrayList<? extends BehaviourFactory> result = new ArrayList<BehaviourFactory>(faces.size());
        for (Class clazz : faces) {
            result.addAll(this.getBehaviourFactories(clazz));
        }
        return result;
    }

    private Set<Class<?>> getSuperClasses(Class<?> role, Set<Class<?>> set) {
        for (Class<?> face : role.getInterfaces()) {
            if (set.contains(face)) continue;
            set.add(face);
            this.getSuperClasses(face, set);
        }
        Class<?> superclass = role.getSuperclass();
        if (superclass != null) {
            set.add(superclass);
            this.getSuperClasses(superclass, set);
        }
        return set;
    }

    private Collection<? extends BehaviourFactory> getBehaviourFactories(Class<?> concept) {
        ArrayList<BehaviourFactory> result = new ArrayList<BehaviourFactory>();
        for (Field field : this.findAllFields(concept, new ArrayList<Field>())) {
            result.add(this.createFieldAdviser(concept, field));
        }
        for (PropertyDescriptor pd : this.properties.findProperties(concept)) {
            result.add(this.createPropertyAdviser(pd));
        }
        return result;
    }

    private Collection<Field> findAllFields(Class<?> concept, Collection<Field> fields) {
        fields.addAll(this.properties.findFields(concept));
        Class<?> superclass = concept.getSuperclass();
        if (superclass != null) {
            this.findAllFields(superclass, fields);
        }
        return fields;
    }

    private BehaviourFactory createFieldAdviser(final Class<?> role, final Field field) {
        final PropertySetFactory factory = new PropertySetFactory(field, this.properties.findPredicate(field));
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Method method : role.getDeclaredMethods()) {
            ClassTemplate t = this.cp.loadClassTemplate(role);
            try {
                Set<Field> fieldsRead = this.getMappedFieldsRead(t, method);
                Set<Field> fieldsWriten = this.getMappedFieldsWritten(t, method);
                if (!fieldsRead.contains(field) && !fieldsWriten.contains(field)) continue;
                methods.add(method);
            }
            catch (NotFoundException e) {
                this.logger.warn(e.toString(), (Throwable)e);
            }
        }
        Class[] interfaces = PropertyBehaviour.class.getInterfaces();
        final Method[] ar = methods.toArray(new Method[methods.size()]);
        return new AbstractBehaviourFactory(FieldBehaviour.class, interfaces, intercept, ar){

            public boolean precedes(Method in, BehaviourFactory factory2, Method to) {
                for (Method m : ar) {
                    if (!m.getName().equals(to.getName()) || !Arrays.equals(m.getParameterTypes(), to.getParameterTypes())) continue;
                    return role.isAssignableFrom(factory2.getBehaviourType());
                }
                return false;
            }

            public FieldBehaviour newInstance(Object proxy) throws Throwable {
                return new FieldBehaviour(factory.createPropertySet(proxy), field, proxy);
            }

            @Override
            public String getName() {
                return field.getName();
            }
        };
    }

    private Set<Field> getMappedFieldsRead(ClassTemplate t, Method method) throws NotFoundException {
        Set fields = t.getFieldsRead(method);
        Iterator iter = fields.iterator();
        while (iter.hasNext()) {
            Field field = (Field)iter.next();
            if (this.properties.isMappedField(field)) continue;
            iter.remove();
        }
        return fields;
    }

    private Set<Field> getMappedFieldsWritten(ClassTemplate t, Method method) throws NotFoundException {
        Set fields = t.getFieldsWritten(method);
        Iterator iter = fields.iterator();
        while (iter.hasNext()) {
            Field field = (Field)iter.next();
            if (this.properties.isMappedField(field)) continue;
            iter.remove();
        }
        return fields;
    }

    private BehaviourFactory createPropertyAdviser(final PropertyDescriptor pd) {
        final PropertySetFactory factory = new PropertySetFactory(pd, this.properties.findPredicate(pd));
        ArrayList<Method> two = new ArrayList<Method>();
        if (pd.getReadMethod() != null) {
            two.add(pd.getReadMethod());
        }
        if (pd.getWriteMethod() != null) {
            two.add(pd.getWriteMethod());
        }
        Class[] interfaces = PropertyBehaviour.class.getInterfaces();
        Method[] methods = two.toArray(new Method[two.size()]);
        return new AbstractBehaviourFactory(PropertyBehaviour.class, interfaces, intercept, methods){

            public boolean precedes(Method in, BehaviourFactory factory2, Method to) {
                Method r = pd.getReadMethod();
                if (r.getName().equals(to.getName())) {
                    return Arrays.equals(r.getParameterTypes(), to.getParameterTypes());
                }
                Method w = pd.getWriteMethod();
                if (w == null || !w.getName().equals(to.getName())) {
                    return false;
                }
                return Arrays.equals(w.getParameterTypes(), to.getParameterTypes());
            }

            public PropertyBehaviour newInstance(Object proxy) throws Throwable {
                return new PropertyBehaviour(factory.createPropertySet(proxy), pd);
            }

            @Override
            public String getName() {
                return pd.getName();
            }
        };
    }

    static {
        try {
            intercept = Advice.class.getMethod("intercept", ObjectMessage.class);
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
    }
}

