/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.object.advisers;

import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.nio.channels.ReadableByteChannel;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.TransformerException;
import org.openrdf.OpenRDFException;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Model;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.query.BindingSet;
import org.openrdf.query.GraphQueryResult;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.repository.object.ObjectConnection;
import org.openrdf.repository.object.RDFObject;
import org.openrdf.repository.object.advice.Advice;
import org.openrdf.repository.object.advisers.helpers.SparqlEvaluator;
import org.openrdf.repository.object.advisers.helpers.SparqlParameters;
import org.openrdf.repository.object.traits.ObjectMessage;
import org.openrdf.repository.object.traits.Refreshable;
import org.openrdf.result.Result;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class SparqlAdvice
implements Advice {
    private final SparqlEvaluator evaluator;
    private final Class<?> returnClass;
    private final Class<?> componentClass;
    private final Map<Method, SparqlParameters> map = new HashMap<Method, SparqlParameters>();

    public SparqlAdvice(SparqlEvaluator evaluator, Method m) {
        this.evaluator = evaluator;
        this.returnClass = m.getReturnType();
        Type rtype = m.getGenericReturnType();
        SparqlParameters parameters = new SparqlParameters(m);
        this.componentClass = parameters.getComponentClass(this.returnClass, rtype);
        this.map.put(m, parameters);
    }

    public String toString() {
        return this.evaluator.toString();
    }

    public Object intercept(ObjectMessage message) throws Exception {
        Object target = message.getTarget();
        ObjectConnection con = ((RDFObject)target).getObjectConnection();
        Resource self = ((RDFObject)target).getResource();
        SparqlEvaluator.SparqlBuilder with = this.evaluator.prepare(con).with("this", self);
        Object[] args = message.getParameters();
        this.getParameters(message.getMethod()).populate(args, with, con);
        if (this.isUpdate()) {
            with.asUpdate();
            if (target instanceof Refreshable) {
                ((Refreshable)target).refresh();
            }
            return message.proceed();
        }
        Object result = this.cast(with, this.returnClass, this.componentClass);
        if (result == null) {
            return message.proceed();
        }
        if (this.returnClass.isPrimitive() && result.equals(this.nil(this.returnClass))) {
            return message.proceed();
        }
        return result;
    }

    private synchronized SparqlParameters getParameters(Method m) {
        if (this.map.containsKey(m)) {
            return this.map.get(m);
        }
        SparqlParameters parameters = new SparqlParameters(m);
        this.map.put(m, parameters);
        return parameters;
    }

    private boolean isUpdate() {
        return Void.class.equals(this.returnClass) || Void.TYPE.equals(this.returnClass);
    }

    private Object cast(SparqlEvaluator.SparqlBuilder result, Class<?> rclass, Class<?> componentClass) throws OpenRDFException, TransformerException, IOException, ParserConfigurationException, SAXException, XMLStreamException {
        if (TupleQueryResult.class.equals(rclass)) {
            return result.asTupleQueryResult();
        }
        if (GraphQueryResult.class.equals(rclass)) {
            return result.asGraphQueryResult();
        }
        if (Result.class.equals(rclass)) {
            return result.asResult(componentClass);
        }
        if (Set.class.equals(rclass)) {
            return result.asSet(componentClass);
        }
        if (List.class.equals(rclass)) {
            return result.asList(componentClass);
        }
        if (byte[].class.equals(rclass)) {
            return result.asByteArray();
        }
        if (CharSequence.class.equals(rclass)) {
            return result.asCharSequence();
        }
        if (Readable.class.equals(rclass)) {
            return result.asReadable();
        }
        if (String.class.equals(rclass)) {
            return result.asString();
        }
        if (Void.class.equals(rclass) || Void.TYPE.equals(rclass)) {
            result.asUpdate();
            return null;
        }
        if (Boolean.class.equals(rclass) || Boolean.TYPE.equals(rclass)) {
            return result.asBoolean();
        }
        if (Byte.class.equals(rclass) || Byte.TYPE.equals(rclass)) {
            return result.asByte();
        }
        if (Character.class.equals(rclass) || Character.TYPE.equals(rclass)) {
            return Character.valueOf(result.asChar());
        }
        if (Double.class.equals(rclass) || Double.TYPE.equals(rclass)) {
            return result.asDouble();
        }
        if (Float.class.equals(rclass) || Float.TYPE.equals(rclass)) {
            return Float.valueOf(result.asFloat());
        }
        if (Integer.class.equals(rclass) || Integer.TYPE.equals(rclass)) {
            return result.asInt();
        }
        if (Long.class.equals(rclass) || Long.TYPE.equals(rclass)) {
            return result.asLong();
        }
        if (Short.class.equals(rclass) || Short.TYPE.equals(rclass)) {
            return result.asShort();
        }
        if (Model.class.equals(rclass)) {
            return result.asModel();
        }
        if (Statement.class.equals(rclass)) {
            return result.asStatement();
        }
        if (BindingSet.class.equals(rclass)) {
            return result.asBindingSet();
        }
        if (URI.class.equals(rclass)) {
            return result.asURI();
        }
        if (BNode.class.equals(rclass)) {
            return result.asBNode();
        }
        if (Literal.class.equals(rclass)) {
            return result.asLiteral();
        }
        if (Resource.class.equals(rclass)) {
            return result.asResource();
        }
        if (Value.class.equals(rclass)) {
            return result.asValue();
        }
        if (Document.class.equals(rclass)) {
            return result.asDocument();
        }
        if (DocumentFragment.class.equals(rclass)) {
            return result.asDocumentFragment();
        }
        if (Element.class.equals(rclass)) {
            return result.asElement();
        }
        if (Node.class.equals(rclass)) {
            return result.asNode();
        }
        if (Reader.class.equals(rclass)) {
            return result.asReader();
        }
        if (CharArrayWriter.class.equals(rclass)) {
            return result.asCharArrayWriter();
        }
        if (ByteArrayOutputStream.class.equals(rclass)) {
            return result.asByteArrayOutputStream();
        }
        if (ReadableByteChannel.class.equals(rclass)) {
            return result.asReadableByteChannel();
        }
        if (InputStream.class.equals(rclass)) {
            return result.asInputStream();
        }
        if (XMLEventReader.class.equals(rclass)) {
            return result.asXMLEventReader();
        }
        return result.as(rclass);
    }

    private Object nil(Class<?> type) {
        if (Set.class.equals(type)) {
            return Collections.emptySet();
        }
        if (!type.isPrimitive()) {
            return null;
        }
        if (Void.TYPE.equals(type)) {
            return null;
        }
        if (Boolean.TYPE.equals(type)) {
            return Boolean.FALSE;
        }
        if (Character.TYPE.equals(type)) {
            return Character.valueOf('\u0000');
        }
        if (Byte.TYPE.equals(type)) {
            return (byte)0;
        }
        if (Short.TYPE.equals(type)) {
            return (short)0;
        }
        if (Integer.TYPE.equals(type)) {
            return 0;
        }
        if (Long.TYPE.equals(type)) {
            return 0L;
        }
        if (Float.TYPE.equals(type)) {
            return Float.valueOf(0.0f);
        }
        if (Double.TYPE.equals(type)) {
            return 0.0;
        }
        throw new AssertionError();
    }
}

