/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.object.advisers;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.util.regex.Pattern;
import org.openrdf.annotations.Iri;
import org.openrdf.annotations.Sparql;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.repository.object.advice.Advice;
import org.openrdf.repository.object.advice.AdviceFactory;
import org.openrdf.repository.object.advice.AdviceProvider;
import org.openrdf.repository.object.advisers.SparqlAdvice;
import org.openrdf.repository.object.advisers.SparqlQuery;
import org.openrdf.repository.object.advisers.SparqlQueryResolver;
import org.openrdf.repository.object.advisers.helpers.SparqlEvaluator;

public class SparqlAdviceFactory
implements AdviceFactory,
AdviceProvider {
    private static final Pattern NOT_URI = Pattern.compile("\\s|\\}|\\]|\\>|\"");
    private SparqlQueryResolver resolver = SparqlQueryResolver.getInstance();

    public AdviceFactory getAdviserFactory(Class<?> annotationType) {
        if (Sparql.class.equals(annotationType)) {
            return this;
        }
        return null;
    }

    public Advice createAdvice(Method m) {
        SparqlEvaluator evaluator = this.createSparqlEvaluator(m);
        return new SparqlAdvice(evaluator, m);
    }

    private SparqlEvaluator createSparqlEvaluator(Method m) {
        String systemId = this.getSystemId(m);
        String sparql = this.getSparqlQuery(m);
        try {
            if (NOT_URI.matcher(sparql).find()) {
                return this.create(new StringReader(sparql), systemId);
            }
            if (URI.create(sparql).isAbsolute()) {
                return this.create(sparql);
            }
            URL url = m.getDeclaringClass().getResource(sparql);
            if (url != null) {
                return this.create(url.toExternalForm());
            }
            String uri = URI.create(systemId).resolve(sparql).toASCIIString();
            return this.create(uri);
        }
        catch (IOException e) {
            throw new ExceptionInInitializerError(e);
        }
        catch (MalformedQueryException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SparqlEvaluator create(Reader reader, String systemId) throws MalformedQueryException, IOException {
        try {
            SparqlQuery query = new SparqlQuery(reader, systemId);
            SparqlEvaluator sparqlEvaluator = new SparqlEvaluator(query);
            return sparqlEvaluator;
        }
        finally {
            reader.close();
        }
    }

    private SparqlEvaluator create(String systemId) throws MalformedQueryException, IOException {
        return new SparqlEvaluator(this.resolver.resolve(systemId));
    }

    private String getSparqlQuery(Method m) {
        return m.getAnnotation(Sparql.class).value();
    }

    private String getSystemId(Method m) {
        if (m.isAnnotationPresent(Iri.class)) {
            return m.getAnnotation(Iri.class).value();
        }
        Class<?> dclass = m.getDeclaringClass();
        String mame = m.getName();
        if (dclass.isAnnotationPresent(Iri.class)) {
            String url = dclass.getAnnotation(Iri.class).value();
            if (url.indexOf(35) >= 0) {
                return url.substring(0, url.indexOf(35) + 1) + mame;
            }
            return url + "#" + mame;
        }
        String name = dclass.getSimpleName() + ".class";
        URL url = dclass.getResource(name);
        if (url != null) {
            return url.toExternalForm() + "#" + mame;
        }
        return "java:" + dclass.getName() + "#" + mame;
    }
}

