/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.object.advisers;

import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.parser.ParsedBooleanQuery;
import org.openrdf.query.parser.ParsedGraphQuery;
import org.openrdf.query.parser.ParsedOperation;
import org.openrdf.query.parser.ParsedTupleQuery;
import org.openrdf.query.parser.sparql.SPARQLParser;
import org.openrdf.repository.object.advisers.helpers.SparqlEvaluator;
import org.openrdf.repository.object.managers.PropertyMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparqlQuery {
    private static final Pattern selectWhere = Pattern.compile("\\sSELECT\\s+([\\?\\$]\\w+)(\\s+WHERE)?\\s*\\{", 34);
    private static final Pattern limitOffset = Pattern.compile("\\bLIMIT\\b|\\bOFFSET\\b", 2);
    private final Logger logger = LoggerFactory.getLogger(SparqlQuery.class);
    private String sparql;
    private String base;
    private Class<?> concept;
    private String object;
    private ParsedOperation query;

    public SparqlQuery(Reader in, String base) throws IOException, MalformedQueryException {
        try {
            int read;
            StringWriter sw = new StringWriter();
            char[] cbuf = new char[1024];
            while ((read = in.read(cbuf)) >= 0) {
                sw.write(cbuf, 0, read);
            }
            this.sparql = sw.toString();
            this.base = base;
            try {
                this.query = new SPARQLParser().parseQuery(this.sparql, base);
            }
            catch (MalformedQueryException e) {
                try {
                    this.query = new SPARQLParser().parseUpdate(this.sparql, base);
                }
                catch (MalformedQueryException u) {
                    throw e;
                }
            }
        }
        catch (MalformedQueryException e) {
            this.logger.warn(base + " " + e.getMessage(), (Throwable)e);
        }
    }

    public String getBaseURI() {
        return this.base;
    }

    public boolean isBooleanQuery() {
        return this.query instanceof ParsedBooleanQuery;
    }

    public boolean isGraphQuery() {
        return this.query instanceof ParsedGraphQuery;
    }

    public boolean isTupleQuery() {
        return this.query instanceof ParsedTupleQuery;
    }

    public synchronized String toObjectString(Class<?> concept) {
        if (concept.equals(this.concept)) {
            return this.object;
        }
        if (this.isTupleQuery()) {
            this.concept = concept;
            ClassLoader cl = concept.getClassLoader();
            if (cl == null) {
                cl = SparqlEvaluator.class.getClassLoader();
            }
            PropertyMapper pm = new PropertyMapper(cl, true);
            Map eager = pm.findEagerProperties(concept);
            this.object = this.optimizeQueryString(this.sparql, eager);
        } else {
            this.concept = concept;
            this.object = this.sparql;
        }
        return this.object;
    }

    public String toString() {
        return this.sparql;
    }

    private String optimizeQueryString(String sparql, Map<String, String> map) {
        Matcher matcher = selectWhere.matcher(sparql);
        if (map != null && matcher.find() && !limitOffset.matcher(sparql).find()) {
            String var = matcher.group(1);
            int idx = sparql.lastIndexOf(125);
            StringBuilder sb = new StringBuilder(256 + sparql.length());
            sb.append(sparql, 0, matcher.start(1));
            sb.append(var).append(" ");
            sb.append(var).append("_class").append(" ");
            for (Map.Entry<String, String> e : map.entrySet()) {
                String name = e.getKey();
                if (name.equals("class")) continue;
                sb.append(var).append("_").append(name).append(" ");
            }
            sb.append(sparql, matcher.end(1), idx);
            sb.append(" OPTIONAL { ").append(var);
            sb.append(" a ").append(var).append("_class}");
            for (Map.Entry<String, String> e : map.entrySet()) {
                String pred = e.getValue();
                String name = e.getKey();
                if (name.equals("class")) continue;
                sb.append(" OPTIONAL { ").append(var).append(" <");
                sb.append(pred).append("> ");
                sb.append(var).append("_").append(name).append("}");
            }
            sb.append(sparql, idx, sparql.length());
            return sb.toString();
        }
        return sparql;
    }
}

