/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.object.advisers.base;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openrdf.annotations.ParameterTypes;
import org.openrdf.repository.object.composition.BehaviourFactory;

public abstract class AbstractBehaviourFactory
implements BehaviourFactory {
    private final Class<?> behaviourType;
    private final Class<?>[] interfaces;
    private final Method intercept;
    private final Map<String, List<Method>> intercepting = new HashMap<String, List<Method>>();

    public AbstractBehaviourFactory(Class<?> behaviourType, Class<?>[] interfaces, Method intercept, Method[] intercepting) {
        assert (behaviourType != null);
        assert (interfaces != null);
        assert (intercept != null);
        assert (intercepting != null);
        this.behaviourType = behaviourType;
        this.interfaces = interfaces;
        this.intercept = intercept;
        for (Method m : intercepting) {
            List<Method> list = this.intercepting.get(m.getName());
            if (list == null) {
                list = new ArrayList<Method>();
                this.intercepting.put(m.getName(), list);
            }
            list.add(m);
        }
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        return this.getBehaviourType().getSimpleName();
    }

    public Class<?> getBehaviourType() {
        return this.behaviourType;
    }

    public Class<?>[] getInterfaces() {
        return this.interfaces;
    }

    public Method[] getMethods() {
        ArrayList<Method> list = new ArrayList<Method>();
        for (Class<?> face : this.interfaces) {
            for (Method m : face.getMethods()) {
                if (m.equals(this.intercept)) continue;
                list.add(m);
            }
        }
        for (List list2 : this.intercepting.values()) {
            for (Method m : list2) {
                list.add(m);
            }
        }
        return list.toArray(new Method[list.size()]);
    }

    public synchronized Method getInvocation(Method method) {
        if (method.getDeclaringClass().isAssignableFrom(this.behaviourType)) {
            return method;
        }
        if (this.intercepting.containsKey(method.getName())) {
            Object[] ptypes = method.getParameterTypes();
            for (Method m : this.intercepting.get(method.getName())) {
                if (!Arrays.equals(ptypes, m.getParameterTypes())) continue;
                return this.intercept;
            }
            if (method.isAnnotationPresent(ParameterTypes.class)) {
                Object[] aptypes = method.getAnnotation(ParameterTypes.class).value();
                for (Method m : this.intercepting.get(method.getName())) {
                    if (!Arrays.equals(aptypes, m.getParameterTypes())) continue;
                    return this.intercept;
                }
            }
        }
        return null;
    }

    public boolean isSingleton() {
        return false;
    }

    public Object getSingleton() {
        return null;
    }
}

