/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.object.advisers.helpers;

import info.aduna.iteration.CloseableIteration;
import info.aduna.iteration.CloseableIteratorIteration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.openrdf.model.Resource;
import org.openrdf.model.Value;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.object.ObjectConnection;
import org.openrdf.repository.object.ObjectQuery;
import org.openrdf.repository.object.RDFObject;
import org.openrdf.repository.object.advisers.helpers.ObjectQueryFactory;
import org.openrdf.repository.object.advisers.helpers.PropertySetFactory;
import org.openrdf.repository.object.advisers.helpers.PropertySetModifier;
import org.openrdf.repository.object.advisers.helpers.RemotePropertySet;
import org.openrdf.repository.object.exceptions.ObjectPersistException;
import org.openrdf.repository.object.result.ObjectCursor;
import org.openrdf.repository.object.result.ObjectIterator;
import org.openrdf.repository.object.traits.ManagedRDFObject;
import org.openrdf.repository.object.traits.PropertyConsumer;
import org.openrdf.result.Result;

public class CachedPropertySet
extends RemotePropertySet
implements PropertyConsumer {
    private static final int CACHE_LIMIT = 10;
    List<Object> cache;
    boolean cached;
    private ObjectQueryFactory factory;
    private PropertySetFactory creator;
    private String binding;
    private List<BindingSet> bindings;
    private boolean merged;

    public CachedPropertySet(ManagedRDFObject bean, PropertySetModifier property) {
        super(bean, property);
        this.factory = bean.getObjectQueryFactory();
    }

    public void setPropertySetFactory(PropertySetFactory creator) {
        this.creator = creator;
    }

    @Override
    public synchronized void usePropertyBindings(String binding, List<BindingSet> bindings) {
        this.binding = binding;
        this.bindings = bindings;
    }

    @Override
    public synchronized void refresh() {
        super.refresh();
        this.cached = false;
        this.cache = null;
        this.binding = null;
        this.bindings = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        if (this.isCacheComplete() && !this.cache.isEmpty()) {
            ObjectConnection conn = this.getObjectConnection();
            try {
                boolean autoCommit = conn.isAutoCommit();
                if (autoCommit) {
                    conn.setAutoCommit(false);
                }
                try {
                    for (Object o : this.cache) {
                        this.remove(o);
                    }
                    if (autoCommit) {
                        conn.setAutoCommit(true);
                    }
                }
                finally {
                    if (autoCommit && !conn.isAutoCommit()) {
                        conn.rollback();
                        conn.setAutoCommit(true);
                    }
                }
            }
            catch (RepositoryException e) {
                throw new ObjectPersistException((Exception)((Object)e));
            }
            this.refreshCache();
        } else if (!this.cached || !this.cache.isEmpty()) {
            super.clear();
            this.refreshCache();
        }
        this.cache = Collections.EMPTY_LIST;
        this.cached = true;
    }

    @Override
    public void setSingle(Object o) {
        if (!this.cached || !this.cache.isEmpty()) {
            super.setSingle(o);
        } else if (o != null) {
            this.add(o);
        }
        if (!this.merged) {
            this.cache = o == null ? Collections.EMPTY_LIST : Collections.singletonList(o);
            this.cached = true;
        }
    }

    @Override
    public void setAll(Set<?> set) {
        if (!this.cached || !this.cache.isEmpty()) {
            super.setAll(set);
        } else if (!set.isEmpty()) {
            this.addAll((Collection<?>)set);
        }
        if (!this.merged) {
            this.cache = set == null ? Collections.EMPTY_LIST : new ArrayList(set);
            this.cached = true;
        }
    }

    @Override
    public boolean contains(Object o) {
        if (this.isCacheComplete()) {
            return this.cache.contains(o);
        }
        if (this.cached && this.cache.contains(o)) {
            return true;
        }
        return super.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        if (this.isCacheComplete()) {
            return this.cache.containsAll(c);
        }
        if (this.cached && this.cache.containsAll(c)) {
            return true;
        }
        return super.containsAll(c);
    }

    @Override
    public Object getSingle() {
        if (this.cached && this.cache.isEmpty()) {
            return null;
        }
        if (this.cached) {
            return this.cache.get(0);
        }
        return super.getSingle();
    }

    @Override
    public boolean isEmpty() {
        if (this.cached) {
            return this.cache.isEmpty();
        }
        return super.isEmpty();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        this.refreshCache();
        return super.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        this.refreshCache();
        return super.retainAll(c);
    }

    @Override
    public int size() {
        if (this.isCacheComplete()) {
            return this.cache.size();
        }
        return super.size();
    }

    @Override
    public Iterator<Object> iterator() {
        if (this.isCacheComplete()) {
            final Iterator<Object> iter = this.cache.iterator();
            return new Iterator<Object>(){
                private Object e;

                @Override
                public boolean hasNext() {
                    return iter.hasNext();
                }

                @Override
                public Object next() {
                    this.e = iter.next();
                    return this.e;
                }

                @Override
                public void remove() {
                    CachedPropertySet.this.remove(this.e);
                }
            };
        }
        return super.iterator();
    }

    @Override
    public Object[] toArray() {
        if (this.isCacheComplete()) {
            return this.cache.toArray();
        }
        return super.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (this.isCacheComplete()) {
            return this.cache.toArray(a);
        }
        return super.toArray(a);
    }

    protected void refreshCache() {
        if (this.cached) {
            for (Object e : this.cache) {
                this.refresh(e);
            }
        }
    }

    private boolean isCacheComplete() {
        return this.cached && this.cache.size() < 10;
    }

    @Override
    protected Value getValue(Object instance) throws RepositoryException {
        Value value = super.getValue(instance);
        if (!this.merged && value instanceof Resource && !this.isManaged(instance)) {
            this.merged = true;
        }
        return value;
    }

    private boolean isManaged(Object instance) {
        return instance instanceof RDFObject && ((RDFObject)instance).getObjectConnection() == this.getObjectConnection();
    }

    @Override
    protected synchronized CloseableIteration<?, ?> getObjects() throws RepositoryException, QueryEvaluationException {
        if (this.creator == null || this.factory == null) {
            return super.getObjects();
        }
        if (this.binding == null) {
            ObjectQuery query = this.factory.createQuery(this.creator);
            if (query == null) {
                return super.getObjects();
            }
            try {
                query.setBinding("self", (Value)this.getResource());
                Result<?> result = query.evaluate(this.creator.getPropertyType());
                return result;
            }
            finally {
                this.factory.returnQuery(this.creator, query);
            }
        }
        CloseableIteratorIteration result = new CloseableIteratorIteration(this.bindings.iterator());
        return new ObjectCursor(this.getObjectConnection(), (CloseableIteration<BindingSet, QueryEvaluationException>)result, this.binding);
    }

    @Override
    protected ObjectIterator<?, Object> getObjectIterator() {
        try {
            return new ObjectIterator<Object, Object>(this.getObjects()){
                private List<Object> list;
                {
                    this.list = new ArrayList<Object>(10);
                }

                @Override
                protected Object convert(Object instance) throws RepositoryException {
                    if (this.list != null && this.list.size() < 10) {
                        this.list.add(instance);
                    }
                    return instance;
                }

                @Override
                protected void remove(Object instance) {
                    this.list = null;
                    CachedPropertySet.this.remove(instance);
                }

                @Override
                public void close() {
                    try {
                        if (!(this.list == null || this.hasNext() && this.list.size() != 10)) {
                            CachedPropertySet.this.cache = this.list;
                            CachedPropertySet.this.cached = true;
                        }
                    }
                    finally {
                        super.close();
                    }
                }
            };
        }
        catch (RepositoryException e) {
            throw new ObjectPersistException((Exception)((Object)e));
        }
        catch (QueryEvaluationException e) {
            throw new ObjectPersistException((Exception)((Object)e));
        }
    }
}

