/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.object.advisers.helpers;

import java.util.HashMap;
import java.util.Map;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.object.ObjectConnection;
import org.openrdf.repository.object.ObjectQuery;
import org.openrdf.repository.object.advisers.helpers.PropertySetFactory;
import org.openrdf.repository.object.managers.PropertyMapper;

public class ObjectQueryFactory {
    private PropertyMapper mapper;
    private ObjectConnection connection;
    private Map<PropertySetFactory, ObjectQuery> queries = new HashMap<PropertySetFactory, ObjectQuery>();

    public ObjectQueryFactory(ObjectConnection connection, PropertyMapper mapper) {
        this.connection = connection;
        this.mapper = mapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectQuery createQuery(PropertySetFactory factory) throws RepositoryException {
        Map<PropertySetFactory, ObjectQuery> map = this.queries;
        synchronized (map) {
            ObjectQuery query = this.queries.remove(factory);
            if (query != null) {
                return query;
            }
        }
        Class<?> type = factory.getPropertyType();
        Map properties = this.mapper.findEagerProperties(type);
        if (properties == null) {
            return null;
        }
        String sparql = this.buildQuery(properties, factory);
        try {
            TupleQuery tuples = this.connection.prepareTupleQuery(QueryLanguage.SPARQL, sparql);
            return new ObjectQuery(this.connection, tuples);
        }
        catch (MalformedQueryException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnQuery(PropertySetFactory factory, ObjectQuery query) {
        Map<PropertySetFactory, ObjectQuery> map = this.queries;
        synchronized (map) {
            this.queries.put(factory, query);
        }
    }

    private String buildQuery(Map<String, String> properties, PropertySetFactory factory) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT ?obj ");
        for (String name : properties.keySet()) {
            sb.append(" ?obj_").append(name);
        }
        sb.append("\nWHERE { ");
        String uri = factory.getPredicate().stringValue();
        sb.append(" $self <").append(uri).append("> ?obj ");
        for (String name : properties.keySet()) {
            String pred = properties.get(name);
            sb.append("\nOPTIONAL {").append(" ?obj <");
            sb.append(pred);
            sb.append("> ?obj_").append(name).append(" } ");
        }
        sb.append(" } ");
        return sb.toString();
    }
}

