/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.object.advisers.helpers;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Set;
import org.openrdf.annotations.Iri;
import org.openrdf.model.URI;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.repository.object.advisers.helpers.CachedPropertySet;
import org.openrdf.repository.object.advisers.helpers.PropertySet;
import org.openrdf.repository.object.advisers.helpers.PropertySetModifier;
import org.openrdf.repository.object.advisers.helpers.UnmodifiableProperty;
import org.openrdf.repository.object.traits.ManagedRDFObject;

public class PropertySetFactory {
    private static ValueFactory vf = ValueFactoryImpl.getInstance();
    private String name;
    private Class<?> type;
    private URI predicate;
    private boolean readOnly;
    private PropertySetModifier modifier;

    public PropertySetFactory(Field field, String predicate) {
        ParameterizedType pt;
        Type[] args;
        Type t;
        Iri rdf = field.getAnnotation(Iri.class);
        if (predicate != null) {
            this.setPredicate(predicate);
        } else if (rdf != null && rdf.value() != null) {
            this.setPredicate(rdf.value());
        }
        assert (this.predicate != null);
        this.name = field.getName();
        this.type = field.getType();
        if (Set.class.equals(this.type) && (t = field.getGenericType()) instanceof ParameterizedType && (args = (pt = (ParameterizedType)t).getActualTypeArguments()).length == 1 && args[0] instanceof Class) {
            this.type = (Class)args[0];
        }
    }

    public PropertySetFactory(PropertyDescriptor property, String predicate) {
        ParameterizedType pt;
        Type[] args;
        Type t;
        Method getter = property.getReadMethod();
        this.readOnly = property.getWriteMethod() == null;
        Iri rdf = getter.getAnnotation(Iri.class);
        if (predicate != null) {
            this.setPredicate(predicate);
        } else if (rdf != null && rdf.value() != null) {
            this.setPredicate(rdf.value());
        }
        assert (this.predicate != null);
        this.name = property.getName();
        this.type = property.getPropertyType();
        if (Set.class.equals(this.type) && (t = property.getReadMethod().getGenericReturnType()) instanceof ParameterizedType && (args = (pt = (ParameterizedType)t).getActualTypeArguments()).length == 1 && args[0] instanceof Class) {
            this.type = (Class)args[0];
        }
    }

    public String getName() {
        return this.name;
    }

    public Class<?> getPropertyType() {
        return this.type;
    }

    public URI getPredicate() {
        return this.predicate;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public PropertySet createPropertySet(Object bean) {
        CachedPropertySet property = this.createCachedPropertySet((ManagedRDFObject)bean);
        property.setPropertySetFactory(this);
        if (this.readOnly) {
            return new UnmodifiableProperty(property);
        }
        return property;
    }

    private CachedPropertySet createCachedPropertySet(ManagedRDFObject bean) {
        return new CachedPropertySet(bean, this.modifier);
    }

    private void setPredicate(String uri) {
        this.predicate = vf.createURI(uri);
        this.modifier = new PropertySetModifier(this.predicate);
    }
}

