/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.object.advisers.helpers;

import info.aduna.iteration.CloseableIteration;
import info.aduna.iteration.ConvertingIteration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.RepositoryResult;
import org.openrdf.repository.object.ObjectConnection;
import org.openrdf.repository.object.advisers.helpers.PropertySet;
import org.openrdf.repository.object.advisers.helpers.PropertySetModifier;
import org.openrdf.repository.object.exceptions.ObjectPersistException;
import org.openrdf.repository.object.exceptions.ObjectStoreException;
import org.openrdf.repository.object.result.ObjectIterator;
import org.openrdf.repository.object.traits.ManagedRDFObject;
import org.openrdf.repository.object.traits.Refreshable;

public class RemotePropertySet
implements PropertySet,
Set<Object> {
    private final ManagedRDFObject bean;
    protected PropertySetModifier property;

    public RemotePropertySet(ManagedRDFObject bean, PropertySetModifier property) {
        assert (bean != null);
        assert (property != null);
        this.bean = bean;
        this.property = property;
    }

    @Override
    public void refresh() {
    }

    @Override
    public boolean add(Object o) {
        ObjectConnection conn = this.getObjectConnection();
        try {
            Value value = this.getValue(o);
            this.add(conn, this.getResource(), value);
            if (value instanceof Resource) {
                this.refreshEntity();
            }
        }
        catch (RepositoryException e) {
            throw new ObjectPersistException((Exception)((Object)e));
        }
        this.refresh();
        this.refresh(o);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(Collection<?> c) {
        ObjectConnection conn = this.getObjectConnection();
        boolean modified = false;
        try {
            boolean autoCommit = conn.isAutoCommit();
            if (autoCommit) {
                conn.setAutoCommit(false);
            }
            try {
                for (Object o : c) {
                    if (!this.add(o)) continue;
                    modified = true;
                }
                if (autoCommit) {
                    conn.setAutoCommit(true);
                }
            }
            finally {
                if (autoCommit && !conn.isAutoCommit()) {
                    conn.rollback();
                    conn.setAutoCommit(true);
                }
            }
        }
        catch (RepositoryException e) {
            throw new ObjectPersistException((Exception)((Object)e));
        }
        this.refresh();
        this.refreshEntity();
        return modified;
    }

    @Override
    public void clear() {
        try {
            this.property.remove(this.getObjectConnection(), this.getResource(), null);
        }
        catch (RepositoryException e) {
            throw new ObjectPersistException((Exception)((Object)e));
        }
        this.refresh();
        this.refreshEntity();
    }

    @Override
    public boolean contains(Object o) {
        ObjectConnection conn = this.getObjectConnection();
        try {
            Value val = this.getValue(o);
            return conn.hasStatement(this.getResource(), this.getURI(), val, new Resource[0]);
        }
        catch (RepositoryException e) {
            throw new ObjectPersistException((Exception)((Object)e));
        }
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        Iterator<?> e = c.iterator();
        while (e.hasNext()) {
            if (this.contains(e.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!o.getClass().equals(this.getClass())) {
            return false;
        }
        RemotePropertySet p = (RemotePropertySet)o;
        if (!this.getResource().equals(p.getResource())) {
            return false;
        }
        if (!this.property.equals(p.property)) {
            return false;
        }
        return ((Object)((Object)this.getObjectConnection())).equals((Object)p.getObjectConnection());
    }

    @Override
    public Set<Object> getAll() {
        return this;
    }

    @Override
    public Object getSingle() {
        ObjectIterator<?, Object> iter = this.getObjectIterator();
        try {
            if (iter.hasNext()) {
                Object object = iter.next();
                return object;
            }
            Object var2_3 = null;
            return var2_3;
        }
        finally {
            iter.close();
        }
    }

    @Override
    public int hashCode() {
        int hashCode = this.getResource().hashCode();
        return hashCode ^= this.property.hashCode();
    }

    @Override
    public boolean isEmpty() {
        ObjectIterator<?, Object> iter = this.getObjectIterator();
        try {
            boolean bl = !iter.hasNext();
            return bl;
        }
        finally {
            iter.close();
        }
    }

    @Override
    public boolean remove(Object o) {
        ObjectConnection conn = this.getObjectConnection();
        try {
            Value value = this.getValue(o);
            this.remove(conn, this.getResource(), value);
            if (value instanceof Resource) {
                this.refreshEntity();
            }
        }
        catch (RepositoryException e) {
            throw new ObjectPersistException((Exception)((Object)e));
        }
        this.refresh(o);
        this.refresh();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAll(Collection<?> c) {
        ObjectConnection conn = this.getObjectConnection();
        boolean modified = false;
        try {
            boolean autoCommit = conn.isAutoCommit();
            if (autoCommit) {
                conn.setAutoCommit(false);
            }
            try {
                for (Object o : c) {
                    if (!this.remove(o)) continue;
                    modified = true;
                }
                if (autoCommit) {
                    conn.setAutoCommit(true);
                }
            }
            finally {
                if (autoCommit && !conn.isAutoCommit()) {
                    conn.rollback();
                    conn.setAutoCommit(true);
                }
            }
        }
        catch (RepositoryException e) {
            throw new ObjectPersistException((Exception)((Object)e));
        }
        this.refresh();
        this.refreshEntity();
        return modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retainAll(Collection<?> c) {
        ObjectConnection conn = this.getObjectConnection();
        boolean modified = false;
        try {
            boolean autoCommit = conn.isAutoCommit();
            if (autoCommit) {
                conn.setAutoCommit(false);
            }
            ObjectIterator<?, Object> e = this.getObjectIterator();
            try {
                while (e.hasNext()) {
                    if (c.contains(e.next())) continue;
                    e.remove();
                    modified = true;
                }
            }
            finally {
                e.close();
            }
            if (autoCommit) {
                conn.setAutoCommit(true);
            }
        }
        catch (RepositoryException e) {
            throw new ObjectPersistException((Exception)((Object)e));
        }
        this.refresh();
        this.refreshEntity();
        return modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAll(Set<?> set) {
        if (this == set) {
            return;
        }
        if (set == null) {
            this.clear();
            return;
        }
        HashSet c = new HashSet(set);
        ObjectConnection conn = this.getObjectConnection();
        try {
            boolean autoCommit = conn.isAutoCommit();
            if (autoCommit) {
                conn.setAutoCommit(false);
            }
            try {
                this.clear();
                this.addAll((Collection<?>)c);
                if (autoCommit) {
                    conn.setAutoCommit(true);
                }
            }
            finally {
                if (autoCommit && !conn.isAutoCommit()) {
                    conn.rollback();
                    conn.setAutoCommit(true);
                }
            }
        }
        catch (RepositoryException e) {
            throw new ObjectPersistException((Exception)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSingle(Object o) {
        if (o == null) {
            this.clear();
        } else {
            ObjectConnection conn = this.getObjectConnection();
            try {
                boolean autoCommit = conn.isAutoCommit();
                if (autoCommit) {
                    conn.setAutoCommit(false);
                }
                try {
                    this.clear();
                    this.add(o);
                    if (autoCommit) {
                        conn.setAutoCommit(true);
                    }
                }
                finally {
                    if (autoCommit && !conn.isAutoCommit()) {
                        conn.rollback();
                        conn.setAutoCommit(true);
                    }
                }
            }
            catch (RepositoryException e) {
                throw new ObjectPersistException((Exception)((Object)e));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        int n;
        RepositoryResult<Statement> iter = this.getStatements();
        try {
            int size = 0;
            while (iter.hasNext()) {
                iter.next();
                ++size;
            }
            n = size;
        }
        catch (Throwable throwable) {
            try {
                iter.close();
                throw throwable;
            }
            catch (RepositoryException e) {
                throw new ObjectStoreException((Exception)((Object)e));
            }
        }
        iter.close();
        return n;
    }

    @Override
    public Iterator<Object> iterator() {
        return this.getObjectIterator();
    }

    @Override
    public Object[] toArray() {
        ArrayList<Object> list = new ArrayList<Object>();
        ObjectIterator<?, Object> iter = this.getObjectIterator();
        try {
            while (iter.hasNext()) {
                list.add(iter.next());
            }
        }
        finally {
            iter.close();
        }
        return list.toArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T[] toArray(T[] a) {
        ArrayList<Object> list = new ArrayList<Object>();
        ObjectIterator<?, Object> iter = this.getObjectIterator();
        try {
            while (iter.hasNext()) {
                list.add(iter.next());
            }
        }
        finally {
            iter.close();
        }
        return list.toArray(a);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        ObjectIterator<?, Object> iter = this.getObjectIterator();
        try {
            if (iter.hasNext()) {
                sb.append(iter.next().toString());
            }
            while (iter.hasNext()) {
                sb.append(", ");
                sb.append(iter.next());
            }
        }
        finally {
            iter.close();
        }
        return sb.toString();
    }

    final ObjectConnection getObjectConnection() {
        return this.bean.getObjectConnection();
    }

    final Resource getResource() {
        return this.bean.getResource();
    }

    final URI getURI() {
        return this.property.getPredicate();
    }

    void add(ObjectConnection conn, Resource subj, Value obj) throws RepositoryException {
        this.property.add(conn, subj, obj);
    }

    void remove(ObjectConnection conn, Resource subj, Value obj) throws RepositoryException {
        this.property.remove(conn, subj, obj);
    }

    void remove(ObjectConnection conn, Statement stmt) throws RepositoryException {
        assert (stmt.getPredicate().equals((Object)this.getURI()));
        this.remove(conn, stmt.getSubject(), stmt.getObject());
    }

    protected Object createInstance(Value value) throws RepositoryException {
        if (value instanceof Resource) {
            return this.getObjectConnection().getObject((Value)((Resource)value));
        }
        return this.getObjectConnection().getObjectFactory().createObject((Literal)value);
    }

    protected RepositoryResult<Statement> getStatements() throws RepositoryException {
        ObjectConnection conn = this.getObjectConnection();
        return conn.getStatements(this.getResource(), this.getURI(), null, new Resource[0]);
    }

    protected CloseableIteration<Value, RepositoryException> getValues() throws RepositoryException {
        return new ConvertingIteration<Statement, Value, RepositoryException>(this.getStatements()){

            protected Value convert(Statement st) throws RepositoryException {
                return st.getObject();
            }
        };
    }

    protected Value getValue(Object instance) throws RepositoryException {
        return this.getObjectConnection().addObject(instance);
    }

    protected void refresh(Object o) {
        if (o instanceof Refreshable) {
            ((Refreshable)o).refresh();
        }
    }

    protected void refreshEntity() {
        this.refresh(this.bean);
    }

    protected CloseableIteration<?, ?> getObjects() throws RepositoryException, QueryEvaluationException {
        return new ConvertingIteration<Value, Object, RepositoryException>(this.getValues()){

            protected Object convert(Value value) throws RepositoryException {
                return RemotePropertySet.this.createInstance(value);
            }
        };
    }

    protected ObjectIterator<?, Object> getObjectIterator() {
        try {
            return new ObjectIterator<Object, Object>(this.getObjects()){

                @Override
                protected void remove(Object o) {
                    RemotePropertySet.this.remove(o);
                }
            };
        }
        catch (RepositoryException e) {
            throw new ObjectPersistException((Exception)((Object)e));
        }
        catch (QueryEvaluationException e) {
            throw new ObjectPersistException((Exception)((Object)e));
        }
    }
}

