/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.object.advisers.helpers;

import info.aduna.xml.XMLWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.TransformerException;
import org.openrdf.OpenRDFException;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Model;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.LinkedHashModel;
import org.openrdf.query.BindingSet;
import org.openrdf.query.BooleanQuery;
import org.openrdf.query.GraphQuery;
import org.openrdf.query.GraphQueryResult;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.Operation;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.QueryResultHandler;
import org.openrdf.query.QueryResultUtil;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.query.TupleQueryResultHandlerException;
import org.openrdf.query.Update;
import org.openrdf.query.resultio.sparqlxml.SPARQLBooleanXMLWriter;
import org.openrdf.query.resultio.sparqlxml.SPARQLResultsXMLWriter;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.object.ObjectConnection;
import org.openrdf.repository.object.ObjectFactory;
import org.openrdf.repository.object.ObjectQuery;
import org.openrdf.repository.object.advisers.SparqlQuery;
import org.openrdf.result.MultipleResultException;
import org.openrdf.result.Result;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.helpers.StatementCollector;
import org.openrdf.rio.rdfxml.RDFXMLWriter;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class SparqlEvaluator {
    private static final Pattern ILLEGAL_VAR = Pattern.compile("\\s|\\?");
    private static final XMLInputFactory inFactory;
    private static final DocumentBuilderFactory documentBuilderFactory;
    private final SparqlQuery sparql;
    private final String systemId;

    public SparqlEvaluator(SparqlQuery query) throws MalformedURLException, MalformedQueryException, IOException {
        this.systemId = query.getBaseURI();
        this.sparql = query;
    }

    public String toString() {
        return this.sparql.toString();
    }

    public SparqlBuilder prepare(ObjectConnection con) {
        return new SparqlBuilder(con, this.getSparqlQuery());
    }

    private SparqlQuery getSparqlQuery() {
        return this.sparql;
    }

    static {
        Object factory = XMLInputFactory.newInstance();
        ((XMLInputFactory)factory).setProperty("javax.xml.stream.isValidating", false);
        ((XMLInputFactory)factory).setProperty("javax.xml.stream.supportDTD", false);
        inFactory = factory;
        factory = DocumentBuilderFactory.newInstance();
        ((DocumentBuilderFactory)factory).setValidating(false);
        ((DocumentBuilderFactory)factory).setNamespaceAware(true);
        ((DocumentBuilderFactory)factory).setIgnoringComments(false);
        ((DocumentBuilderFactory)factory).setIgnoringElementContentWhitespace(false);
        documentBuilderFactory = factory;
    }

    public class SparqlBuilder {
        private ObjectConnection con;
        private SparqlQuery query;
        private Map<String, Value> bindings = new HashMap<String, Value>();
        private List<String> bindingNames = new ArrayList<String>();
        private List<List<Value>> bindingValues = new ArrayList<List<Value>>();
        private ObjectFactory of;

        public SparqlBuilder(ObjectConnection con, SparqlQuery query) {
            assert (con != null);
            assert (query != null);
            this.con = con;
            this.query = query;
            this.of = con.getObjectFactory();
        }

        public String toString() {
            return this.bindMultiples(this.query.toString());
        }

        public SparqlBuilder with(String name, Set values) {
            boolean illegal = ILLEGAL_VAR.matcher(name).find();
            if (illegal && values != null && !values.isEmpty()) {
                throw new IllegalArgumentException("Invalide SPARQL variable name: '" + name + "'");
            }
            ArrayList<List<Value>> list = new ArrayList<List<Value>>();
            for (Object value : values) {
                for (List<Value> bindings : this.bindingValues) {
                    ArrayList<Value> set = new ArrayList<Value>(bindings.size() + 1);
                    set.addAll(bindings);
                    if (value == null) {
                        set.add(null);
                    } else if (value instanceof Value) {
                        set.add((Value)value);
                    } else {
                        set.add(this.of.createValue(value));
                    }
                    list.add(set);
                }
                if (!this.bindingValues.isEmpty()) continue;
                ArrayList<Value> set = new ArrayList<Value>(1);
                if (value == null) {
                    set.add(null);
                } else if (value instanceof Value) {
                    set.add((Value)value);
                } else {
                    set.add(this.of.createValue(value));
                }
                list.add(set);
            }
            this.bindingValues = list;
            this.bindingNames.add(name);
            return this;
        }

        public SparqlBuilder with(String name, Object value) {
            if (value == null) {
                this.bindings.remove(name);
            } else if (value instanceof Value) {
                this.bindings.put(name, (Value)value);
            } else {
                this.bindings.put(name, this.of.createValue(value));
            }
            return this;
        }

        public SparqlBuilder with(String name, boolean value) {
            this.bindings.put(name, (Value)this.con.getValueFactory().createLiteral(value));
            return this;
        }

        public SparqlBuilder with(String name, char value) {
            this.bindings.put(name, (Value)this.con.getValueFactory().createLiteral((int)value));
            return this;
        }

        public SparqlBuilder with(String name, byte value) {
            this.bindings.put(name, (Value)this.con.getValueFactory().createLiteral(value));
            return this;
        }

        public SparqlBuilder with(String name, short value) {
            this.bindings.put(name, (Value)this.con.getValueFactory().createLiteral(value));
            return this;
        }

        public SparqlBuilder with(String name, int value) {
            this.bindings.put(name, (Value)this.con.getValueFactory().createLiteral(value));
            return this;
        }

        public SparqlBuilder with(String name, long value) {
            this.bindings.put(name, (Value)this.con.getValueFactory().createLiteral(value));
            return this;
        }

        public SparqlBuilder with(String name, float value) {
            this.bindings.put(name, (Value)this.con.getValueFactory().createLiteral(value));
            return this;
        }

        public SparqlBuilder with(String name, double value) {
            this.bindings.put(name, (Value)this.con.getValueFactory().createLiteral(value));
            return this;
        }

        public Model asModel() throws OpenRDFException {
            GraphQuery qry = this.prepareGraphQuery();
            LinkedHashModel model = new LinkedHashModel();
            qry.evaluate((RDFHandler)new StatementCollector((Collection)model));
            return model;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Statement asStatement() throws OpenRDFException {
            GraphQueryResult result = this.asGraphQueryResult();
            try {
                if (result.hasNext()) {
                    Statement stmt = (Statement)result.next();
                    if (result.hasNext()) {
                        throw new MultipleResultException();
                    }
                    Statement statement = stmt;
                    return statement;
                }
                Statement statement = null;
                return statement;
            }
            finally {
                result.close();
            }
        }

        public URI asURI() throws OpenRDFException {
            return (URI)this.asResource();
        }

        public BNode asBNode() throws OpenRDFException {
            return (BNode)this.asResource();
        }

        public Resource asResource() throws OpenRDFException {
            return (Resource)this.asValue();
        }

        public Literal asLiteral() throws OpenRDFException {
            return (Literal)this.asValue();
        }

        public Value asValue() throws OpenRDFException {
            BindingSet bs = this.asBindingSet();
            if (bs == null) {
                return null;
            }
            return bs.getValue((String)bs.getBindingNames().iterator().next());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public BindingSet asBindingSet() throws OpenRDFException {
            TupleQueryResult result = this.asTupleQueryResult();
            try {
                if (result.hasNext()) {
                    BindingSet bindings = (BindingSet)result.next();
                    if (result.hasNext()) {
                        throw new MultipleResultException();
                    }
                    BindingSet bindingSet = bindings;
                    return bindingSet;
                }
                BindingSet bindingSet = null;
                return bindingSet;
            }
            finally {
                result.close();
            }
        }

        public TupleQueryResult asTupleQueryResult() throws OpenRDFException {
            return this.prepareTupleQuery().evaluate();
        }

        public GraphQueryResult asGraphQueryResult() throws OpenRDFException {
            return this.prepareGraphQuery().evaluate();
        }

        public boolean asBoolean() throws OpenRDFException {
            if (this.query.isBooleanQuery()) {
                return this.prepareBooleanQuery().evaluate();
            }
            return this.asResult(Boolean.class).singleResult();
        }

        public char asChar() throws OpenRDFException {
            return this.asResult(Character.class).singleResult().charValue();
        }

        public byte asByte() throws OpenRDFException {
            return this.asResult(Byte.class).singleResult();
        }

        public short asShort() throws OpenRDFException {
            return this.asResult(Short.class).singleResult();
        }

        public int asInt() throws OpenRDFException {
            return this.asResult(Integer.class).singleResult();
        }

        public long asLong() throws OpenRDFException {
            return this.asResult(Long.class).singleResult();
        }

        public float asFloat() throws OpenRDFException {
            return this.asResult(Float.class).singleResult().floatValue();
        }

        public double asDouble() throws OpenRDFException {
            return this.asResult(Double.class).singleResult();
        }

        public String asString() throws OpenRDFException {
            Result<String> result = this.asResult(String.class);
            if (result.hasNext()) {
                return result.singleResult();
            }
            return null;
        }

        public CharSequence asCharSequence() throws OpenRDFException {
            Result<CharSequence> result = this.asResult(CharSequence.class);
            if (result.hasNext()) {
                return result.singleResult();
            }
            return null;
        }

        public byte[] asByteArray() throws OpenRDFException {
            Result<byte[]> result = this.asResult(byte[].class);
            if (result.hasNext()) {
                return result.singleResult();
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Set<? extends Value> asSetOfValues() throws OpenRDFException {
            LinkedHashSet<Value> set = new LinkedHashSet<Value>();
            TupleQueryResult result = this.asTupleQueryResult();
            try {
                if (result.getBindingNames().isEmpty()) {
                    Set<? extends Value> set2 = null;
                    return set2;
                }
                String name = (String)result.getBindingNames().iterator().next();
                while (result.hasNext()) {
                    set.add(((BindingSet)result.next()).getValue(name));
                }
                LinkedHashSet<Value> linkedHashSet = set;
                return linkedHashSet;
            }
            finally {
                result.close();
            }
        }

        public Set asSet() throws OpenRDFException {
            return this.asResult().asSet();
        }

        public Result asResult() throws OpenRDFException {
            ObjectQuery qry = this.prepareObjectQuery(Object.class);
            return qry.evaluate();
        }

        public <T> Result<T> asResult(Class<T> of) throws OpenRDFException {
            if (of == null || Object.class.equals(of)) {
                return this.asResult();
            }
            ObjectQuery qry = this.prepareObjectQuery(of);
            return qry.evaluate(of);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T> Set<T> asSet(Class<T> of) throws OpenRDFException {
            if (of == null || Object.class.equals(of)) {
                return this.asSet();
            }
            if (BindingSet.class.equals(of)) {
                TupleQueryResult result = this.asTupleQueryResult();
                try {
                    ArrayList<Object> list = new ArrayList<Object>();
                    while (result.hasNext()) {
                        list.add(result.next());
                    }
                    Set set = (Set)((Object)list);
                    return set;
                }
                finally {
                    result.close();
                }
            }
            if (Value.class.isAssignableFrom(of)) {
                return this.asSetOfValues();
            }
            if (Statement.class.equals(of)) {
                return this.asModel();
            }
            return this.asResult(of).asSet();
        }

        public <T> List<T> asList(Class<T> of) throws OpenRDFException {
            if (of == null || Object.class.equals(of)) {
                return this.asList();
            }
            return this.asResult(of).asList();
        }

        public <T> T as(Class<T> of) throws OpenRDFException {
            Result<T> result = this.asResult(of);
            if (result.hasNext()) {
                return result.singleResult();
            }
            return null;
        }

        public List asList() throws OpenRDFException {
            return this.asResult().asList();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Document asDocument() throws OpenRDFException, TransformerException, IOException, ParserConfigurationException {
            DocumentBuilder builder = documentBuilderFactory.newDocumentBuilder();
            InputStream in = this.asInputStream();
            try {
                try {
                    if (SparqlEvaluator.this.systemId == null) {
                        Document document = builder.parse(in);
                        return document;
                    }
                    Document document = builder.parse(in, SparqlEvaluator.this.systemId);
                    return document;
                }
                catch (SAXException e) {
                    throw new TransformerException(e);
                }
                finally {
                    in.close();
                }
            }
            catch (IOException e) {
                throw new TransformerException(e);
            }
        }

        public DocumentFragment asDocumentFragment() throws OpenRDFException, TransformerException, IOException, ParserConfigurationException {
            Document doc = this.asDocument();
            DocumentFragment frag = doc.createDocumentFragment();
            frag.appendChild(doc.getDocumentElement());
            return frag;
        }

        public Element asElement() throws OpenRDFException, TransformerException, IOException, ParserConfigurationException {
            return this.asDocument().getDocumentElement();
        }

        public Node asNode() throws OpenRDFException, TransformerException, IOException, ParserConfigurationException {
            return this.asDocument();
        }

        public XMLEventReader asXMLEventReader() throws OpenRDFException, TransformerException, IOException, ParserConfigurationException, XMLStreamException {
            InputStream in = this.asInputStream();
            try {
                if (SparqlEvaluator.this.systemId == null) {
                    return inFactory.createXMLEventReader(in);
                }
                return inFactory.createXMLEventReader(SparqlEvaluator.this.systemId, in);
            }
            catch (XMLStreamException e) {
                throw new TransformerException(e);
            }
        }

        public ReadableByteChannel asReadableByteChannel() throws OpenRDFException, TransformerException, IOException, ParserConfigurationException, XMLStreamException {
            return Channels.newChannel(this.asInputStream());
        }

        public ByteArrayOutputStream asByteArrayOutputStream() throws OpenRDFException, TransformerException, IOException {
            ByteArrayOutputStream output = new ByteArrayOutputStream(8192);
            try {
                try {
                    this.toOutputStream(output);
                }
                catch (TupleQueryResultHandlerException e) {
                    throw new TransformerException(e);
                }
                catch (QueryEvaluationException e) {
                    throw new TransformerException(e);
                }
                finally {
                    output.close();
                }
            }
            catch (IOException e) {
                throw new TransformerException(e);
            }
            return output;
        }

        public InputStream asInputStream() throws OpenRDFException, TransformerException, IOException {
            return new ByteArrayInputStream(this.asByteArrayOutputStream().toByteArray());
        }

        public Reader asReader() throws OpenRDFException, TransformerException, IOException {
            return new StringReader(this.asCharArrayWriter().toString());
        }

        public Readable asReadable() throws TransformerException, OpenRDFException, IOException {
            return this.asReader();
        }

        public CharArrayWriter asCharArrayWriter() throws OpenRDFException, TransformerException, IOException {
            CharArrayWriter writer = new CharArrayWriter(8192);
            this.toWriter(writer);
            return writer;
        }

        public void asUpdate() throws OpenRDFException {
            String base = this.query.getBaseURI();
            String sparql = this.bindMultiples(this.query.toString());
            Update qry = this.bindSingles(this.con.prepareUpdate(QueryLanguage.SPARQL, sparql, base));
            qry.execute();
        }

        public void toOutputStream(OutputStream output) throws OpenRDFException, TransformerException, IOException {
            if (this.query.isGraphQuery()) {
                QueryResultUtil.report((GraphQueryResult)this.asGraphQueryResult(), (RDFHandler)new RDFXMLWriter(output));
            } else if (this.query.isTupleQuery()) {
                QueryResultUtil.report((TupleQueryResult)this.asTupleQueryResult(), (QueryResultHandler)new SPARQLResultsXMLWriter(output));
            } else if (this.query.isBooleanQuery()) {
                new SPARQLBooleanXMLWriter(output).write(this.asBoolean());
            } else {
                throw new AssertionError((Object)"Unknown query type");
            }
        }

        public void toWriter(Writer writer) throws OpenRDFException, TransformerException, IOException {
            if (this.query.isGraphQuery()) {
                QueryResultUtil.report((GraphQueryResult)this.asGraphQueryResult(), (RDFHandler)new RDFXMLWriter(writer));
            } else if (this.query.isTupleQuery()) {
                QueryResultUtil.report((TupleQueryResult)this.asTupleQueryResult(), (QueryResultHandler)new SPARQLResultsXMLWriter(new XMLWriter(writer)));
            } else if (this.query.isBooleanQuery()) {
                new SPARQLBooleanXMLWriter(new XMLWriter(writer)).write(this.asBoolean());
            } else {
                throw new AssertionError((Object)"Unknown query type");
            }
        }

        private GraphQuery prepareGraphQuery() throws MalformedQueryException, RepositoryException {
            String sparql = this.bindMultiples(this.query.toString());
            String base = this.query.getBaseURI();
            return this.bindSingles(this.con.prepareGraphQuery(QueryLanguage.SPARQL, sparql, base));
        }

        private TupleQuery prepareTupleQuery() throws MalformedQueryException, RepositoryException {
            String base = this.query.getBaseURI();
            String sparql = this.bindMultiples(this.query.toString());
            return this.bindSingles(this.con.prepareTupleQuery(QueryLanguage.SPARQL, sparql, base));
        }

        private BooleanQuery prepareBooleanQuery() throws MalformedQueryException, RepositoryException {
            String base = this.query.getBaseURI();
            String sparql = this.bindMultiples(this.query.toString());
            return this.bindSingles(this.con.prepareBooleanQuery(QueryLanguage.SPARQL, sparql, base));
        }

        private ObjectQuery prepareObjectQuery(Class<?> concept) throws MalformedQueryException, RepositoryException {
            String base = this.query.getBaseURI();
            String sparql = this.bindMultiples(this.query.toObjectString(concept));
            return this.bindSingles(this.con.prepareObjectQuery(QueryLanguage.SPARQL, sparql, base));
        }

        private String bindMultiples(String sparql) {
            if (this.bindingNames.isEmpty()) {
                return sparql;
            }
            StringBuilder sb = new StringBuilder(sparql);
            sb.append("\nBINDINGS");
            for (String string : this.bindingNames) {
                sb.append(" ?").append(string);
            }
            sb.append(" {\n");
            for (List list : this.bindingValues) {
                sb.append("\t(");
                for (Value value : list) {
                    if (value == null) {
                        sb.append("UNDEF");
                    } else if (value instanceof URI) {
                        this.writeURI(sb, value);
                    } else if (value instanceof BNode) {
                        this.writeBNode(sb, value);
                    } else if (value instanceof Literal) {
                        this.writeLiteral(sb, value);
                    } else {
                        throw new AssertionError();
                    }
                    sb.append(" ");
                }
                sb.append(")\n");
            }
            sb.append("}\n");
            return sb.toString();
        }

        private void writeBNode(StringBuilder sb, Value value) {
            sb.append("_:").append(value.stringValue());
        }

        private void writeLiteral(StringBuilder sb, Value value) {
            Literal lit = (Literal)value;
            sb.append("\"");
            String label = value.stringValue();
            sb.append(this.encodeString(label));
            sb.append("\"");
            if (lit.getDatatype() != null) {
                sb.append("^^");
                this.writeURI(sb, (Value)lit.getDatatype());
            }
            if (lit.getLanguage() != null) {
                sb.append("@");
                sb.append(lit.getLanguage());
            }
        }

        private void writeURI(StringBuilder sb, Value value) {
            sb.append("<");
            String uri = value.stringValue();
            sb.append(this.encodeURIString(uri));
            sb.append(">");
        }

        private <T extends Operation> T bindSingles(T qry) {
            for (Map.Entry<String, Value> binding : this.bindings.entrySet()) {
                qry.setBinding(binding.getKey(), binding.getValue());
            }
            return qry;
        }

        private String encodeString(String label) {
            label = label.replace("\\", "\\\\");
            label = label.replace("\t", "\\t");
            label = label.replace("\n", "\\n");
            label = label.replace("\r", "\\r");
            label = label.replace("\"", "\\\"");
            return label;
        }

        private String encodeURIString(String uri) {
            uri = uri.replace("\\", "\\\\");
            uri = uri.replace(">", "\\>");
            return uri;
        }
    }
}

