/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.object.advisers.helpers;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.openrdf.annotations.Bind;
import org.openrdf.annotations.Iri;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.vocabulary.OWL;
import org.openrdf.repository.object.ObjectConnection;
import org.openrdf.repository.object.ObjectFactory;
import org.openrdf.repository.object.advisers.helpers.SparqlEvaluator;

public class SparqlParameters {
    private final Type[] ptypes;
    private final String[][] bindingNames;
    private final String[] defaults;

    public SparqlParameters(Method m) {
        this.ptypes = m.getGenericParameterTypes();
        this.bindingNames = this.getBindingNames(m.getParameterAnnotations());
        this.defaults = this.getDefaultValues(m.getParameterAnnotations());
    }

    public Class<?> getComponentClass(Class<?> cls, Type type) {
        return this.asClass(this.getComponentType(cls, type));
    }

    public SparqlEvaluator.SparqlBuilder populate(Object[] args, SparqlEvaluator.SparqlBuilder with, ObjectConnection con) {
        for (int i = 0; i < args.length && i < this.bindingNames.length; ++i) {
            Object value = args[i];
            Type vtype = this.ptypes[i];
            Class<?> cvtype = this.asClass(vtype);
            String defaultValue = this.defaults[i];
            if (value == null && defaultValue != null && con != null) {
                value = this.getDefaultValue(defaultValue, vtype, con);
            }
            if (value == null) continue;
            if (Set.class.equals(cvtype)) {
                for (String name : this.bindingNames[i]) {
                    with = with.with(name, (Set)value);
                }
                continue;
            }
            for (String name : this.bindingNames[i]) {
                with = with.with(name, value);
            }
        }
        return with;
    }

    private Object getDefaultValue(String value, Type type, ObjectConnection con) {
        Class<?> ctype = this.asClass(type);
        if (Set.class.equals(ctype)) {
            Object v = this.getDefaultValue(value, this.getComponentType(ctype, type), con);
            if (v == null) {
                return null;
            }
            return Collections.singleton(v);
        }
        ValueFactory vf = con.getValueFactory();
        ObjectFactory of = con.getObjectFactory();
        if (of.isDatatype(ctype)) {
            URIImpl datatype = new URIImpl("java:" + ctype.getName());
            return of.createValue(of.createObject((Literal)new LiteralImpl(value, (URI)datatype)));
        }
        return vf.createURI(value);
    }

    private Type getComponentType(Class<?> cls, Type type) {
        if (cls.isArray()) {
            return cls.getComponentType();
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType ptype = (ParameterizedType)type;
            Type[] args = ptype.getActualTypeArguments();
            return args[args.length - 1];
        }
        if (Set.class.equals(cls) || Map.class.equals(cls)) {
            return Object.class;
        }
        return null;
    }

    private Class<?> asClass(Type type) {
        if (type == null) {
            return null;
        }
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType atype = (GenericArrayType)type;
            Class<?> componentType = this.asClass(atype.getGenericComponentType());
            return Array.newInstance(this.asClass(componentType), 0).getClass();
        }
        if (type instanceof ParameterizedType) {
            return this.asClass(((ParameterizedType)type).getRawType());
        }
        return Object.class;
    }

    private String[][] getBindingNames(Annotation[][] anns) {
        String[][] bindingNames = new String[anns.length][];
        block0: for (int i = 0; i < anns.length; ++i) {
            bindingNames[i] = new String[0];
            for (Annotation ann : anns[i]) {
                if (Bind.class.equals(ann.annotationType())) {
                    bindingNames[i] = ((Bind)ann).value();
                    continue block0;
                }
                if (!Iri.class.equals(ann.annotationType())) continue;
                bindingNames[i] = new String[]{this.local(((Iri)ann).value())};
            }
        }
        return bindingNames;
    }

    private String local(String iri) {
        String string = iri;
        if (string.lastIndexOf(35) >= 0) {
            string = string.substring(string.lastIndexOf(35) + 1);
        }
        if (string.lastIndexOf(63) >= 0) {
            string = string.substring(string.lastIndexOf(63) + 1);
        }
        if (string.lastIndexOf(47) >= 0) {
            string = string.substring(string.lastIndexOf(47) + 1);
        }
        if (string.lastIndexOf(58) >= 0) {
            string = string.substring(string.lastIndexOf(58) + 1);
        }
        return string;
    }

    private String[] getDefaultValues(Annotation[][] anns) {
        String[] defaults = new String[anns.length];
        for (int i = 0; i < anns.length; ++i) {
            Object value = this.getDefaultValue(anns[i]);
            if (value == null) continue;
            defaults[i] = value.toString();
        }
        return defaults;
    }

    private Object getDefaultValue(Annotation[] anns) {
        for (Annotation ann : anns) {
            for (Method m : ann.annotationType().getDeclaredMethods()) {
                Iri iri = m.getAnnotation(Iri.class);
                if (iri == null || !OWL.HASVALUE.equals((Object)iri.value()) || m.getParameterTypes().length != 0) continue;
                return this.invoke(m, ann);
            }
        }
        return null;
    }

    private Object invoke(Method m, Object obj) {
        try {
            return m.invoke(obj, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            throw new AssertionError((Object)e);
        }
        catch (IllegalAccessException e) {
            IllegalAccessError error = new IllegalAccessError(e.getMessage());
            error.initCause(e);
            throw error;
        }
        catch (InvocationTargetException e) {
            try {
                throw e.getCause();
            }
            catch (RuntimeException cause) {
                throw cause;
            }
            catch (Error cause) {
                throw cause;
            }
            catch (Throwable cause) {
                throw new UndeclaredThrowableException(cause);
            }
        }
    }
}

