/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.object.behaviours;

import info.aduna.iteration.CloseableIteration;
import info.aduna.iteration.ConvertingIteration;
import info.aduna.iteration.Iteration;
import java.util.AbstractSequentialList;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.openrdf.annotations.Precedes;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.RepositoryResult;
import org.openrdf.repository.object.ObjectConnection;
import org.openrdf.repository.object.RDFObject;
import org.openrdf.repository.object.behaviours.RDFObjectImpl;
import org.openrdf.repository.object.exceptions.ObjectPersistException;
import org.openrdf.repository.object.exceptions.ObjectStoreException;
import org.openrdf.repository.object.traits.Mergeable;
import org.openrdf.repository.object.traits.Refreshable;

@Precedes(value={RDFObjectImpl.class})
public abstract class RDFList
extends AbstractSequentialList<Object>
implements Refreshable,
Mergeable,
RDFObject {
    private int _size = -1;
    private RDFList parent;

    @Override
    public void refresh() {
        this._size = -1;
        if (this.parent != null) {
            this.parent.refresh();
        }
    }

    @Override
    public void merge(Object source) {
        if (source instanceof List) {
            this.clear();
            this.addAll((List)source);
        }
    }

    ValueFactory getValueFactory() {
        ObjectConnection conn = this.getObjectConnection();
        return conn.getValueFactory();
    }

    private CloseableIteration<Value, RepositoryException> getValues(Resource subj, URI pred, Value obj) {
        try {
            ObjectConnection conn = this.getObjectConnection();
            RepositoryResult stmts = conn.getStatements(subj, pred, obj, new Resource[0]);
            return new ConvertingIteration<Statement, Value, RepositoryException>((Iteration)stmts){

                protected Value convert(Statement stmt) throws RepositoryException {
                    return stmt.getObject();
                }
            };
        }
        catch (RepositoryException e) {
            throw new ObjectStoreException((Exception)((Object)e));
        }
    }

    void addStatement(Resource subj, URI pred, Value obj) {
        if (obj == null) {
            return;
        }
        try {
            ObjectConnection conn = this.getObjectConnection();
            conn.add(subj, pred, obj, new Resource[0]);
        }
        catch (RepositoryException e) {
            throw new ObjectPersistException((Exception)((Object)e));
        }
    }

    void removeStatements(Resource subj, URI pred, Value obj) {
        try {
            ObjectConnection conn = this.getObjectConnection();
            conn.remove(subj, pred, obj, new Resource[0]);
        }
        catch (RepositoryException e) {
            throw new ObjectPersistException((Exception)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        if (this._size < 0) {
            RDFList rDFList = this;
            synchronized (rDFList) {
                if (this._size < 0) {
                    Resource nlist;
                    Resource list = this.getResource();
                    int size = 0;
                    while (!(list == null || list.equals(RDF.NIL) || (nlist = this.getRest(list)) == null && this.getFirst(list) == null)) {
                        list = nlist;
                        ++size;
                    }
                    this._size = size;
                }
            }
        }
        return this._size;
    }

    @Override
    public ListIterator<Object> listIterator(final int index) {
        return new ListIterator<Object>(){
            private ArrayList<Resource> prevLists = new ArrayList();
            private boolean removed;
            Resource list;
            {
                for (int i = 0; i < index; ++i) {
                    this.next();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void add(Object o) {
                ObjectConnection conn = RDFList.this.getObjectConnection();
                try {
                    boolean autoCommit = conn.isAutoCommit();
                    if (autoCommit) {
                        conn.setAutoCommit(false);
                    }
                    try {
                        Value value;
                        if (RDFList.this.getResource().equals(RDF.NIL)) {
                            throw new ObjectPersistException("cannot add a value to the nil list");
                        }
                        Value value2 = value = o == null ? null : RDFList.this.getObjectConnection().addObject(o);
                        if (RDFList.this.getFirst(RDFList.this.getResource()) == null) {
                            this.list = RDFList.this.getResource();
                            RDFList.this.addStatement(this.list, RDF.FIRST, value);
                            RDFList.this.addStatement(this.list, RDF.REST, (Value)RDF.NIL);
                        } else if (this.list == null) {
                            Value first = RDFList.this.getFirst(RDFList.this.getResource());
                            Resource rest = RDFList.this.getRest(RDFList.this.getResource());
                            BNode newList = RDFList.this.getValueFactory().createBNode();
                            RDFList.this.addStatement((Resource)newList, RDF.FIRST, first);
                            RDFList.this.addStatement((Resource)newList, RDF.REST, (Value)rest);
                            RDFList.this.removeStatements(RDFList.this.getResource(), RDF.FIRST, first);
                            RDFList.this.removeStatements(RDFList.this.getResource(), RDF.REST, (Value)rest);
                            RDFList.this.addStatement(RDFList.this.getResource(), RDF.FIRST, value);
                            RDFList.this.addStatement(RDFList.this.getResource(), RDF.REST, (Value)newList);
                        } else if (!this.list.equals(RDF.NIL)) {
                            Resource rest = RDFList.this.getRest(this.list);
                            BNode newList = RDFList.this.getValueFactory().createBNode();
                            RDFList.this.removeStatements(this.list, RDF.REST, (Value)rest);
                            RDFList.this.addStatement(this.list, RDF.REST, (Value)newList);
                            RDFList.this.addStatement((Resource)newList, RDF.FIRST, value);
                            RDFList.this.addStatement((Resource)newList, RDF.REST, (Value)rest);
                        } else {
                            throw new NoSuchElementException();
                        }
                        if (autoCommit) {
                            conn.setAutoCommit(true);
                        }
                        RDFList.this.refresh();
                    }
                    finally {
                        if (autoCommit && !conn.isAutoCommit()) {
                            conn.rollback();
                            conn.setAutoCommit(true);
                        }
                    }
                }
                catch (RepositoryException e) {
                    throw new ObjectPersistException((Exception)((Object)e));
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void set(Object o) {
                ObjectConnection conn = RDFList.this.getObjectConnection();
                try {
                    boolean autoCommit = conn.isAutoCommit();
                    if (autoCommit) {
                        conn.setAutoCommit(false);
                    }
                    try {
                        if (RDFList.this.getResource().equals(RDF.NIL)) {
                            throw new NoSuchElementException();
                        }
                        if (this.list.equals(RDF.NIL)) {
                            throw new NoSuchElementException();
                        }
                        Value first = RDFList.this.getFirst(this.list);
                        RDFList.this.removeStatements(this.list, RDF.FIRST, first);
                        if (o != null) {
                            Value obj = RDFList.this.getObjectConnection().addObject(o);
                            RDFList.this.addStatement(this.list, RDF.FIRST, obj);
                        }
                        if (autoCommit) {
                            conn.setAutoCommit(true);
                        }
                    }
                    finally {
                        if (autoCommit && !conn.isAutoCommit()) {
                            conn.rollback();
                            conn.setAutoCommit(true);
                        }
                    }
                    RDFList.this.refresh();
                }
                catch (RepositoryException e) {
                    throw new ObjectPersistException((Exception)((Object)e));
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void remove() {
                ObjectConnection conn = RDFList.this.getObjectConnection();
                try {
                    boolean autoCommit = conn.isAutoCommit();
                    if (autoCommit) {
                        conn.setAutoCommit(false);
                    }
                    try {
                        if (this.prevLists.size() < 1) {
                            Value first = RDFList.this.getFirst(this.list);
                            RDFList.this.removeStatements(this.list, RDF.FIRST, first);
                            Resource next = RDFList.this.getRest(this.list);
                            first = RDFList.this.getFirst(next);
                            Resource rest = RDFList.this.getRest(next);
                            RDFList.this.removeStatements(this.list, RDF.REST, (Value)next);
                            if (first != null) {
                                RDFList.this.removeStatements(next, RDF.FIRST, first);
                                RDFList.this.addStatement(this.list, RDF.FIRST, first);
                            }
                            if (rest != null) {
                                RDFList.this.removeStatements(next, RDF.REST, (Value)rest);
                                RDFList.this.addStatement(this.list, RDF.REST, (Value)rest);
                            }
                        } else {
                            Resource removedList = this.list;
                            this.list = this.prevLists.remove(this.prevLists.size() - 1);
                            Value first = RDFList.this.getFirst(removedList);
                            Resource rest = RDFList.this.getRest(removedList);
                            RDFList.this.removeStatements(removedList, RDF.FIRST, first);
                            RDFList.this.removeStatements(removedList, RDF.REST, (Value)rest);
                            RDFList.this.removeStatements(this.list, RDF.REST, (Value)removedList);
                            RDFList.this.addStatement(this.list, RDF.REST, (Value)rest);
                        }
                        if (autoCommit) {
                            conn.setAutoCommit(true);
                        }
                        this.removed = true;
                        RDFList.this.refresh();
                    }
                    finally {
                        if (autoCommit && !conn.isAutoCommit()) {
                            conn.rollback();
                            conn.setAutoCommit(true);
                        }
                    }
                }
                catch (RepositoryException e) {
                    throw new ObjectStoreException((Exception)((Object)e));
                }
            }

            @Override
            public boolean hasNext() {
                Resource next = this.list == null ? RDFList.this.getResource() : RDFList.this.getRest(this.list);
                return RDFList.this.getFirst(next) != null;
            }

            @Override
            public Object next() {
                if (this.list == null) {
                    this.list = RDFList.this.getResource();
                } else if (!this.removed) {
                    this.prevLists.add(this.list);
                    this.list = RDFList.this.getRest(this.list);
                } else {
                    this.removed = false;
                }
                Value first = RDFList.this.getFirst(this.list);
                if (first == null) {
                    throw new NoSuchElementException();
                }
                return this.createInstance(first);
            }

            @Override
            public int nextIndex() {
                if (this.list == null) {
                    return 0;
                }
                return this.prevLists.size() + 1;
            }

            @Override
            public int previousIndex() {
                return this.prevLists.size() - 1;
            }

            @Override
            public boolean hasPrevious() {
                return this.prevLists.size() > 0;
            }

            @Override
            public Object previous() {
                this.list = this.prevLists.remove(this.prevLists.size() - 1);
                this.removed = false;
                Value first = RDFList.this.getFirst(this.list);
                if (first == null) {
                    throw new NoSuchElementException();
                }
                return this.createInstance(first);
            }

            private Object createInstance(Value first) {
                try {
                    if (first instanceof Resource) {
                        return RDFList.this.getObjectConnection().getObject((Value)((Resource)first));
                    }
                    return RDFList.this.getObjectConnection().getObjectFactory().createObject((Literal)first);
                }
                catch (RepositoryException e) {
                    throw new ObjectStoreException((Exception)((Object)e));
                }
            }
        };
    }

    @Override
    public String toString() {
        return super.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Value getFirst(Resource list) {
        if (list == null) {
            return null;
        }
        try {
            CloseableIteration<Value, RepositoryException> stmts = this.getValues(list, RDF.FIRST, null);
            try {
                if (stmts.hasNext()) {
                    Value value = (Value)stmts.next();
                    return value;
                }
                Value value = null;
                return value;
            }
            finally {
                stmts.close();
            }
        }
        catch (RepositoryException e) {
            throw new ObjectStoreException((Exception)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Resource getRest(Resource list) {
        if (list == null) {
            return null;
        }
        try {
            CloseableIteration<Value, RepositoryException> stmts = this.getValues(list, RDF.REST, null);
            try {
                if (stmts.hasNext()) {
                    Resource resource = (Resource)stmts.next();
                    return resource;
                }
                Resource resource = null;
                return resource;
            }
            finally {
                stmts.close();
            }
        }
        catch (RepositoryException e) {
            throw new ObjectStoreException((Exception)((Object)e));
        }
    }
}

