/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.object.behaviours;

import org.openrdf.annotations.ParameterTypes;
import org.openrdf.model.Resource;
import org.openrdf.repository.object.ObjectConnection;
import org.openrdf.repository.object.RDFObject;
import org.openrdf.repository.object.advisers.helpers.ObjectQueryFactory;
import org.openrdf.repository.object.traits.ManagedRDFObject;
import org.openrdf.repository.object.traits.ObjectMessage;
import org.openrdf.repository.object.traits.RDFObjectBehaviour;

public class RDFObjectImpl
implements ManagedRDFObject,
RDFObject {
    private ObjectConnection manager;
    private ObjectQueryFactory factory;
    private Resource resource;

    @Override
    public void initRDFObject(Resource resource, ObjectQueryFactory factory, ObjectConnection manager) {
        this.manager = manager;
        this.factory = factory;
        this.resource = resource;
    }

    @Override
    public ObjectConnection getObjectConnection() {
        return this.manager;
    }

    @Override
    public ObjectQueryFactory getObjectQueryFactory() {
        return this.factory;
    }

    @Override
    public Resource getResource() {
        return this.resource;
    }

    public boolean equals(Object obj) {
        if (this.resource == null) {
            return false;
        }
        if (obj instanceof RDFObjectBehaviour) {
            return this.equals(((RDFObjectBehaviour)obj).getBehaviourDelegate());
        }
        return obj instanceof RDFObject && this.resource.equals(((RDFObject)obj).getResource());
    }

    public int hashCode() {
        if (this.resource == null) {
            return 0;
        }
        return this.resource.hashCode();
    }

    @ParameterTypes(value={})
    public String toString(ObjectMessage msg) throws Exception {
        Object ret = msg.proceed();
        if (ret == null && this.resource != null) {
            return this.resource.toString();
        }
        return ret.toString();
    }
}

