/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.object.behaviours;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.openrdf.annotations.Precedes;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.query.BindingSet;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.RepositoryResult;
import org.openrdf.repository.object.ObjectConnection;
import org.openrdf.repository.object.ObjectRepository;
import org.openrdf.repository.object.RDFObject;
import org.openrdf.repository.object.behaviours.RDFObjectImpl;
import org.openrdf.repository.object.exceptions.ObjectPersistException;
import org.openrdf.repository.object.exceptions.ObjectStoreException;
import org.openrdf.repository.object.traits.Mergeable;
import org.openrdf.repository.object.traits.Refreshable;

@Precedes(value={RDFObjectImpl.class})
public abstract class RDFSContainer
extends AbstractList<Object>
implements Refreshable,
Mergeable,
RDFObject {
    private static final int UNKNOWN = -1;
    private static final int BSIZE = 64;
    private volatile int _size = -1;
    private List<Object[]> blocks = new ArrayList<Object[]>();

    @Override
    public void refresh() {
        this._size = -1;
    }

    @Override
    public Object get(int index) {
        try {
            int b = index / 64;
            Object[] block = this.getBlock(b);
            if (block != null) {
                return block[index % 64];
            }
            Object[] list = this.loadBlock(b);
            this.assignBlock(b, list);
            return list[index % 64];
        }
        catch (RepositoryException e) {
            throw new ObjectStoreException((Exception)((Object)e));
        }
        catch (QueryEvaluationException e) {
            throw new ObjectStoreException((Exception)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(int index, Object obj) {
        ObjectConnection conn = this.getObjectConnection();
        try {
            boolean autoCommit = conn.isAutoCommit();
            if (autoCommit) {
                conn.setAutoCommit(false);
            }
            try {
                for (int i = this.size() - 1; i >= index; --i) {
                    this.replace(i + 1, this.get(i));
                }
                this.replace(index, obj);
                if (this._size > -1) {
                    ++this._size;
                }
                if (autoCommit) {
                    conn.setAutoCommit(true);
                }
            }
            finally {
                if (autoCommit && !conn.isAutoCommit()) {
                    conn.rollback();
                    conn.setAutoCommit(true);
                }
            }
        }
        catch (RepositoryException e) {
            throw new ObjectPersistException((Exception)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object set(int index, Object obj) {
        Object object;
        ObjectConnection conn = this.getObjectConnection();
        boolean autoCommit = conn.isAutoCommit();
        if (autoCommit) {
            conn.setAutoCommit(false);
        }
        try {
            Object old = this.getAndSet(index, obj);
            if (autoCommit) {
                conn.setAutoCommit(true);
            }
            object = old;
        }
        catch (Throwable throwable) {
            try {
                if (autoCommit && !conn.isAutoCommit()) {
                    conn.rollback();
                    conn.setAutoCommit(true);
                }
                throw throwable;
            }
            catch (RepositoryException e) {
                throw new ObjectPersistException((Exception)((Object)e));
            }
        }
        if (autoCommit && !conn.isAutoCommit()) {
            conn.rollback();
            conn.setAutoCommit(true);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void merge(Object source) {
        if (source instanceof List) {
            ObjectConnection conn = this.getObjectConnection();
            try {
                boolean autoCommit = conn.isAutoCommit();
                if (autoCommit) {
                    conn.setAutoCommit(false);
                }
                try {
                    List list = (List)source;
                    int size = list.size();
                    int n = size;
                    for (int i = 0; i < n; ++i) {
                        Object value = list.get(i);
                        if (value == null) continue;
                        this.assign(i, value);
                    }
                    if (this._size > -1 && this._size < size) {
                        this._size = size;
                    }
                    if (autoCommit) {
                        conn.setAutoCommit(true);
                    }
                }
                finally {
                    if (autoCommit && !conn.isAutoCommit()) {
                        conn.rollback();
                        conn.setAutoCommit(true);
                    }
                }
            }
            catch (RepositoryException e) {
                throw new ObjectPersistException((Exception)((Object)e));
            }
        }
    }

    @Override
    public Object remove(int index) {
        ObjectConnection conn = this.getObjectConnection();
        try {
            boolean autoCommit = conn.isAutoCommit();
            if (autoCommit) {
                conn.setAutoCommit(false);
            }
            Object obj = this.get(index);
            int size = this.size();
            for (int i = index; i < size - 1; ++i) {
                this.replace(i, this.get(i + 1));
            }
            URI pred = this.getMemberPredicate(size - 1);
            conn.remove(this.getResource(), pred, null, new Resource[0]);
            Object[] block = this.getBlock((size - 1) / 64);
            if (block != null) {
                block[(size - 1) % 64] = null;
            }
            if (this._size > -1) {
                --this._size;
            }
            if (autoCommit) {
                conn.setAutoCommit(true);
            }
            return obj;
        }
        catch (RepositoryException e) {
            throw new ObjectPersistException((Exception)((Object)e));
        }
    }

    @Override
    public void clear() {
        try {
            ObjectConnection conn = this.getObjectConnection();
            Resource resource = this.getResource();
            int size = this._size;
            if (size < 0) {
                size = this.findSize();
            }
            for (int i = 0; i < size; ++i) {
                URI pred = this.getMemberPredicate(i);
                conn.remove(resource, pred, null, new Resource[0]);
            }
        }
        catch (RepositoryException e) {
            throw new ObjectPersistException((Exception)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        try {
            if (this._size < 0) {
                RDFSContainer rDFSContainer = this;
                synchronized (rDFSContainer) {
                    if (this._size < 0) {
                        int index;
                        this._size = index = this.findSize();
                    }
                }
            }
            return this._size;
        }
        catch (RepositoryException e) {
            throw new ObjectStoreException((Exception)((Object)e));
        }
    }

    @Override
    public String toString() {
        return super.toString();
    }

    private URI getMemberPredicate(int index) {
        ObjectConnection conn = this.getObjectConnection();
        ObjectRepository repository = conn.getRepository();
        String uri = "http://www.w3.org/1999/02/22-rdf-syntax-ns#_" + (index + 1);
        return repository.getValueFactory().createURI(uri);
    }

    private int getIndex(URI pred) {
        assert (pred.stringValue().startsWith("http://www.w3.org/1999/02/22-rdf-syntax-ns#_"));
        return Integer.parseInt(pred.getLocalName().substring(1)) - 1;
    }

    private Object getAndSet(int index, Object o) throws RepositoryException {
        if (o == null) {
            throw new NullPointerException();
        }
        URI pred = this.getMemberPredicate(index);
        Object old = this.get(index);
        ObjectConnection conn = this.getObjectConnection();
        if (old != null) {
            conn.remove(this.getResource(), pred, null, new Resource[0]);
        }
        conn.add(this.getResource(), pred, conn.addObject(o), new Resource[0]);
        Object[] block = this.getBlock(index / 64);
        if (block != null) {
            block[index % 64] = o;
        }
        return old;
    }

    private void assign(int index, Object o) throws RepositoryException {
        if (o == null) {
            throw new NullPointerException();
        }
        URI pred = this.getMemberPredicate(index);
        Value newValue = this.getObjectConnection().addObject(o);
        ObjectConnection conn = this.getObjectConnection();
        conn.add(this.getResource(), pred, newValue, new Resource[0]);
        this.clearBlock(index / 64);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replace(int index, Object o) throws RepositoryException {
        if (o == null) {
            throw new NullPointerException();
        }
        URI pred = this.getMemberPredicate(index);
        ObjectConnection conn = this.getObjectConnection();
        Value newValue = this.getObjectConnection().addObject(o);
        boolean autoCommit = conn.isAutoCommit();
        if (autoCommit) {
            conn.setAutoCommit(false);
        }
        try {
            conn.remove(this.getResource(), pred, null, new Resource[0]);
            conn.add(this.getResource(), pred, newValue, new Resource[0]);
            if (autoCommit) {
                conn.setAutoCommit(true);
            }
        }
        finally {
            if (autoCommit && !conn.isAutoCommit()) {
                conn.rollback();
                conn.setAutoCommit(true);
            }
        }
        Object[] block = this.getBlock(index / 64);
        if (block != null) {
            block[index % 64] = o;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int findSize() throws RepositoryException {
        HashSet<URI> set = new HashSet<URI>();
        ObjectConnection conn = this.getObjectConnection();
        RepositoryResult iter = conn.getStatements(this.getResource(), null, null, new Resource[0]);
        try {
            while (iter.hasNext()) {
                set.add(((Statement)iter.next()).getPredicate());
            }
        }
        finally {
            iter.close();
        }
        int index = 0;
        while (set.contains(this.getMemberPredicate(index))) {
            ++index;
        }
        return index;
    }

    private synchronized Object[] getBlock(int b) {
        if (this.blocks.size() > b) {
            return this.blocks.get(b);
        }
        return null;
    }

    private synchronized void assignBlock(int b, Object[] list) {
        while (this.blocks.size() <= b) {
            this.blocks.add(null);
        }
        this.blocks.set(b, list);
    }

    private synchronized void clearBlock(int b) {
        if (this.blocks.size() > b) {
            this.blocks.set(b, null);
        }
    }

    private Object[] loadBlock(int b) throws RepositoryException, QueryEvaluationException {
        TupleQuery query = this.createBlockQuery(b);
        TupleQueryResult result = query.evaluate();
        BindingSet bindings = (BindingSet)result.next();
        ObjectConnection con = this.getObjectConnection();
        Object[] list = new Object[64];
        while (bindings != null) {
            URI pred = (URI)bindings.getValue("pred");
            int idx = this.getIndex(pred);
            Value value = bindings.getValue("value");
            HashSet<URI> types = new HashSet<URI>(4);
            do {
                Value c;
                if ((c = bindings.getValue("value_class")) instanceof URI) {
                    types.add((URI)c);
                }
                BindingSet bindingSet = bindings = result.hasNext() ? (BindingSet)result.next() : null;
            } while (bindings != null && pred.equals((Object)bindings.getValue("pred")));
            int i = idx % 64;
            if (value instanceof Literal) {
                list[i] = con.getObject((Value)((Literal)value));
                continue;
            }
            list[i] = con.getObject(types, (Resource)value);
        }
        return list;
    }

    private TupleQuery createBlockQuery(int b) throws RepositoryException {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT ?pred ?value ?value_class\n");
        sb.append("WHERE { $self ?pred ?value\n");
        sb.append("OPTIONAL { ?value a ?value_class }\n");
        sb.append("FILTER (");
        int n = b * 64 + 64;
        for (int i = b * 64; i < n; ++i) {
            sb.append("?pred = <");
            sb.append("http://www.w3.org/1999/02/22-rdf-syntax-ns#");
            sb.append("_");
            sb.append(i + 1);
            sb.append(">");
            if (i + 1 >= n) continue;
            sb.append(" || ");
        }
        sb.append(")}\n");
        ObjectConnection con = this.getObjectConnection();
        try {
            TupleQuery query = con.prepareTupleQuery(QueryLanguage.SPARQL, sb.toString());
            query.setBinding("self", (Value)this.getResource());
            return query;
        }
        catch (MalformedQueryException e) {
            throw new RepositoryException((Throwable)e);
        }
    }
}

