/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.object.config;

import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openrdf.model.Graph;
import org.openrdf.model.Model;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.GraphImpl;
import org.openrdf.model.impl.LinkedHashModel;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.model.util.ModelException;
import org.openrdf.repository.config.RepositoryConfigException;
import org.openrdf.repository.contextaware.config.ContextAwareConfig;
import org.openrdf.repository.object.config.ObjectRepositorySchema;
import org.openrdf.repository.object.exceptions.ObjectStoreConfigException;

public class ObjectRepositoryConfig
extends ContextAwareConfig
implements Cloneable {
    private static final String JAVA_NS = "java:";
    private ValueFactory vf = ValueFactoryImpl.getInstance();
    private ClassLoader cl;
    private Map<Class<?>, List<URI>> datatypes = new HashMap();
    private Map<Method, List<URI>> annotations = new HashMap<Method, List<URI>>();
    private Map<Class<?>, List<URI>> concepts = new HashMap();
    private Map<Class<?>, List<URI>> behaviours = new HashMap();
    private List<URL> conceptJars = new ArrayList<URL>();
    private List<URL> behaviourJars = new ArrayList<URL>();
    private Value blobStore;
    private Set<Value> blobStoreParameters = new HashSet<Value>();

    public ObjectRepositoryConfig() {
        this.cl = Thread.currentThread().getContextClassLoader();
        if (this.cl == null) {
            this.cl = this.getClass().getClassLoader();
        }
    }

    public ObjectRepositoryConfig(ClassLoader cl) {
        this.cl = cl;
    }

    public void setClassLoader(ClassLoader cl) {
        this.cl = cl;
    }

    public ClassLoader getClassLoader() {
        return this.cl;
    }

    public Map<Class<?>, List<URI>> getDatatypes() {
        return Collections.unmodifiableMap(this.datatypes);
    }

    public void addDatatype(Class<?> type, URI datatype) throws ObjectStoreConfigException {
        List<URI> list = this.datatypes.get(type);
        if (list == null && this.datatypes.containsKey(type)) {
            throw new ObjectStoreConfigException(type.getSimpleName() + " can only be added once");
        }
        if (list == null) {
            list = new LinkedList<URI>();
            this.datatypes.put(type, list);
        }
        list.add(datatype);
    }

    public void addDatatype(Class<?> type, String datatype) throws ObjectStoreConfigException {
        this.addDatatype(type, this.vf.createURI(datatype));
    }

    public Map<Method, List<URI>> getAnnotations() {
        return Collections.unmodifiableMap(this.annotations);
    }

    public void addAnnotation(Class<?> ann) throws ObjectStoreConfigException {
        if (ann.getDeclaredMethods().length != 1) {
            throw new ObjectStoreConfigException("Annotation class must have exactly one method: " + ann);
        }
        this.addAnnotation(ann.getDeclaredMethods()[0]);
    }

    public void addAnnotation(Class<?> ann, URI type) throws ObjectStoreConfigException {
        if (ann.getDeclaredMethods().length != 1) {
            throw new ObjectStoreConfigException("Annotation class must have exactly one method: " + ann);
        }
        this.addAnnotation(ann.getDeclaredMethods()[0], type);
    }

    public void addAnnotation(Class<?> ann, String type) throws ObjectStoreConfigException {
        if (ann.getDeclaredMethods().length != 1) {
            throw new ObjectStoreConfigException("Annotation class must have exactly one method: " + ann);
        }
        this.addAnnotation(ann.getDeclaredMethods()[0], type);
    }

    public void addAnnotation(Method ann) throws ObjectStoreConfigException {
        if (this.annotations.containsKey(ann)) {
            throw new ObjectStoreConfigException(ann.toString() + " can only be added once");
        }
        this.annotations.put(ann, null);
    }

    public void addAnnotation(Method ann, URI type) throws ObjectStoreConfigException {
        List<URI> list = this.annotations.get(ann);
        if (list == null && this.annotations.containsKey(ann)) {
            throw new ObjectStoreConfigException(ann.toString() + " can only be added once");
        }
        if (list == null) {
            list = new LinkedList<URI>();
            this.annotations.put(ann, list);
        }
        list.add(type);
    }

    public void addAnnotation(Method ann, String type) throws ObjectStoreConfigException {
        this.addAnnotation(ann, this.vf.createURI(type));
    }

    public Map<Class<?>, List<URI>> getConcepts() {
        return Collections.unmodifiableMap(this.concepts);
    }

    public void addConcept(Class<?> concept) throws ObjectStoreConfigException {
        if (this.concepts.containsKey(concept)) {
            throw new ObjectStoreConfigException(concept.getSimpleName() + " can only be added once");
        }
        this.concepts.put(concept, null);
    }

    public void addConcept(Class<?> concept, URI type) throws ObjectStoreConfigException {
        List<URI> list = this.concepts.get(concept);
        if (list == null && this.concepts.containsKey(concept)) {
            throw new ObjectStoreConfigException(concept.getSimpleName() + " can only be added once");
        }
        if (list == null) {
            list = new LinkedList<URI>();
            this.concepts.put(concept, list);
        }
        list.add(type);
    }

    public void addConcept(Class<?> concept, String type) throws ObjectStoreConfigException {
        this.addConcept(concept, this.vf.createURI(type));
    }

    public Map<Class<?>, List<URI>> getBehaviours() {
        return Collections.unmodifiableMap(this.behaviours);
    }

    public void addBehaviour(Class<?> behaviour) throws ObjectStoreConfigException {
        if (this.behaviours.containsKey(behaviour)) {
            throw new ObjectStoreConfigException(behaviour.getSimpleName() + " can only be added once");
        }
        try {
            behaviour.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new ObjectStoreConfigException(behaviour.getSimpleName() + " must have a default constructor");
        }
        this.behaviours.put(behaviour, null);
    }

    public void addBehaviour(Class<?> behaviour, URI type) throws ObjectStoreConfigException {
        List<URI> list = this.behaviours.get(behaviour);
        if (list == null && this.behaviours.containsKey(behaviour)) {
            throw new ObjectStoreConfigException(behaviour.getSimpleName() + " can only be added once");
        }
        if (list == null) {
            list = new LinkedList<URI>();
            this.behaviours.put(behaviour, list);
        }
        list.add(type);
    }

    public void addBehaviour(Class<?> behaviour, String type) throws ObjectStoreConfigException {
        this.addBehaviour(behaviour, this.vf.createURI(type));
    }

    public List<URL> getConceptJars() {
        return Collections.unmodifiableList(this.conceptJars);
    }

    public void addConceptJar(URL jarFile) {
        this.conceptJars.add(jarFile);
    }

    public List<URL> getBehaviourJars() {
        return Collections.unmodifiableList(this.behaviourJars);
    }

    public void addBehaviourJar(URL jarFile) {
        this.behaviourJars.add(jarFile);
    }

    public String getBlobStore() {
        if (this.blobStore == null) {
            return null;
        }
        return this.blobStore.stringValue();
    }

    public void setBlobStore(String blobStore) {
        this.blobStore = this.vf.createLiteral(blobStore);
    }

    public Map<String, String> getBlobStoreParameters() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Value v : this.blobStoreParameters) {
            String[] split = v.stringValue().split(":", 2);
            result.put(split[0], split[1]);
        }
        return result;
    }

    public void setBlobStoreParameters(Map<String, String> blobStoreParameters) {
        this.blobStoreParameters.clear();
        for (Map.Entry<String, String> e : blobStoreParameters.entrySet()) {
            String label = e.getKey() + ":" + e.getValue();
            this.blobStoreParameters.add((Value)this.vf.createLiteral(label));
        }
    }

    public ObjectRepositoryConfig clone() {
        try {
            Object o = super.clone();
            ObjectRepositoryConfig clone = (ObjectRepositoryConfig)o;
            clone.setReadContexts(this.copy(clone.getReadContexts()));
            clone.setAddContexts(this.copy(clone.getAddContexts()));
            clone.setRemoveContexts(this.copy(clone.getRemoveContexts()));
            clone.setArchiveContexts(this.copy(clone.getArchiveContexts()));
            clone.datatypes = this.copy(this.datatypes);
            clone.concepts = this.copy(this.concepts);
            clone.behaviours = this.copy(this.behaviours);
            clone.conceptJars = new ArrayList<URL>(this.conceptJars);
            clone.behaviourJars = new ArrayList<URL>(this.behaviourJars);
            clone.blobStoreParameters = new HashSet<Value>(this.blobStoreParameters);
            GraphImpl model = new GraphImpl();
            Resource subj = clone.export((Graph)model);
            clone.parse((Graph)model, subj);
            return clone;
        }
        catch (RepositoryConfigException e) {
            throw new AssertionError((Object)e);
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public Resource export(Graph model) {
        ValueFactoryImpl vf = ValueFactoryImpl.getInstance();
        Resource subj = super.export(model);
        this.exportAssocation(subj, this.datatypes, ObjectRepositorySchema.DATATYPE, model);
        this.exportAssocation(subj, this.concepts, ObjectRepositorySchema.CONCEPT, model);
        this.exportAssocation(subj, this.behaviours, ObjectRepositorySchema.BEHAVIOUR, model);
        for (URL jar : this.conceptJars) {
            model.add(subj, ObjectRepositorySchema.CONCEPT_JAR, (Value)vf.createURI(jar.toExternalForm()), new Resource[0]);
        }
        for (URL jar : this.behaviourJars) {
            model.add(subj, ObjectRepositorySchema.BEHAVIOUR_JAR, (Value)vf.createURI(jar.toExternalForm()), new Resource[0]);
        }
        if (this.blobStore != null) {
            model.add(subj, ObjectRepositorySchema.BLOB_STORE, this.blobStore, new Resource[0]);
        }
        for (Value v : this.blobStoreParameters) {
            model.add(subj, ObjectRepositorySchema.BLOB_STORE_PARAMETER, v, new Resource[0]);
        }
        return subj;
    }

    public void parse(Graph graph, Resource subj) throws RepositoryConfigException {
        super.parse(graph, subj);
        try {
            LinkedHashModel model = new LinkedHashModel((Collection)graph);
            this.parseAssocation(subj, this.datatypes, ObjectRepositorySchema.DATATYPE, (Model)model);
            this.parseAssocation(subj, this.concepts, ObjectRepositorySchema.CONCEPT, (Model)model);
            this.parseAssocation(subj, this.behaviours, ObjectRepositorySchema.BEHAVIOUR, (Model)model);
            this.conceptJars.clear();
            for (Value obj : model.filter(subj, ObjectRepositorySchema.CONCEPT_JAR, null, new Resource[0]).objects()) {
                this.conceptJars.add(new URL(obj.stringValue()));
            }
            this.behaviourJars.clear();
            for (Value obj : model.filter(subj, ObjectRepositorySchema.BEHAVIOUR_JAR, null, new Resource[0]).objects()) {
                this.behaviourJars.add(new URL(obj.stringValue()));
            }
            this.blobStore = model.filter(subj, ObjectRepositorySchema.BLOB_STORE, null, new Resource[0]).objectValue();
            this.blobStoreParameters.clear();
            this.blobStoreParameters.addAll(model.filter(subj, ObjectRepositorySchema.BLOB_STORE_PARAMETER, null, new Resource[0]).objects());
        }
        catch (MalformedURLException e) {
            throw new ObjectStoreConfigException((Throwable)e);
        }
        catch (ModelException e) {
            throw new ObjectStoreConfigException((Throwable)e);
        }
    }

    private Map<Class<?>, List<URI>> copy(Map<Class<?>, List<URI>> map) {
        HashMap result = new HashMap();
        for (Map.Entry<Class<?>, List<URI>> e : map.entrySet()) {
            if (e.getValue() == null) {
                result.put(e.getKey(), null);
                continue;
            }
            result.put(e.getKey(), new LinkedList(e.getValue()));
        }
        return result;
    }

    private URI[] copy(URI[] ar) {
        URI[] result = new URI[ar.length];
        System.arraycopy(ar, 0, result, 0, ar.length);
        return result;
    }

    private void exportAssocation(Resource subj, Map<Class<?>, List<URI>> assocation, URI relation, Graph model) {
        ValueFactoryImpl vf = ValueFactoryImpl.getInstance();
        for (Map.Entry<Class<?>, List<URI>> e : assocation.entrySet()) {
            URI name = vf.createURI(JAVA_NS, e.getKey().getName());
            model.add(subj, relation, (Value)name, new Resource[0]);
            if (e.getValue() == null) continue;
            for (URI value : e.getValue()) {
                model.add((Resource)name, ObjectRepositorySchema.KNOWN_AS, (Value)value, new Resource[0]);
            }
        }
    }

    private void parseAssocation(Resource subj, Map<Class<?>, List<URI>> assocation, URI relation, Model model) throws ObjectStoreConfigException {
        assocation.clear();
        for (Value obj : model.filter(subj, relation, null, new Resource[0]).objects()) {
            Class<?> role = this.loadClass(obj);
            Set objects = model.filter((Resource)obj, ObjectRepositorySchema.KNOWN_AS, null, new Resource[0]).objects();
            if (objects.isEmpty()) {
                assocation.put(role, null);
            }
            for (Value uri : objects) {
                List<URI> list = assocation.get(role);
                if (list == null) {
                    list = new LinkedList<URI>();
                    assocation.put(role, list);
                }
                list.add((URI)uri);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class<?> loadClass(Value base) throws ObjectStoreConfigException {
        URI uri;
        if (base instanceof URI && JAVA_NS.equals((uri = (URI)base).getNamespace())) {
            String name = uri.getLocalName();
            try {
                ClassLoader classLoader = this.cl;
                synchronized (classLoader) {
                    return Class.forName(name, true, this.cl);
                }
            }
            catch (ClassNotFoundException e) {
                throw new ObjectStoreConfigException((Throwable)e);
            }
        }
        throw new ObjectStoreConfigException("Invalid java URI: " + base);
    }
}

