/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.object.config;

import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openrdf.model.URI;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.model.vocabulary.RDFS;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.config.RepositoryConfigException;
import org.openrdf.repository.config.RepositoryImplConfig;
import org.openrdf.repository.contextaware.config.ContextAwareFactory;
import org.openrdf.repository.object.ObjectRepository;
import org.openrdf.repository.object.ObjectServiceImpl;
import org.openrdf.repository.object.behaviours.RDFObjectImpl;
import org.openrdf.repository.object.config.ObjectRepositoryConfig;
import org.openrdf.repository.object.exceptions.ObjectStoreConfigException;
import org.openrdf.repository.object.managers.LiteralManager;
import org.openrdf.repository.object.managers.RoleMapper;
import org.openrdf.repository.object.managers.helpers.RoleClassLoader;

public class ObjectRepositoryFactory
extends ContextAwareFactory {
    public static final String REPOSITORY_TYPE = "openrdf:ObjectRepository";

    public String getRepositoryType() {
        return REPOSITORY_TYPE;
    }

    public ObjectRepositoryConfig getConfig() {
        return new ObjectRepositoryConfig();
    }

    public ObjectRepository createRepository(ObjectRepositoryConfig config, Repository delegate) throws RepositoryConfigException, RepositoryException {
        ObjectRepository repo = this.getRepository(config, delegate.getValueFactory());
        repo.setDelegate(delegate);
        return repo;
    }

    public ObjectRepository createRepository(Repository delegate) throws RepositoryConfigException, RepositoryException {
        return this.createRepository(this.getConfig(), delegate);
    }

    public ObjectRepository getRepository(RepositoryImplConfig configuration) throws RepositoryConfigException {
        if (!(configuration instanceof ObjectRepositoryConfig)) {
            throw new RepositoryConfigException("Invalid configuration class: " + configuration.getClass());
        }
        ObjectRepositoryConfig config = (ObjectRepositoryConfig)configuration;
        return this.getRepository(config, (ValueFactory)ValueFactoryImpl.getInstance());
    }

    protected LiteralManager createLiteralManager(ValueFactory uf, ValueFactory lf) {
        return new LiteralManager(uf, lf);
    }

    protected RoleMapper createRoleMapper(ValueFactory vf) throws ObjectStoreConfigException {
        return new RoleMapper(vf);
    }

    protected ObjectRepository createObjectRepository(RoleMapper mapper, LiteralManager literals, ClassLoader cl) throws ObjectStoreConfigException {
        return new ObjectRepository(new ObjectServiceImpl(mapper, literals, cl));
    }

    private ObjectRepository getRepository(ObjectRepositoryConfig config, ValueFactory vf) throws ObjectStoreConfigException {
        ObjectRepository repo = this.getObjectRepository(config, vf);
        repo.setIncludeInferred(config.isIncludeInferred());
        repo.setMaxQueryTime(config.getMaxQueryTime());
        repo.setQueryLanguage(config.getQueryLanguage());
        repo.setReadContexts(config.getReadContexts());
        repo.setAddContexts(config.getAddContexts());
        repo.setInsertContext(config.getInsertContext());
        repo.setRemoveContexts(config.getRemoveContexts());
        repo.setArchiveContexts(config.getArchiveContexts());
        return repo;
    }

    private ObjectRepository getObjectRepository(ObjectRepositoryConfig module, ValueFactory vf) throws ObjectStoreConfigException {
        ClassLoader cl = this.getClassLoader(module);
        RoleMapper mapper = this.getRoleMapper(cl, vf, module);
        LiteralManager literals = this.getLiteralManager(cl, vf, module);
        ObjectRepository repo = this.createObjectRepository(mapper, literals, cl);
        repo.setBlobStoreUrl(module.getBlobStore());
        repo.setBlobStoreParameters(module.getBlobStoreParameters());
        return repo;
    }

    private ClassLoader getClassLoader(ObjectRepositoryConfig module) {
        ClassLoader cl = module.getClassLoader();
        ArrayList<URL> jars = new ArrayList<URL>();
        jars.addAll(module.getConceptJars());
        jars.addAll(module.getBehaviourJars());
        if (jars.isEmpty()) {
            return cl;
        }
        URL[] array = jars.toArray(new URL[jars.size()]);
        return new URLClassLoader(array, cl);
    }

    private RoleMapper getRoleMapper(ClassLoader cl, ValueFactory uf, ObjectRepositoryConfig module) throws ObjectStoreConfigException {
        RoleMapper mapper = this.createRoleMapper(uf);
        mapper.addBehaviour(RDFObjectImpl.class, RDFS.RESOURCE);
        RoleClassLoader loader = new RoleClassLoader(mapper);
        loader.loadRoles(cl);
        if (module.getConceptJars() != null) {
            for (URL uRL : module.getConceptJars()) {
                loader.scan(uRL, cl);
            }
        }
        if (module.getBehaviourJars() != null) {
            for (URL uRL : module.getBehaviourJars()) {
                loader.scan(uRL, cl);
            }
        }
        for (Map.Entry entry : module.getAnnotations().entrySet()) {
            if (entry.getValue() == null) {
                mapper.addAnnotation((Method)entry.getKey());
                continue;
            }
            for (URI value : (List)entry.getValue()) {
                mapper.addAnnotation((Method)entry.getKey(), value);
            }
        }
        for (Map.Entry entry : module.getConcepts().entrySet()) {
            if (entry.getValue() == null) {
                mapper.addConcept((Class)entry.getKey());
                continue;
            }
            for (URI value : (List)entry.getValue()) {
                mapper.addConcept((Class)entry.getKey(), value);
            }
        }
        for (Map.Entry entry : module.getBehaviours().entrySet()) {
            if (entry.getValue() == null) {
                mapper.addBehaviour((Class)entry.getKey());
                continue;
            }
            for (URI value : (List)entry.getValue()) {
                mapper.addBehaviour((Class)entry.getKey(), value);
            }
        }
        return mapper;
    }

    private LiteralManager getLiteralManager(ClassLoader cl, ValueFactory vf, ObjectRepositoryConfig module) {
        LiteralManager literalManager = this.createLiteralManager(vf, vf);
        literalManager.setClassLoader(cl);
        for (Map.Entry<Class<?>, List<URI>> e : module.getDatatypes().entrySet()) {
            for (URI value : e.getValue()) {
                literalManager.addDatatype(e.getKey(), value);
            }
        }
        return literalManager;
    }
}

