/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.object.result;

import info.aduna.iteration.LookAheadIteration;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.object.ObjectConnection;
import org.openrdf.repository.object.ObjectFactory;
import org.openrdf.repository.object.traits.PropertyConsumer;

public class ObjectArrayCursor
extends LookAheadIteration<Object, QueryEvaluationException> {
    private List<String> bindings;
    private TupleQueryResult result;
    private BindingSet next;
    private ObjectFactory of;
    private ObjectConnection manager;
    private final Class<?> componentType;

    public ObjectArrayCursor(ObjectConnection manager, TupleQueryResult result, List<String> bindings) throws QueryEvaluationException {
        this(manager, result, bindings, Object.class);
    }

    public ObjectArrayCursor(ObjectConnection manager, TupleQueryResult result, List<String> bindings, Class<?> componentType) throws QueryEvaluationException {
        this.bindings = bindings;
        this.result = result;
        this.next = result.hasNext() ? (BindingSet)result.next() : null;
        this.manager = manager;
        this.of = manager.getObjectFactory();
        this.componentType = componentType;
    }

    public Object getNextElement() throws QueryEvaluationException {
        if (this.next == null) {
            return null;
        }
        Value[] resources = new Value[this.bindings.size()];
        for (int i = 0; i < resources.length; ++i) {
            resources[i] = this.next.getValue(this.bindings.get(i));
        }
        List<BindingSet> properties = this.readProperties(resources);
        Object result = Array.newInstance(this.componentType, resources.length);
        for (int i = 0; i < resources.length; ++i) {
            if (resources[i] == null) continue;
            Object value = this.createRDFObject(resources[i], this.bindings.get(i), properties);
            Array.set(result, i, value);
        }
        return result;
    }

    private List<BindingSet> readProperties(Value ... values) throws QueryEvaluationException {
        ArrayList<BindingSet> properties = new ArrayList<BindingSet>();
        while (this.next != null) {
            for (int i = 0; i < values.length; ++i) {
                if (this.equals(values[i], this.next.getValue(this.bindings.get(i)))) continue;
                return properties;
            }
            properties.add(this.next);
            this.next = this.result.hasNext() ? (BindingSet)this.result.next() : null;
        }
        return properties;
    }

    private boolean equals(Value v1, Value v2) {
        return v1 == v2 || v1 != null && v1.equals(v2);
    }

    private Object createRDFObject(Value value, String binding, List<BindingSet> properties) throws QueryEvaluationException {
        Object obj;
        if (value == null) {
            return null;
        }
        if (value instanceof Literal) {
            return this.of.createObject((Literal)value);
        }
        if (properties.get(0).hasBinding(binding + "_class")) {
            HashSet<URI> list = new HashSet<URI>(properties.size());
            for (BindingSet bindings : properties) {
                Value t = bindings.getValue(binding + "_class");
                if (!(t instanceof URI)) continue;
                list.add((URI)t);
            }
            obj = this.manager.getObject(list, (Resource)value);
        } else {
            try {
                obj = this.manager.getObject(value);
            }
            catch (RepositoryException e) {
                throw new QueryEvaluationException((Throwable)e);
            }
        }
        if (obj instanceof PropertyConsumer) {
            ((PropertyConsumer)obj).usePropertyBindings(binding, properties);
        }
        return obj;
    }

    public void handleClose() throws QueryEvaluationException {
        this.result.close();
    }
}

