/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.object.result;

import info.aduna.iteration.CloseableIteration;
import info.aduna.iteration.LookAheadIteration;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.object.ObjectConnection;
import org.openrdf.repository.object.ObjectFactory;
import org.openrdf.repository.object.traits.PropertyConsumer;

public class ObjectCursor
extends LookAheadIteration<Object, QueryEvaluationException> {
    private String binding;
    private CloseableIteration<BindingSet, QueryEvaluationException> result;
    private BindingSet next;
    private ObjectFactory of;
    private ObjectConnection manager;

    public ObjectCursor(ObjectConnection manager, CloseableIteration<BindingSet, QueryEvaluationException> result, String binding) throws QueryEvaluationException {
        this.binding = binding;
        this.result = result;
        this.next = result.hasNext() ? (BindingSet)result.next() : null;
        this.manager = manager;
        this.of = manager.getObjectFactory();
    }

    public Object getNextElement() throws QueryEvaluationException {
        if (this.next == null) {
            return null;
        }
        Value resource = this.next.getValue(this.binding);
        List<BindingSet> properties = this.readProperties();
        if (resource == null) {
            return null;
        }
        return this.createRDFObject(resource, properties);
    }

    private List<BindingSet> readProperties() throws QueryEvaluationException {
        Value resource = this.next.getValue(this.binding);
        ArrayList<BindingSet> properties = new ArrayList<BindingSet>();
        while (this.next != null && this.equals(resource, this.next.getValue(this.binding))) {
            properties.add(this.next);
            this.next = this.result.hasNext() ? (BindingSet)this.result.next() : null;
        }
        return properties;
    }

    private boolean equals(Value v1, Value v2) {
        return v1 == v2 || v1 != null && v1.equals(v2);
    }

    private Object createRDFObject(Value value, List<BindingSet> properties) throws QueryEvaluationException {
        Object obj;
        if (value == null) {
            return null;
        }
        if (value instanceof Literal) {
            return this.of.createObject((Literal)value);
        }
        if (properties.get(0).hasBinding(this.binding + "_class")) {
            HashSet<URI> list = new HashSet<URI>(properties.size());
            for (BindingSet bindings : properties) {
                Value t = bindings.getValue(this.binding + "_class");
                if (!(t instanceof URI)) continue;
                list.add((URI)t);
            }
            obj = this.manager.getObject(list, (Resource)value);
        } else {
            try {
                obj = this.manager.getObject(value);
            }
            catch (RepositoryException e) {
                throw new QueryEvaluationException((Throwable)e);
            }
        }
        if (obj instanceof PropertyConsumer) {
            ((PropertyConsumer)obj).usePropertyBindings(this.binding, properties);
        }
        return obj;
    }

    public void handleClose() throws QueryEvaluationException {
        this.result.close();
    }
}

