/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.object.result;

import info.aduna.iteration.CloseableIteration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.object.exceptions.MultipleObjectResultException;
import org.openrdf.repository.object.exceptions.NoObjectResultException;
import org.openrdf.repository.object.exceptions.ObjectPersistException;
import org.openrdf.repository.object.exceptions.ObjectStoreException;

public abstract class ObjectIterator<S, E>
implements Iterator<E> {
    private CloseableIteration<? extends S, ?> delegate;
    private S element;
    private S next;

    public static void close(Iterator<?> iter) {
        if (iter instanceof ObjectIterator) {
            ((ObjectIterator)iter).close();
        }
    }

    public ObjectIterator(CloseableIteration<? extends S, ?> delegate) {
        this.delegate = delegate;
        try {
            if (!this.hasNext()) {
                this.close();
            }
        }
        catch (RuntimeException e) {
            this.close();
            throw e;
        }
    }

    @Override
    public boolean hasNext() {
        try {
            return this.next != null || (this.next = this.delegateNext()) != null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ObjectStoreException(e);
        }
    }

    @Override
    public E next() {
        try {
            this.element = this.delegateNext();
            S next = this.element;
            if (next == null) {
                this.close();
                return null;
            }
            if (!this.hasNext()) {
                this.close();
            }
            return this.convert(next);
        }
        catch (Exception e) {
            throw new ObjectStoreException(e);
        }
    }

    @Override
    public void remove() {
        try {
            this.remove(this.element);
        }
        catch (RepositoryException e) {
            throw new ObjectPersistException((Exception)((Object)e));
        }
    }

    public void close() {
        try {
            this.delegate.close();
        }
        catch (Exception e) {
            throw new ObjectStoreException(e);
        }
    }

    public E singleResult() throws RepositoryException {
        try {
            E next = this.next();
            if (next == null) {
                throw new NoObjectResultException("No result");
            }
            if (this.next() != null) {
                throw new MultipleObjectResultException("More than one result");
            }
            E e = next;
            return e;
        }
        finally {
            this.close();
        }
    }

    public List<E> asList() throws RepositoryException {
        return this.addTo(new ArrayList());
    }

    public Set<E> asSet() throws RepositoryException {
        return this.addTo(new HashSet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <C extends Collection<? super E>> C addTo(C collection) throws RepositoryException {
        try {
            E next;
            while ((next = this.next()) != null) {
                collection.add(next);
            }
            C c = collection;
            return c;
        }
        finally {
            this.close();
        }
    }

    protected E convert(S element) throws RepositoryException {
        return (E)element;
    }

    protected void remove(S element) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    private S delegateNext() throws Exception {
        S result = this.next;
        if (result == null && this.delegate.hasNext()) {
            return (S)this.delegate.next();
        }
        this.next = null;
        return result;
    }
}

