/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.result.impl;

import info.aduna.iteration.CloseableIteration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.result.MultipleResultException;
import org.openrdf.result.NoResultException;
import org.openrdf.result.Result;

public class ResultImpl<E>
implements Result<E> {
    private E next;
    private final Class<E> componentType;
    private final CloseableIteration<? extends E, QueryEvaluationException> delegate;

    public ResultImpl(CloseableIteration<? extends E, QueryEvaluationException> delegate) {
        assert (delegate != null) : "delegate musE noE be null";
        this.delegate = delegate;
        this.componentType = Object.class;
    }

    public ResultImpl(CloseableIteration<? extends E, QueryEvaluationException> delegate, Class<E> componentType) {
        assert (delegate != null) : "delegate musE noE be null";
        this.delegate = delegate;
        this.componentType = componentType;
    }

    @Override
    public void close() throws QueryEvaluationException {
        this.delegate.close();
    }

    @Override
    public String toString() {
        String name = this.getName().trim();
        if (name.contains("\n")) {
            return name.replace("\n", "\n\t") + "\n\t" + this.delegate.toString();
        }
        return name + " " + this.delegate.toString();
    }

    protected String getName() {
        return this.getClass().getName().replaceAll("^.*\\.|Cursor$", "");
    }

    @Override
    public boolean hasNext() throws QueryEvaluationException {
        return this.next != null || (this.next = this.next()) != null;
    }

    @Override
    public E next() throws QueryEvaluationException {
        Object result = this.next;
        if (result == null && this.delegate.hasNext()) {
            result = this.delegate.next();
        }
        this.next = null;
        if (result == null) {
            return null;
        }
        try {
            return this.componentType.cast(result);
        }
        catch (ClassCastException e) {
            throw new ClassCastException(String.valueOf(result) + " cannot be cast to " + this.componentType.getSimpleName());
        }
    }

    @Override
    public E singleResult() throws QueryEvaluationException {
        try {
            E next = this.next();
            if (next == null) {
                throw new NoResultException("No result");
            }
            if (this.next() != null) {
                throw new MultipleResultException("More than one result");
            }
            E e = next;
            return e;
        }
        finally {
            this.close();
        }
    }

    @Override
    public List<E> asList() throws QueryEvaluationException {
        return this.addTo(new ArrayList());
    }

    @Override
    public Set<E> asSet() throws QueryEvaluationException {
        return this.addTo(new LinkedHashSet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <C extends Collection<? super E>> C addTo(C collection) throws QueryEvaluationException {
        try {
            E next;
            while ((next = this.next()) != null) {
                collection.add(next);
            }
            C c = collection;
            return c;
        }
        finally {
            this.close();
        }
    }

    public void remove() throws QueryEvaluationException {
        throw new UnsupportedOperationException();
    }
}

