/*
 * Decompiled with CFR 0.152.
 */
package org.portletfaces.bridge;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.faces.FacesException;
import javax.portlet.PortletConfig;
import org.portletfaces.bridge.BridgeException;

public abstract class BridgeFactoryFinder {
    public static final String BRIDGE_CONFIG_FACTORY = "org.portletfaces.bridge.config.BridgeConfigFactory";
    public static final String BRIDGE_CONTEXT_FACTORY = "org.portletfaces.bridge.context.BridgeContextFactory";
    public static final String BRIDGE_FACTORY = "org.portletfaces.bridge.BridgeFactory";
    public static final String BRIDGE_NAVIGATION_HANDLER_FACTORY = "org.portletfaces.bridge.application.BridgeNavigationHandlerFactory";
    public static final String BRIDGE_REQUEST_SCOPE_FACTORY = "org.portletfaces.bridge.scope.BridgeRequestScopeFactory";
    public static final String BRIDGE_REQUEST_SCOPE_MANAGER_FACTORY = "org.portletfaces.bridge.scope.BridgeRequestScopeManagerFactory";
    public static final String PORTLET_CONTAINER_FACTORY = "org.portletfaces.bridge.container.PortletContainerFactory";
    private static BridgeFactoryFinder staticInstance;
    private static PortletConfig staticPortletConfig;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getClassPathResourceAsString(String resourcePath) {
        InputStream inputStream;
        String classPathResourceAsString = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null && (inputStream = classLoader.getResourceAsStream(resourcePath)) != null) {
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            try {
                classPathResourceAsString = bufferedReader.readLine();
            }
            catch (IOException e) {
                System.err.println("Unable to read contents of resourcePath=[" + resourcePath + "]");
            }
            finally {
                try {
                    bufferedReader.close();
                    inputStreamReader.close();
                    inputStream.close();
                }
                catch (IOException e) {}
            }
        }
        return classPathResourceAsString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BridgeFactoryFinder getInstance() {
        if (staticInstance == null) {
            if (staticPortletConfig == null) {
                throw new BridgeException("Must first call setPortletContext(PortletContext)");
            }
            PortletConfig portletConfig = staticPortletConfig;
            synchronized (portletConfig) {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                try {
                    String bridgeFactoryFinderService = "META-INF/services/javax.portlet.faces.BridgeFactoryFinder";
                    String bridgeFactoryFinderClassName = BridgeFactoryFinder.getClassPathResourceAsString(bridgeFactoryFinderService);
                    if (bridgeFactoryFinderClassName == null) {
                        throw new BridgeException("Unable to load resource=[" + bridgeFactoryFinderService + "]");
                    }
                    Class<?> bridgeFactoryFinderClass = classLoader.loadClass(bridgeFactoryFinderClassName);
                    staticInstance = (BridgeFactoryFinder)bridgeFactoryFinderClass.newInstance();
                    staticInstance.init(staticPortletConfig);
                }
                catch (Exception e) {
                    throw new BridgeException(e);
                }
            }
        }
        return staticInstance;
    }

    public static PortletConfig getPortletConfig() {
        return staticPortletConfig;
    }

    public static synchronized void setPortletConfig(PortletConfig portletConfig) {
        staticPortletConfig = portletConfig;
    }

    public abstract void init(PortletConfig var1);

    public abstract Object getFactory(String var1) throws FacesException;
}

