/*
 * Decompiled with CFR 0.152.
 */
package org.portletfaces.bridge;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.faces.FacesException;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import org.portletfaces.bridge.Bridge;
import org.portletfaces.bridge.BridgeFactory;
import org.portletfaces.bridge.BridgeImpl;

public class BridgeFactoryImpl
extends BridgeFactory {
    private String bridgeClassName;
    private BridgeFactory wrappedBridgeFactory;

    public BridgeFactoryImpl() {
    }

    public BridgeFactoryImpl(BridgeFactory bridgeFactory) {
        this.wrappedBridgeFactory = bridgeFactory;
    }

    public Bridge getBridge(PortletContext portletContext) throws FacesException {
        try {
            String bridgeClassName;
            Bridge bridge = null;
            if (this.wrappedBridgeFactory != null) {
                bridge = this.wrappedBridgeFactory.getBridge(portletContext);
            }
            if (bridge == null && (bridgeClassName = this.getBridgeClassName(portletContext)) != null) {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                try {
                    Class<?> bridgeClass = classLoader.loadClass(bridgeClassName);
                    bridge = (Bridge)bridgeClass.newInstance();
                }
                catch (Exception e) {
                    throw new PortletException((Throwable)e);
                }
            }
            return bridge;
        }
        catch (Exception e) {
            throw new FacesException((Throwable)e);
        }
    }

    public String getBridgeClassName(PortletContext portletContext) throws FacesException {
        try {
            if (this.bridgeClassName == null) {
                if (this.wrappedBridgeFactory != null) {
                    this.bridgeClassName = this.wrappedBridgeFactory.getBridgeClassName(portletContext);
                }
                if (this.bridgeClassName == null) {
                    this.bridgeClassName = portletContext.getInitParameter("javax.portlet.faces.BridgeImplClass");
                    if (this.bridgeClassName == null) {
                        this.bridgeClassName = this.getClassPathResourceAsString("META-INF/services/javax.portlet.faces.Bridge");
                    }
                    if (this.bridgeClassName == null) {
                        this.bridgeClassName = BridgeImpl.class.getCanonicalName();
                    }
                }
            }
            return this.bridgeClassName;
        }
        catch (Exception e) {
            throw new FacesException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getClassPathResourceAsString(String resourcePath) {
        InputStream inputStream;
        String classPathResourceAsString = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null && (inputStream = classLoader.getResourceAsStream(resourcePath)) != null) {
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            try {
                classPathResourceAsString = bufferedReader.readLine();
            }
            catch (IOException e) {
                System.err.println("Unable to read contents of resourcePath=[" + resourcePath + "]");
            }
            finally {
                try {
                    bufferedReader.close();
                    inputStreamReader.close();
                    inputStream.close();
                }
                catch (IOException e) {}
            }
        }
        return classPathResourceAsString;
    }

    public BridgeFactory getWrapped() {
        return this.wrappedBridgeFactory;
    }
}

