/*
 * Decompiled with CFR 0.152.
 */
package org.portletfaces.bridge;

import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.NavigationHandler;
import javax.faces.application.ResourceHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.ExternalContextWrapper;
import javax.faces.context.FacesContext;
import javax.faces.context.FacesContextFactory;
import javax.faces.event.PhaseListener;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.portletfaces.bridge.Bridge;
import org.portletfaces.bridge.BridgeDefaultViewNotSpecifiedException;
import org.portletfaces.bridge.BridgeEventHandler;
import org.portletfaces.bridge.BridgeException;
import org.portletfaces.bridge.BridgeFactoryFinder;
import org.portletfaces.bridge.BridgeUninitializedException;
import org.portletfaces.bridge.annotation.PortletNamingContainer;
import org.portletfaces.bridge.application.BridgeNavigationHandler;
import org.portletfaces.bridge.config.BridgeConfig;
import org.portletfaces.bridge.config.BridgeConfigFactory;
import org.portletfaces.bridge.context.BridgeContext;
import org.portletfaces.bridge.context.BridgeContextFactory;
import org.portletfaces.bridge.context.ExternalContextImpl;
import org.portletfaces.bridge.context.flash.BridgeFlash;
import org.portletfaces.bridge.event.EventNavigationResult;
import org.portletfaces.bridge.event.IPCPhaseListener;
import org.portletfaces.bridge.event.ManagedBeanScopePhaseListener;
import org.portletfaces.bridge.event.RenderRequestPhaseListener;
import org.portletfaces.bridge.lifecycle.LifecycleIncongruityManager;
import org.portletfaces.bridge.lifecycle.LifecycleIncongruityMap;
import org.portletfaces.bridge.scope.BridgeRequestScope;
import org.portletfaces.bridge.scope.BridgeRequestScopeManager;
import org.portletfaces.bridge.scope.BridgeRequestScopeManagerFactory;
import org.portletfaces.logging.Logger;
import org.portletfaces.logging.LoggerFactory;

public class BridgeImpl
implements Bridge {
    private static final Logger logger = LoggerFactory.getLogger(BridgeImpl.class);
    public static final String REQ_ATTR_PORTLET_LIFECYCLE_PHASE = "org.portletfaces.bridge.portletLifecyclePhase";
    private BridgeRequestScopeManagerFactory bridgeRequestScopeManagerFactory;
    private boolean initialized = false;
    private BridgeConfig bridgeConfig;
    private BridgeContextFactory bridgeContextFactory;
    private FacesContextFactory facesContextFactory;
    private Lifecycle facesLifecycle;
    private String facesLifecycleId;
    private PortletConfig portletConfig;
    private PortletContext portletContext;
    private String portletName;

    public void destroy() {
        logger.trace("destroy this=[{0}]", this);
    }

    public void doFacesRequest(ActionRequest actionRequest, ActionResponse actionResponse) throws BridgeDefaultViewNotSpecifiedException, BridgeUninitializedException, BridgeException {
        block9: {
            block8: {
                BridgeRequestScope bridgeRequestScope;
                BridgeRequestScopeManager bridgeRequestScopeManager;
                BridgeContext bridgeContext;
                block7: {
                    logger.debug("doFacesRequest(ActionRequest, ActionResponse) portletName=[{0}] this=[{1}]", this.portletName, this);
                    if (!this.isInitialized()) break block8;
                    FacesContext facesContext = null;
                    bridgeContext = null;
                    bridgeRequestScopeManager = this.bridgeRequestScopeManagerFactory.getBridgeRequestScopeManager();
                    bridgeRequestScope = null;
                    try {
                        bridgeContext = this.createBridgeContext((PortletRequest)actionRequest, (PortletResponse)actionResponse, Bridge.PortletPhase.ACTION_PHASE);
                        actionRequest.setAttribute("javax.portlet.faces.bridgeContext", (Object)bridgeContext);
                        facesContext = this.getFacesContext((PortletRequest)actionRequest, (PortletResponse)actionResponse);
                        facesContext.getAttributes().put("javax.portlet.faces.bridgeContext", bridgeContext);
                        actionRequest.setAttribute(REQ_ATTR_PORTLET_LIFECYCLE_PHASE, (Object)Bridge.PortletPhase.ACTION_PHASE);
                        bridgeRequestScope = bridgeRequestScopeManager.getBridgeRequestScope(bridgeContext);
                        bridgeRequestScope.setPortletMode(actionRequest.getPortletMode());
                        IPCPhaseListener ipcPhaseListener = new IPCPhaseListener(this.bridgeConfig, this.portletContext, this.portletName, (PortletRequest)actionRequest, (PortletResponse)actionResponse);
                        this.facesLifecycle.addPhaseListener((PhaseListener)ipcPhaseListener);
                        this.facesLifecycle.execute(facesContext);
                        this.facesLifecycle.removePhaseListener((PhaseListener)ipcPhaseListener);
                        bridgeRequestScope.preserveScopedData(facesContext);
                        bridgeRequestScope.setFlash(facesContext.getExternalContext().getFlash());
                        this.indicateNamespacingToConsumers(facesContext.getViewRoot(), (PortletResponse)actionResponse);
                        actionRequest.removeAttribute("javax.portlet.faces.bridgeContext");
                        actionRequest.removeAttribute(REQ_ATTR_PORTLET_LIFECYCLE_PHASE);
                        if (facesContext == null) break block7;
                    }
                    catch (Exception e) {
                        try {
                            throw new BridgeException(e);
                        }
                        catch (Throwable throwable) {
                            if (facesContext != null) {
                                facesContext.release();
                            }
                            if (bridgeRequestScope != null) {
                                bridgeRequestScopeManager.removeBridgeRequestScope(bridgeRequestScope, bridgeContext);
                            }
                            throw throwable;
                        }
                    }
                    facesContext.release();
                }
                if (bridgeRequestScope != null) {
                    bridgeRequestScopeManager.removeBridgeRequestScope(bridgeRequestScope, bridgeContext);
                }
                break block9;
            }
            throw new BridgeUninitializedException();
        }
    }

    public void doFacesRequest(EventRequest eventRequest, EventResponse eventResponse) throws BridgeUninitializedException, BridgeException {
        block11: {
            block10: {
                BridgeRequestScope bridgeRequestScope;
                BridgeRequestScopeManager bridgeRequestScopeManager;
                BridgeContext bridgeContext;
                block9: {
                    logger.debug("doFacesRequest(EventRequest, EventResponse) portletName=[{0}] this=[{1}]", this.portletName, this);
                    if (!this.isInitialized()) break block10;
                    FacesContext facesContext = null;
                    bridgeContext = null;
                    bridgeRequestScopeManager = this.bridgeRequestScopeManagerFactory.getBridgeRequestScopeManager();
                    bridgeRequestScope = null;
                    try {
                        bridgeContext = this.createBridgeContext((PortletRequest)eventRequest, (PortletResponse)eventResponse, Bridge.PortletPhase.EVENT_PHASE);
                        eventRequest.setAttribute("javax.portlet.faces.bridgeContext", (Object)bridgeContext);
                        facesContext = this.getFacesContext((PortletRequest)eventRequest, (PortletResponse)eventResponse);
                        facesContext.getAttributes().put("javax.portlet.faces.bridgeContext", bridgeContext);
                        eventRequest.setAttribute(REQ_ATTR_PORTLET_LIFECYCLE_PHASE, (Object)Bridge.PortletPhase.EVENT_PHASE);
                        bridgeRequestScopeManager = this.bridgeRequestScopeManagerFactory.getBridgeRequestScopeManager();
                        bridgeRequestScope = bridgeRequestScopeManager.getBridgeRequestScope(bridgeContext);
                        bridgeRequestScope.setPortletMode(eventRequest.getPortletMode());
                        IPCPhaseListener ipcPhaseListener = new IPCPhaseListener(this.bridgeConfig, this.portletContext, this.portletName, (PortletRequest)eventRequest, (PortletResponse)eventResponse);
                        this.facesLifecycle.addPhaseListener((PhaseListener)ipcPhaseListener);
                        this.facesLifecycle.execute(facesContext);
                        this.facesLifecycle.removePhaseListener((PhaseListener)ipcPhaseListener);
                        String bridgeEventHandlerAttributeName = "javax.portlet.faces." + this.portletName + "." + "bridgeEventHandler";
                        BridgeEventHandler bridgeEventHandler = (BridgeEventHandler)this.portletContext.getAttribute(bridgeEventHandlerAttributeName);
                        if (bridgeEventHandler != null) {
                            logger.debug("Invoking {0} for class=[{1}]", bridgeEventHandlerAttributeName, bridgeEventHandler.getClass());
                            EventNavigationResult eventNavigationResult = bridgeEventHandler.handleEvent(facesContext, eventRequest.getEvent());
                            if (eventNavigationResult != null) {
                                String fromAction = eventNavigationResult.getFromAction();
                                String outcome = eventNavigationResult.getOutcome();
                                logger.debug("Invoking navigationHandler fromAction=[{0}] outcome=[{1}]", fromAction, outcome);
                                NavigationHandler navigationHandler = facesContext.getApplication().getNavigationHandler();
                                navigationHandler.handleNavigation(facesContext, fromAction, outcome);
                            }
                        }
                        bridgeRequestScope.preserveScopedData(facesContext);
                        bridgeRequestScope.setFlash(facesContext.getExternalContext().getFlash());
                        this.indicateNamespacingToConsumers(facesContext.getViewRoot(), (PortletResponse)eventResponse);
                        eventRequest.removeAttribute("javax.portlet.faces.bridgeContext");
                        eventRequest.removeAttribute(REQ_ATTR_PORTLET_LIFECYCLE_PHASE);
                        if (facesContext == null) break block9;
                    }
                    catch (Exception e) {
                        try {
                            throw new BridgeException(e);
                        }
                        catch (Throwable throwable) {
                            if (facesContext != null) {
                                facesContext.release();
                            }
                            if (bridgeRequestScope != null) {
                                bridgeRequestScopeManager.removeBridgeRequestScope(bridgeRequestScope, bridgeContext);
                            }
                            throw throwable;
                        }
                    }
                    facesContext.release();
                }
                if (bridgeRequestScope != null) {
                    bridgeRequestScopeManager.removeBridgeRequestScope(bridgeRequestScope, bridgeContext);
                }
                break block11;
            }
            throw new BridgeUninitializedException();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doFacesRequest(RenderRequest renderRequest, RenderResponse renderResponse) throws BridgeDefaultViewNotSpecifiedException, BridgeUninitializedException, BridgeException {
        BridgeRequestScope bridgeRequestScope;
        BridgeRequestScopeManager bridgeRequestScopeManager;
        BridgeContext bridgeContext;
        block14: {
            logger.debug("doFacesRequest(RenderRequest, RenderResponse) portletName=[{0}] portletMode=[{1}] this=[{2}]", this.portletName, renderRequest.getPortletMode(), this);
            if (!this.isInitialized()) throw new BridgeUninitializedException();
            Object renderPartAttribute = renderRequest.getAttribute("javax.portlet.render_part");
            if (renderPartAttribute != null && renderPartAttribute.equals("RENDER_HEADERS")) {
                this.doFacesHeaders(renderRequest, renderResponse);
                return;
            }
            FacesContext facesContext = null;
            bridgeContext = null;
            bridgeRequestScopeManager = this.bridgeRequestScopeManagerFactory.getBridgeRequestScopeManager();
            bridgeRequestScope = null;
            try {
                BridgeFlash bridgeFlash;
                String toPortletModeAsString;
                String fromPortletModeAsString;
                bridgeContext = this.createBridgeContext((PortletRequest)renderRequest, (PortletResponse)renderResponse, Bridge.PortletPhase.RENDER_PHASE);
                renderRequest.setAttribute("javax.portlet.faces.bridgeContext", (Object)bridgeContext);
                facesContext = this.getFacesContext((PortletRequest)renderRequest, (PortletResponse)renderResponse);
                facesContext.getAttributes().put("javax.portlet.faces.bridgeContext", bridgeContext);
                renderRequest.setAttribute(REQ_ATTR_PORTLET_LIFECYCLE_PHASE, (Object)Bridge.PortletPhase.RENDER_PHASE);
                bridgeRequestScopeManager = this.bridgeRequestScopeManagerFactory.getBridgeRequestScopeManager();
                bridgeRequestScope = bridgeRequestScopeManager.getBridgeRequestScope(bridgeContext);
                boolean facesLifecycleAlreadyExecuted = false;
                PortletMode fromPortletMode = bridgeRequestScope.getPortletMode();
                PortletMode toPortletMode = renderRequest.getPortletMode();
                if (fromPortletMode != null && toPortletMode != null && (fromPortletModeAsString = fromPortletMode.toString()).equals(toPortletModeAsString = toPortletMode.toString())) {
                    facesLifecycleAlreadyExecuted = bridgeRequestScope.restoreScopedData(facesContext);
                }
                if ((bridgeFlash = (BridgeFlash)bridgeRequestScope.getFlash()) != null) {
                    ExternalContext externalContext = facesContext.getExternalContext();
                    while (externalContext instanceof ExternalContextWrapper) {
                        ExternalContextWrapper externalContextWrapper = (ExternalContextWrapper)externalContext;
                        externalContext = externalContextWrapper.getWrapped();
                    }
                    if (externalContext instanceof ExternalContextImpl) {
                        ExternalContextImpl externalContextImpl = (ExternalContextImpl)externalContext;
                        externalContextImpl.setBridgeFlash(bridgeFlash);
                    } else {
                        logger.error("Unable to get access to the bridge ExternalContextImpl");
                    }
                }
                if (facesContext.isPostback()) {
                    facesContext.getExternalContext().getRequestMap().put("javax.portlet.faces.isPostback", Boolean.TRUE);
                }
                logger.debug("portletName=[{0}] facesLifecycleAlreadyExecuted=[{1}]", this.portletName, facesLifecycleAlreadyExecuted);
                if (!facesLifecycleAlreadyExecuted) {
                    IPCPhaseListener ipcPhaseListener = new IPCPhaseListener(this.bridgeConfig, this.portletContext, this.portletName, (PortletRequest)renderRequest, (PortletResponse)renderResponse);
                    RenderRequestPhaseListener renderRequestPhaseListener = new RenderRequestPhaseListener();
                    this.facesLifecycle.addPhaseListener((PhaseListener)ipcPhaseListener);
                    this.facesLifecycle.addPhaseListener((PhaseListener)renderRequestPhaseListener);
                    logger.debug("Executing Faces lifecycle");
                    this.facesLifecycle.execute(facesContext);
                    this.facesLifecycle.removePhaseListener((PhaseListener)ipcPhaseListener);
                    this.facesLifecycle.removePhaseListener((PhaseListener)renderRequestPhaseListener);
                }
                BridgeNavigationHandler bridgeNavigationHandler = (BridgeNavigationHandler)facesContext.getApplication().getNavigationHandler();
                bridgeNavigationHandler.handleNavigation(facesContext, fromPortletMode, toPortletMode);
                ExternalContext externalContext = facesContext.getExternalContext();
                LifecycleIncongruityMap lifecycleIncongruityMap = new LifecycleIncongruityMap(externalContext.getRequestMap());
                LifecycleIncongruityManager lifecycleIncongruityManager = new LifecycleIncongruityManager(lifecycleIncongruityMap);
                lifecycleIncongruityManager.makeCongruous(externalContext);
                ManagedBeanScopePhaseListener managedBeanScopePhaseListener = new ManagedBeanScopePhaseListener();
                this.facesLifecycle.addPhaseListener((PhaseListener)managedBeanScopePhaseListener);
                logger.debug("Executing Faces render");
                this.facesLifecycle.render(facesContext);
                this.facesLifecycle.removePhaseListener((PhaseListener)managedBeanScopePhaseListener);
                this.indicateNamespacingToConsumers(facesContext.getViewRoot(), (PortletResponse)renderResponse);
                if (!bridgeContext.isBridgeRequestScopePreserved()) {
                    bridgeRequestScopeManager.removeBridgeRequestScope(bridgeRequestScope, bridgeContext);
                }
                renderRequest.removeAttribute("javax.portlet.faces.bridgeContext");
                renderRequest.removeAttribute(REQ_ATTR_PORTLET_LIFECYCLE_PHASE);
                if (facesContext == null) break block14;
            }
            catch (Exception e) {
                try {
                    throw new BridgeException(e);
                }
                catch (Throwable throwable) {
                    if (facesContext != null) {
                        facesContext.release();
                    }
                    if (bridgeRequestScope == null) throw throwable;
                    bridgeRequestScopeManager.removeBridgeRequestScope(bridgeRequestScope, bridgeContext);
                    throw throwable;
                }
            }
            facesContext.release();
        }
        if (bridgeRequestScope == null) return;
        bridgeRequestScopeManager.removeBridgeRequestScope(bridgeRequestScope, bridgeContext);
        return;
    }

    public void doFacesRequest(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws BridgeUninitializedException, BridgeException {
        logger.debug("doFacesRequest(ResourceRequest, ResourceResponse) portletName=[{0}], this=[{1}]", this.portletName, this);
        if (this.isInitialized()) {
            FacesContext facesContext = null;
            try {
                BridgeContext bridgeContext = this.createBridgeContext((PortletRequest)resourceRequest, (PortletResponse)resourceResponse, Bridge.PortletPhase.RESOURCE_PHASE);
                resourceRequest.setAttribute("javax.portlet.faces.bridgeContext", (Object)bridgeContext);
                facesContext = this.getFacesContext((PortletRequest)resourceRequest, (PortletResponse)resourceResponse);
                facesContext.getAttributes().put("javax.portlet.faces.bridgeContext", bridgeContext);
                resourceRequest.setAttribute(REQ_ATTR_PORTLET_LIFECYCLE_PHASE, (Object)Bridge.PortletPhase.RESOURCE_PHASE);
                ResourceHandler resourceHandler = facesContext.getApplication().getResourceHandler();
                if (resourceHandler.isResourceRequest(facesContext)) {
                    logger.debug("Detected file ResourceRequest -- not running Faces lifecycle");
                    resourceHandler.handleResourceRequest(facesContext);
                } else {
                    logger.debug("Detected Ajax ResourceRequest -- running Faces lifecycle");
                    IPCPhaseListener ipcPhaseListener = new IPCPhaseListener(this.bridgeConfig, this.portletContext, this.portletName, (PortletRequest)resourceRequest, (PortletResponse)resourceResponse);
                    this.facesLifecycle.addPhaseListener((PhaseListener)ipcPhaseListener);
                    this.facesLifecycle.execute(facesContext);
                    this.facesLifecycle.removePhaseListener((PhaseListener)ipcPhaseListener);
                    ManagedBeanScopePhaseListener managedBeanScopePhaseListener = new ManagedBeanScopePhaseListener();
                    this.facesLifecycle.addPhaseListener((PhaseListener)managedBeanScopePhaseListener);
                    this.facesLifecycle.render(facesContext);
                    this.facesLifecycle.removePhaseListener((PhaseListener)managedBeanScopePhaseListener);
                    this.indicateNamespacingToConsumers(facesContext.getViewRoot(), (PortletResponse)resourceResponse);
                }
                resourceRequest.removeAttribute("javax.portlet.faces.bridgeContext");
                resourceRequest.removeAttribute(REQ_ATTR_PORTLET_LIFECYCLE_PHASE);
            }
            catch (Exception e) {
                throw new BridgeException(e);
            }
            finally {
                if (facesContext != null) {
                    facesContext.release();
                }
            }
        } else {
            throw new BridgeUninitializedException();
        }
    }

    public void init(PortletConfig portletConfig) throws BridgeException {
        logger.trace("init(PortletConfig) this=[{0}]", this);
        this.initialized = true;
        this.portletConfig = portletConfig;
        this.portletContext = portletConfig.getPortletContext();
        this.portletName = portletConfig.getPortletName();
        BridgeFactoryFinder.setPortletConfig(portletConfig);
        BridgeFactoryFinder bridgeFactoryFinder = BridgeFactoryFinder.getInstance();
        BridgeConfigFactory bridgeConfigFactory = (BridgeConfigFactory)bridgeFactoryFinder.getFactory("org.portletfaces.bridge.config.BridgeConfigFactory");
        this.bridgeConfig = bridgeConfigFactory.getBridgeConfig();
        this.bridgeContextFactory = (BridgeContextFactory)bridgeFactoryFinder.getFactory("org.portletfaces.bridge.context.BridgeContextFactory");
        this.bridgeRequestScopeManagerFactory = (BridgeRequestScopeManagerFactory)BridgeFactoryFinder.getInstance().getFactory("org.portletfaces.bridge.scope.BridgeRequestScopeManagerFactory");
    }

    protected BridgeContext createBridgeContext(PortletRequest portletRequest, PortletResponse portletResponse, Bridge.PortletPhase portletPhase) {
        BridgeContext bridgeContext = this.bridgeContextFactory.getBridgeContext();
        bridgeContext.setBridgeConfig(this.bridgeConfig);
        bridgeContext.setPortletConfig(this.portletConfig);
        bridgeContext.setPortletContext(this.portletContext);
        bridgeContext.setPortletRequest(portletRequest);
        bridgeContext.setPortletRequestPhase(portletPhase);
        bridgeContext.setPortletResponse(portletResponse);
        return bridgeContext;
    }

    protected void doFacesHeaders(RenderRequest renderRequest, RenderResponse renderResponse) {
        logger.trace("doFacesHeaders(RenderRequest, RenderResponse) this=[{0}]", this);
    }

    protected void indicateNamespacingToConsumers(UIViewRoot uiViewRoot, PortletResponse portletResponse) {
        if (uiViewRoot != null) {
            if (uiViewRoot.getClass().getAnnotation(PortletNamingContainer.class) != null) {
                portletResponse.addProperty("X-JAVAX-PORTLET-FACES-NAMESPACED-RESPONSE", Boolean.TRUE.toString());
            }
        } else {
            logger.debug("UIViewRoot is null -- might be push related");
        }
    }

    protected boolean isInitialized() {
        return this.initialized;
    }

    protected FacesContext getFacesContext(PortletRequest portletRequest, PortletResponse portletResponse) throws FacesException {
        return this.getFacesContextFactory().getFacesContext((Object)this.portletContext, (Object)portletRequest, (Object)portletResponse, this.getFacesLifecycle());
    }

    protected FacesContextFactory getFacesContextFactory() throws FacesException {
        if (this.facesContextFactory == null) {
            this.facesContextFactory = (FacesContextFactory)FactoryFinder.getFactory((String)"javax.faces.context.FacesContextFactory");
        }
        return this.facesContextFactory;
    }

    protected Lifecycle getFacesLifecycle() throws FacesException {
        if (this.facesLifecycle == null) {
            LifecycleFactory lifecycleFactory = (LifecycleFactory)FactoryFinder.getFactory((String)"javax.faces.lifecycle.LifecycleFactory");
            this.facesLifecycle = lifecycleFactory.getLifecycle(this.getFacesLifecycleId());
        }
        return this.facesLifecycle;
    }

    protected String getFacesLifecycleId() {
        if (this.facesLifecycleId == null) {
            this.facesLifecycleId = this.portletContext.getInitParameter("javax.faces.LIFECYCLE_ID");
            if (this.facesLifecycleId == null) {
                this.facesLifecycleId = "DEFAULT";
            }
        }
        return this.facesLifecycleId;
    }
}

