/*
 * Decompiled with CFR 0.152.
 */
package org.portletfaces.bridge;

import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.portletfaces.bridge.Bridge;
import org.portletfaces.bridge.BridgeEventHandler;
import org.portletfaces.bridge.BridgeFactory;
import org.portletfaces.bridge.BridgeFactoryFinder;
import org.portletfaces.bridge.BridgePublicRenderParameterHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericFacesPortlet
extends GenericPortlet {
    public static final String BRIDGE_CLASS = "javax.portlet.faces.BridgeImplClass";
    public static final String BRIDGE_SERVICE_CLASSPATH = "META-INF/services/javax.portlet.faces.Bridge";
    public static final String DEFAULT_VIEWID = "javax.portlet.faces.defaultViewId";
    private Bridge bridge;
    private BridgeEventHandler bridgeEventHandler;
    private BridgePublicRenderParameterHandler bridgePublicRenderParameterHandler;
    private Map<String, String> defaultViewIdMap;
    private PortletConfig portletConfig;

    public void destroy() {
        super.destroy();
    }

    public void init(PortletConfig portletConfig) throws PortletException {
        BridgePublicRenderParameterHandler bridgePublicRenderParameterHandlerInstance;
        this.portletConfig = portletConfig;
        super.init(portletConfig);
        this.getFacesBridge().init(portletConfig);
        String portletName = portletConfig.getPortletName();
        PortletContext portletContext = portletConfig.getPortletContext();
        String attrNameDefaultViewIdMap = "javax.portlet.faces." + portletName + "." + "javax.portlet.faces.defaultViewIdMap";
        portletContext.setAttribute(attrNameDefaultViewIdMap, this.getDefaultViewIdMap());
        BridgeEventHandler bridgeEventHandlerInstance = this.getBridgeEventHandler();
        if (bridgeEventHandlerInstance != null) {
            String bridgeEventHandlerAttributeName = "javax.portlet.faces." + portletConfig.getPortletName() + "." + "bridgeEventHandler";
            portletContext.setAttribute(bridgeEventHandlerAttributeName, (Object)bridgeEventHandlerInstance);
        }
        if ((bridgePublicRenderParameterHandlerInstance = this.getBridgePublicRenderParameterHandler()) != null) {
            String bridgeEventHandlerAttributeName = "javax.portlet.faces." + portletConfig.getPortletName() + "." + "bridgePublicRenderParameterHandler";
            portletContext.setAttribute(bridgeEventHandlerAttributeName, (Object)bridgePublicRenderParameterHandlerInstance);
        }
    }

    public void processAction(ActionRequest actionRequest, ActionResponse actionResponse) throws PortletException, IOException {
        Bridge facesBridge = this.getFacesBridge((PortletRequest)actionRequest, (PortletResponse)actionResponse);
        facesBridge.doFacesRequest(actionRequest, actionResponse);
    }

    public void processEvent(EventRequest eventRequest, EventResponse eventResponse) throws PortletException, IOException {
        super.processEvent(eventRequest, eventResponse);
        Bridge facesBridge = this.getFacesBridge((PortletRequest)eventRequest, (PortletResponse)eventResponse);
        facesBridge.doFacesRequest(eventRequest, eventResponse);
    }

    public void serveResource(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws PortletException, IOException {
        Bridge facesBridge = this.getFacesBridge((PortletRequest)resourceRequest, (PortletResponse)resourceResponse);
        facesBridge.doFacesRequest(resourceRequest, resourceResponse);
    }

    protected void doEdit(RenderRequest renderRequest, RenderResponse renderResponse) throws PortletException, IOException {
        Bridge facesBridge = this.getFacesBridge((PortletRequest)renderRequest, (PortletResponse)renderResponse);
        facesBridge.doFacesRequest(renderRequest, renderResponse);
    }

    protected void doHeaders(RenderRequest renderRequest, RenderResponse renderResponse) {
        try {
            Object renderPartAttribute = renderRequest.getAttribute("javax.portlet.render_part");
            if (renderPartAttribute != null && renderPartAttribute.equals("RENDER_HEADERS")) {
                Bridge facesBridge = this.getFacesBridge((PortletRequest)renderRequest, (PortletResponse)renderResponse);
                facesBridge.doFacesRequest(renderRequest, renderResponse);
            }
        }
        catch (PortletException e) {
            e.printStackTrace();
        }
    }

    protected void doHelp(RenderRequest renderRequest, RenderResponse renderResponse) throws PortletException, IOException {
        Bridge facesBridge = this.getFacesBridge((PortletRequest)renderRequest, (PortletResponse)renderResponse);
        facesBridge.doFacesRequest(renderRequest, renderResponse);
    }

    protected void doView(RenderRequest renderRequest, RenderResponse renderResponse) throws PortletException, IOException {
        Bridge facesBridge = this.getFacesBridge((PortletRequest)renderRequest, (PortletResponse)renderResponse);
        facesBridge.doFacesRequest(renderRequest, renderResponse);
    }

    public String getBridgeClassName() {
        PortletContext portletContext = this.portletConfig.getPortletContext();
        BridgeFactory bridgeFactory = (BridgeFactory)BridgeFactoryFinder.getInstance().getFactory("org.portletfaces.bridge.BridgeFactory");
        return bridgeFactory.getBridgeClassName(portletContext);
    }

    protected BridgeEventHandler getBridgeEventHandler() throws PortletException {
        String initParamName;
        String className;
        if (this.bridgeEventHandler == null && (className = this.portletConfig.getInitParameter(initParamName = "javax.portlet.faces.bridgeEventHandler")) != null) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            try {
                Class<?> clazz = classLoader.loadClass(className);
                this.bridgeEventHandler = (BridgeEventHandler)clazz.newInstance();
            }
            catch (Exception e) {
                throw new PortletException((Throwable)e);
            }
        }
        return this.bridgeEventHandler;
    }

    protected BridgePublicRenderParameterHandler getBridgePublicRenderParameterHandler() throws PortletException {
        String initParamName;
        String className;
        if (this.bridgePublicRenderParameterHandler == null && (className = this.portletConfig.getInitParameter(initParamName = "javax.portlet.faces.bridgePublicRenderParameterHandler")) != null) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            try {
                Class<?> clazz = classLoader.loadClass(className);
                this.bridgePublicRenderParameterHandler = (BridgePublicRenderParameterHandler)clazz.newInstance();
            }
            catch (Exception e) {
                throw new PortletException((Throwable)e);
            }
        }
        return this.bridgePublicRenderParameterHandler;
    }

    public Map<String, String> getDefaultViewIdMap() {
        if (this.defaultViewIdMap == null) {
            this.defaultViewIdMap = new HashMap<String, String>();
            Enumeration initParameterNames = this.portletConfig.getInitParameterNames();
            if (initParameterNames != null) {
                int defaultViewIdLength = DEFAULT_VIEWID.length();
                int portletModeIndex = defaultViewIdLength + 1;
                while (initParameterNames.hasMoreElements()) {
                    String initParameterName = (String)initParameterNames.nextElement();
                    if (initParameterName == null || !initParameterName.startsWith(DEFAULT_VIEWID) || initParameterName.length() <= defaultViewIdLength) continue;
                    String initParameterValue = this.portletConfig.getInitParameter(initParameterName);
                    String portletMode = initParameterName.substring(portletModeIndex);
                    this.defaultViewIdMap.put(portletMode, initParameterValue);
                }
            }
        }
        return this.defaultViewIdMap;
    }

    public Bridge getFacesBridge(PortletRequest portletRequest, PortletResponse portletResponse) throws PortletException {
        String viewId = portletRequest.getParameter("_jsfBridgeViewId");
        if (viewId != null) {
            portletRequest.setAttribute("javax.portlet.faces.viewId", (Object)viewId);
        } else {
            String viewPath = portletRequest.getParameter("_jsfBridgeViewPath");
            if (viewPath != null) {
                portletRequest.setAttribute("javax.portlet.faces.viewPath", (Object)viewPath);
            }
        }
        return this.getFacesBridge();
    }

    protected Bridge getFacesBridge() throws PortletException {
        if (this.bridge == null) {
            BridgeFactoryFinder.setPortletConfig(this.portletConfig);
            BridgeFactoryFinder bridgeFactoryFinder = BridgeFactoryFinder.getInstance();
            BridgeFactory bridgeFactory = (BridgeFactory)bridgeFactoryFinder.getFactory("org.portletfaces.bridge.BridgeFactory");
            PortletContext portletContext = this.portletConfig.getPortletContext();
            this.bridge = bridgeFactory.getBridge(portletContext);
        }
        return this.bridge;
    }

    @Deprecated
    public String getResponseCharacterSetEncoding(PortletRequest request) {
        return null;
    }

    @Deprecated
    public String getResponseContentType(PortletRequest request) {
        return request.getResponseContentType();
    }
}

