/*
 * Decompiled with CFR 0.152.
 */
package org.portletfaces.bridge.application;

import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.application.ConfigurableNavigationHandler;
import javax.faces.application.NavigationCase;
import javax.faces.application.NavigationHandler;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.context.PartialViewContext;
import javax.portlet.PortletMode;
import javax.portlet.PortletResponse;
import javax.portlet.StateAwareResponse;
import javax.portlet.WindowState;
import org.portletfaces.bridge.application.BridgeNavigationHandler;
import org.portletfaces.bridge.context.BridgeContext;
import org.portletfaces.logging.Logger;
import org.portletfaces.logging.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BridgeNavigationHandlerImpl
extends BridgeNavigationHandler {
    private static final Logger logger = LoggerFactory.getLogger(BridgeNavigationHandlerImpl.class);
    private NavigationHandler wrappedNavigationHandler;

    public BridgeNavigationHandlerImpl(NavigationHandler navigationHandler) {
        this.wrappedNavigationHandler = navigationHandler;
    }

    @Override
    public void handleNavigation(FacesContext facesContext, String fromAction, String outcome) {
        block18: {
            Map parameters;
            logger.debug("fromAction=[{0}] outcome=[{1}]", fromAction, outcome);
            NavigationCase navigationCase = this.getNavigationCase(facesContext, fromAction, outcome);
            this.wrappedNavigationHandler.handleNavigation(facesContext, fromAction, outcome);
            if (navigationCase != null && (parameters = navigationCase.getParameters()) != null) {
                StateAwareResponse stateAwareResponse;
                PortletResponse portletResponse;
                List parameterValues;
                block17: {
                    parameterValues = (List)parameters.get("javax.portlet.faces.PortletMode");
                    portletResponse = (PortletResponse)facesContext.getExternalContext().getResponse();
                    if (parameterValues != null && parameterValues.size() > 0) {
                        String portletMode = (String)parameterValues.get(0);
                        if (portletResponse instanceof StateAwareResponse) {
                            stateAwareResponse = (StateAwareResponse)portletResponse;
                            try {
                                if (PortletMode.VIEW.toString().equalsIgnoreCase(portletMode)) {
                                    logger.debug("Switching to PortletMode.VIEW due to to-view-id in navigation-case");
                                    stateAwareResponse.setPortletMode(PortletMode.VIEW);
                                    break block17;
                                }
                                if (PortletMode.EDIT.toString().equalsIgnoreCase(portletMode)) {
                                    stateAwareResponse.setPortletMode(PortletMode.EDIT);
                                    logger.debug("Switching to PortletMode.EDIT because of to-view-id in navigation-case");
                                    break block17;
                                }
                                if (PortletMode.HELP.toString().equalsIgnoreCase(portletMode)) {
                                    stateAwareResponse.setPortletMode(PortletMode.HELP);
                                    logger.debug("Switching to PortletMode.HELP because of to-view-id in navigation-case");
                                    break block17;
                                }
                                logger.error("Unable to switch to portletMode=[{0}]", portletMode);
                            }
                            catch (Exception e) {
                                logger.error(e);
                            }
                        } else {
                            logger.error("Unable to set PortletMode because response is not a StateAwareResponse");
                        }
                    }
                }
                if ((parameterValues = (List)parameters.get("javax.portlet.faces.WindowState")) != null && parameterValues.size() > 0) {
                    String windowState = (String)parameterValues.get(0);
                    if (portletResponse instanceof StateAwareResponse) {
                        stateAwareResponse = (StateAwareResponse)portletResponse;
                        try {
                            if (WindowState.MAXIMIZED.toString().equalsIgnoreCase(windowState)) {
                                logger.debug("Switching to WindowState.MAXIMIZED because of to-view-id in navigation-case");
                                stateAwareResponse.setWindowState(WindowState.MAXIMIZED);
                                break block18;
                            }
                            if (WindowState.MINIMIZED.toString().equalsIgnoreCase(windowState)) {
                                logger.debug("Switching to WindowState.MINIMIZED because of to-view-id in navigation-case");
                                stateAwareResponse.setWindowState(WindowState.MINIMIZED);
                                break block18;
                            }
                            if (WindowState.NORMAL.toString().equalsIgnoreCase(windowState)) {
                                logger.debug("Switching to WindowState.NORMAL because of to-view-id in navigation-case");
                                stateAwareResponse.setWindowState(WindowState.NORMAL);
                                break block18;
                            }
                            logger.error("Unable to switch to windowState=[{0}]", windowState);
                        }
                        catch (Exception e) {
                            logger.error(e);
                        }
                    } else {
                        logger.error("Unable to set WindowState because response is not a StateAwareResponse");
                    }
                }
            }
        }
    }

    @Override
    public void handleNavigation(FacesContext facesContext, PortletMode fromPortletMode, PortletMode toPortletMode) {
        String toPortletModeAsString;
        String fromPortletModeAsString;
        logger.debug("fromPortletMode=[{0}] toPortletMode=[{1}]", fromPortletMode, toPortletMode);
        if (fromPortletMode != null && toPortletMode != null && !(fromPortletModeAsString = fromPortletMode.toString()).equals(toPortletModeAsString = toPortletMode.toString())) {
            logger.debug("Detected portlet mode change");
            String currentViewId = facesContext.getViewRoot().getViewId();
            BridgeContext bridgeContext = (BridgeContext)facesContext.getAttributes().get("javax.portlet.faces.bridgeContext");
            Map<String, String> defaultViewIdMap = bridgeContext.getDefaultViewIdMap();
            String portletModeViewId = defaultViewIdMap.get(toPortletModeAsString);
            if (currentViewId != null && portletModeViewId != null && !currentViewId.equals(portletModeViewId)) {
                logger.debug("navigating to viewId=[{0}]", portletModeViewId);
                ViewHandler viewHandler = facesContext.getApplication().getViewHandler();
                UIViewRoot viewRoot = viewHandler.createView(facesContext, portletModeViewId);
                if (viewRoot != null) {
                    facesContext.setViewRoot(viewRoot);
                    PartialViewContext partialViewContext = facesContext.getPartialViewContext();
                    partialViewContext.setRenderAll(true);
                }
            }
        }
    }

    public NavigationCase getNavigationCase(FacesContext facesContext, String fromAction, String outcome) {
        if (this.wrappedNavigationHandler instanceof ConfigurableNavigationHandler) {
            ConfigurableNavigationHandler wrappedConfigurableNavigationHandler = (ConfigurableNavigationHandler)this.wrappedNavigationHandler;
            return wrappedConfigurableNavigationHandler.getNavigationCase(facesContext, fromAction, outcome);
        }
        throw new UnsupportedOperationException("JSF runtime does not provide an instance of ConfigurableNavigationHandler");
    }

    public Map<String, Set<NavigationCase>> getNavigationCases() {
        if (this.wrappedNavigationHandler instanceof ConfigurableNavigationHandler) {
            ConfigurableNavigationHandler wrappedConfigurableNavigationHandler = (ConfigurableNavigationHandler)this.wrappedNavigationHandler;
            return wrappedConfigurableNavigationHandler.getNavigationCases();
        }
        throw new UnsupportedOperationException("JSF runtime does not provide an instance of ConfigurableNavigationHandler");
    }
}

