/*
 * Decompiled with CFR 0.152.
 */
package org.portletfaces.bridge.application;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.Channels;
import java.util.Map;
import javax.faces.application.Resource;
import javax.faces.application.ResourceHandler;
import javax.faces.application.ResourceHandlerWrapper;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.portletfaces.bridge.BridgeFactoryFinder;
import org.portletfaces.bridge.application.MissingResourceImpl;
import org.portletfaces.bridge.application.ResourceImpl;
import org.portletfaces.bridge.container.PortletContainer;
import org.portletfaces.bridge.container.PortletContainerFactory;
import org.portletfaces.bridge.context.BridgeContext;
import org.portletfaces.logging.Logger;
import org.portletfaces.logging.LoggerFactory;

public class ResourceHandlerImpl
extends ResourceHandlerWrapper {
    private static final Logger logger = LoggerFactory.getLogger(ResourceHandlerImpl.class);
    public static final String JAVAX_FACES_RESOURCE = "javax.faces.resource";
    public static final String RICH_FACES_RESOURCE = "rfRes";
    public static final String REQUEST_PARAM_LIBRARY_NAME = "ln";
    public static final String REQUEST_PARAM_VERSION = "v";
    private static final String ENCODED_RESOURCE_TOKEN = "javax.faces.resource=";
    private Integer resourceBufferSize;
    private ResourceHandler wrappedResourceHandler;

    public ResourceHandlerImpl(ResourceHandler wrappedResourceHandler) {
        this.wrappedResourceHandler = wrappedResourceHandler;
    }

    public static boolean isEncodedFacesResourceURL(String url) {
        return url != null && url.indexOf(ENCODED_RESOURCE_TOKEN) > 0;
    }

    public static boolean isFacesResourceURL(String url) {
        return url != null && url.indexOf(JAVAX_FACES_RESOURCE) >= 0;
    }

    public Resource createResource(String resourceName) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        BridgeFactoryFinder bridgeFactoryFinder = BridgeFactoryFinder.getInstance();
        PortletContainerFactory portletContainerFactory = (PortletContainerFactory)bridgeFactoryFinder.getFactory("org.portletfaces.bridge.container.PortletContainerFactory");
        BridgeContext bridgeContext = (BridgeContext)facesContext.getAttributes().get("javax.portlet.faces.bridgeContext");
        PortletContainer portletContainer = portletContainerFactory.getPortletContainer(bridgeContext);
        Resource wrappableResource = this.wrappedResourceHandler.createResource(resourceName);
        if (wrappableResource == null) {
            return new MissingResourceImpl(this.wrappedResourceHandler, resourceName);
        }
        return new ResourceImpl(wrappableResource, portletContainer);
    }

    public Resource createResource(String resourceName, String libraryName) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        BridgeFactoryFinder bridgeFactoryFinder = BridgeFactoryFinder.getInstance();
        PortletContainerFactory portletContainerFactory = (PortletContainerFactory)bridgeFactoryFinder.getFactory("org.portletfaces.bridge.container.PortletContainerFactory");
        BridgeContext bridgeContext = (BridgeContext)facesContext.getAttributes().get("javax.portlet.faces.bridgeContext");
        PortletContainer portletContainer = portletContainerFactory.getPortletContainer(bridgeContext);
        Resource wrappableResource = this.wrappedResourceHandler.createResource(resourceName, libraryName);
        if (wrappableResource == null) {
            return new MissingResourceImpl(this.wrappedResourceHandler, resourceName, libraryName);
        }
        return new ResourceImpl(wrappableResource, portletContainer);
    }

    public Resource createResource(String resourceName, String libraryName, String contentType) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        BridgeFactoryFinder bridgeFactoryFinder = BridgeFactoryFinder.getInstance();
        PortletContainerFactory portletContainerFactory = (PortletContainerFactory)bridgeFactoryFinder.getFactory("org.portletfaces.bridge.container.PortletContainerFactory");
        BridgeContext bridgeContext = (BridgeContext)facesContext.getAttributes().get("javax.portlet.faces.bridgeContext");
        PortletContainer portletContainer = portletContainerFactory.getPortletContainer(bridgeContext);
        Resource wrappableResource = this.wrappedResourceHandler.createResource(resourceName, libraryName, contentType);
        if (wrappableResource == null) {
            return new MissingResourceImpl(this.wrappedResourceHandler, resourceName, libraryName, contentType);
        }
        return new ResourceImpl(wrappableResource, portletContainer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handleResourceRequest(FacesContext facesContext) throws IOException {
        ExternalContext externalContext = facesContext.getExternalContext();
        Map requestParameterMap = externalContext.getRequestParameterMap();
        String resourceName = (String)requestParameterMap.get(JAVAX_FACES_RESOURCE);
        if (resourceName != null) {
            BridgeContext bridgeContext;
            String libraryName = (String)requestParameterMap.get(REQUEST_PARAM_LIBRARY_NAME);
            Object locale = null;
            Object version = null;
            if (logger.isTraceEnabled()) {
                logger.trace("Handling - resourceName=[{0}], libraryName[{1}], locale=[{2}], version=[{3}]", resourceName, libraryName, locale, version);
            }
            ResourceHandler resourceHandlerChain = facesContext.getApplication().getResourceHandler();
            Resource resource = null;
            resource = libraryName == null ? resourceHandlerChain.createResource(resourceName) : resourceHandlerChain.createResource(resourceName, libraryName);
            boolean needsUpdate = resource.userAgentNeedsUpdate(facesContext);
            BridgeFactoryFinder bridgeFactoryFinder = BridgeFactoryFinder.getInstance();
            PortletContainerFactory portletContainerFactory = (PortletContainerFactory)bridgeFactoryFinder.getFactory("org.portletfaces.bridge.container.PortletContainerFactory");
            PortletContainer portletContainer = portletContainerFactory.getPortletContainer(bridgeContext = (BridgeContext)facesContext.getAttributes().get("javax.portlet.faces.bridgeContext"));
            if (!portletContainer.isAbleToSetHttpStatusCode() && !needsUpdate) {
                needsUpdate = true;
                logger.debug("Portlet container is not able to set PortletResponse.HTTP_STATUS_CODE to HttpServletResponse.SC_NOT_MODIFIED ({0}) for resourceName=[{1}]", 304, resourceName);
            }
            if (needsUpdate) {
                logger.trace("Handling - Resource was either modified or has not yet been downloaded.");
                Channel readableByteChannel = null;
                Channel writableByteChannel = null;
                InputStream inputStream = null;
                int bufferSize = this.getResourceBufferSize(externalContext);
                ByteBuffer byteBuffer = ByteBuffer.allocate(bufferSize);
                try {
                    inputStream = resource.getInputStream();
                    if (inputStream != null) {
                        Map responseHeaderMap = resource.getResponseHeaders();
                        if (responseHeaderMap != null) {
                            for (Map.Entry mapEntry : responseHeaderMap.entrySet()) {
                                String name = (String)mapEntry.getKey();
                                String value = (String)mapEntry.getValue();
                                externalContext.setResponseHeader(name, value);
                                if (!logger.isDebugEnabled()) continue;
                                logger.debug("Handling - COPIED resource header name=[{0}] value=[{1}]", name, value);
                            }
                        }
                        int responseBufferSize = byteBuffer.capacity();
                        externalContext.setResponseBufferSize(responseBufferSize);
                        if (logger.isTraceEnabled()) {
                            logger.trace("Handling - responseBufferSize=[{0}]", Integer.toString(responseBufferSize));
                        }
                        String responseContentType = resource.getContentType();
                        logger.trace("Handling - responseContentType=[{0}]", responseContentType);
                        if (responseContentType != null) {
                            externalContext.setResponseContentType(responseContentType);
                        }
                        int responseContentLength = 0;
                        readableByteChannel = Channels.newChannel(inputStream);
                        writableByteChannel = Channels.newChannel(externalContext.getResponseOutputStream());
                        int bytesRead = readableByteChannel.read(byteBuffer);
                        if (logger.isTraceEnabled()) {
                            logger.trace("Handling - bytesRead=[{0}]", Integer.toString(bytesRead));
                        }
                        int bytesWritten = 0;
                        while (bytesRead != -1) {
                            byteBuffer.rewind();
                            byteBuffer.limit(bytesRead);
                            while ((bytesWritten += writableByteChannel.write(byteBuffer)) < responseContentLength) {
                            }
                            byteBuffer.clear();
                            responseContentLength += bytesRead;
                            bytesRead = readableByteChannel.read(byteBuffer);
                            if (!logger.isTraceEnabled()) continue;
                            logger.trace("Handling - MORE bytesRead=[{0}]", Integer.toString(bytesRead));
                        }
                        externalContext.setResponseContentLength(responseContentLength);
                        externalContext.setResponseStatus(200);
                        if (!logger.isDebugEnabled()) return;
                        logger.debug("HANDLED (SC_OK) resourceName=[{0}], libraryName[{1}], locale=[{2}], version=[{3}], responseContentType=[{4}], responseContentLength=[{5}]", resourceName, libraryName, locale, version, responseContentType, responseContentLength);
                        return;
                    }
                    externalContext.setResponseStatus(404);
                    logger.error("NOT HANDLED (SC_NOT_FOUND) because InputStream was null - resourceName=[{0}], libraryName[{1}], locale=[{2}], version=[{3}]", resourceName, libraryName, locale, version);
                    return;
                }
                catch (IOException e) {
                    externalContext.setResponseStatus(404);
                    logger.error("NOT HANDLED (SC_NOT_FOUND) resourceName=[{0}], libraryName[{1}], locale=[{2}], version=[{3}] errorMessage=[{4}]", new Object[]{resourceName, libraryName, locale, version, e.getMessage()}, e);
                    return;
                }
                finally {
                    if (writableByteChannel != null) {
                        writableByteChannel.close();
                    }
                    if (readableByteChannel != null) {
                        readableByteChannel.close();
                    }
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
            } else {
                externalContext.setResponseStatus(304);
                if (!logger.isDebugEnabled()) return;
                logger.debug("HANDLED (SC_NOT_MODIFIED) resourceName=[{0}], libraryName[{1}], locale=[{2}], version=[{3}]", resourceName, libraryName, locale, version);
            }
            return;
        } else {
            logger.debug("NOT HANDLED - Missing request parameter {0} so delegating handleResourceRequest to chain", JAVAX_FACES_RESOURCE);
            this.wrappedResourceHandler.handleResourceRequest(facesContext);
        }
    }

    protected int getResourceBufferSize(ExternalContext externalContext) {
        if (this.resourceBufferSize == null) {
            this.resourceBufferSize = 1024;
            String sizeAsString = externalContext.getInitParameter("org.portletfaces.bridge.resourceBufferSize");
            if (sizeAsString != null) {
                try {
                    this.resourceBufferSize = Integer.parseInt(sizeAsString);
                    logger.debug("Found portlet.xml init-param name=[{0}] value=[{1}]", "org.portletfaces.bridge.resourceBufferSize", this.resourceBufferSize);
                }
                catch (NumberFormatException e) {
                    logger.error("Invalid value=[{0}] for portlet.xml init-param {1}", sizeAsString, "org.portletfaces.bridge.resourceBufferSize");
                }
            } else {
                logger.debug("Returning default portletResourceBufferSize=[{0}]", this.resourceBufferSize);
            }
        }
        return this.resourceBufferSize;
    }

    public boolean isResourceRequest(FacesContext facesContext) {
        ExternalContext externalContext = facesContext.getExternalContext();
        Map requestParameterMap = externalContext.getRequestParameterMap();
        String resourceId = (String)requestParameterMap.get(JAVAX_FACES_RESOURCE);
        if (resourceId != null) {
            logger.debug("Bridge found {0} request parameter and recognized resourceId=[{1}] as a resource", JAVAX_FACES_RESOURCE, resourceId);
            return true;
        }
        logger.debug("Bridge did not find the {0} request parameter so delegating isResourceRequest to chain", JAVAX_FACES_RESOURCE);
        return this.wrappedResourceHandler.isResourceRequest(facesContext);
    }

    public ResourceHandler getWrapped() {
        return this.wrappedResourceHandler;
    }
}

