/*
 * Decompiled with CFR 0.152.
 */
package org.portletfaces.bridge.application;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.net.URLConnection;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.faces.application.Resource;
import javax.faces.application.ResourceWrapper;
import javax.faces.context.FacesContext;
import org.portletfaces.bridge.container.PortletContainer;
import org.portletfaces.logging.Logger;
import org.portletfaces.logging.LoggerFactory;

public class ResourceImpl
extends ResourceWrapper
implements Serializable {
    private static final long serialVersionUID = 827821821511052062L;
    private static final Logger logger = LoggerFactory.getLogger(ResourceImpl.class);
    private static final String HEADER_IF_MODIFIED_SINCE = "If-Modified-Since";
    private static final String HTTP_SPEC_DATE_PATTERN = "EEE, dd MMM yyyy HH:mm:ss zzz";
    private static final String RESOURCE_NAME_JSF_JS = "jsf.js";
    private static final String RESOURCE_NAME_ICEFACES_BRIDGE = "bridge.js";
    private static final String RESOURCE_NAME_ICEFACES_PUSH = "icepush.js";
    private static final String RESOURCE_NAME_ICEFACES_COMPAT = "compat.js";
    private static final String RESOURCE_NAME_ICEFACES_OTHER_COMPAT = "icefaces-compat.js";
    private static final ArrayList<String> NON_CACHED_RESOURCES = new ArrayList(5);
    private Long lastModifiedInSeconds;
    private PortletContainer portletContainer;
    private Resource wrappedResource;

    public ResourceImpl() {
    }

    public ResourceImpl(Resource wrappedResource, PortletContainer portletContainer) {
        this.wrappedResource = wrappedResource;
        this.portletContainer = portletContainer;
    }

    public String toString() {
        return this.wrappedResource.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean userAgentNeedsUpdate(FacesContext facesContext) {
        String resourceName = this.getResourceName();
        boolean needsUpdate = this.wrappedResource.userAgentNeedsUpdate(facesContext);
        if (!needsUpdate) {
            if (NON_CACHED_RESOURCES.contains(resourceName)) {
                needsUpdate = true;
            } else {
                if (this.lastModifiedInSeconds == null) {
                    URL url = this.wrappedResource.getURL();
                    if (url != null) {
                        InputStream inputStream = null;
                        try {
                            URLConnection urlConnection = url.openConnection();
                            urlConnection.setUseCaches(false);
                            urlConnection.connect();
                            inputStream = urlConnection.getInputStream();
                            long lastModifiedInMilliSeconds = urlConnection.getLastModified();
                            this.lastModifiedInSeconds = new Long(lastModifiedInMilliSeconds / 1000L);
                        }
                        catch (IOException e) {
                            this.lastModifiedInSeconds = new Long(0L);
                        }
                        finally {
                            if (inputStream != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (IOException e) {}
                            }
                        }
                    } else {
                        logger.warn("Unable to determine if user agent needs update because resource URL was null for resourceName=[{0}].", resourceName);
                    }
                }
                if (this.lastModifiedInSeconds != null) {
                    long ifModifiedHeaderInSeconds = 0L;
                    Map requestHeaderMap = facesContext.getExternalContext().getRequestHeaderMap();
                    if (requestHeaderMap.containsKey(HEADER_IF_MODIFIED_SINCE)) {
                        String requestHeaderValue = (String)requestHeaderMap.get(HEADER_IF_MODIFIED_SINCE);
                        try {
                            SimpleDateFormat httpSpecDateFormat = new SimpleDateFormat(HTTP_SPEC_DATE_PATTERN, Locale.US);
                            httpSpecDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
                            long ifModifiedHeaderInMilliSeconds = httpSpecDateFormat.parse(requestHeaderValue).getTime();
                            ifModifiedHeaderInSeconds = ifModifiedHeaderInMilliSeconds / 1000L;
                            if (logger.isDebugEnabled()) {
                                logger.debug("resourceName=[{0}] requestHeaderValue=[{1}] ifModifiedHeaderInSeconds=[{2}]", resourceName, requestHeaderValue, Long.toString(ifModifiedHeaderInSeconds));
                            }
                        }
                        catch (ParseException e) {
                            logger.error("Unable to parse request-header=[{0}] value=[{1}]", HEADER_IF_MODIFIED_SINCE, requestHeaderValue);
                        }
                    } else {
                        long ifModifiedHeaderInMilliSeconds = this.portletContainer.getHttpServletRequestDateHeader(HEADER_IF_MODIFIED_SINCE);
                        ifModifiedHeaderInSeconds = ifModifiedHeaderInMilliSeconds / 1000L;
                        if (logger.isDebugEnabled()) {
                            logger.debug("resourceName=[{0}] portletContainer ifModifiedHeaderInSeconds=[{1}]", resourceName, Long.toString(ifModifiedHeaderInSeconds));
                        }
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("resourceName=[{0}] lastModified=[{1}] ifModifiedHeaderInSeconds=[{2}]", resourceName, Long.toString(this.lastModifiedInSeconds), Long.toString(ifModifiedHeaderInSeconds));
                    }
                    needsUpdate = this.lastModifiedInSeconds > ifModifiedHeaderInSeconds;
                }
            }
        }
        logger.debug("resourceName=[{0}] needsUpdate=[{1}]", resourceName, needsUpdate);
        return needsUpdate;
    }

    public String getContentType() {
        return this.wrappedResource.getContentType();
    }

    public void setContentType(String contentType) {
        this.wrappedResource.setContentType(contentType);
    }

    public String getLibraryName() {
        return this.wrappedResource.getLibraryName();
    }

    public void setLibraryName(String libraryName) {
        this.wrappedResource.setLibraryName(libraryName);
    }

    public String getRequestPath() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        return facesContext.getExternalContext().encodeResourceURL(this.wrappedResource.getRequestPath());
    }

    public String getResourceName() {
        return this.wrappedResource.getResourceName();
    }

    public void setResourceName(String resourceName) {
        this.wrappedResource.setResourceName(resourceName);
    }

    public Resource getWrapped() {
        return this.wrappedResource;
    }

    static {
        NON_CACHED_RESOURCES.add(RESOURCE_NAME_JSF_JS);
        NON_CACHED_RESOURCES.add(RESOURCE_NAME_ICEFACES_BRIDGE);
        NON_CACHED_RESOURCES.add(RESOURCE_NAME_ICEFACES_PUSH);
        NON_CACHED_RESOURCES.add(RESOURCE_NAME_ICEFACES_COMPAT);
        NON_CACHED_RESOURCES.add(RESOURCE_NAME_ICEFACES_OTHER_COMPAT);
    }
}

